/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraftforge.client.event.GuiScreenEvent;

public class LanguageNarrator {
    private String lastHoveredElement = null;
    private long hoverStartTime = -1L;
    private String lastNarratedHoverText = null;
    int delay = NarratorConfig.languageNarratorHoverDelay;

    @SubscribeEvent
    public void onGuiScreenDisplayed(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableLanguageListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (!(event.gui instanceof GuiLanguage)) {
            this.lastHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedHoverText = null;
            return;
        }
        try {
            Field languageListField;
            int titleY;
            GuiLanguage guiLanguage = (GuiLanguage)event.gui;
            FontRenderer fontRenderer = this.findFontRenderer((GuiScreen)guiLanguage);
            if (fontRenderer == null) {
                return;
            }
            String narrationText = null;
            String currentHoveredElement = null;
            String titleText = I18n.func_135052_a((String)"options.language", (Object[])new Object[0]);
            int titleWidth = fontRenderer.func_78256_a(titleText);
            int titleX = (guiLanguage.field_146294_l - titleWidth) / 2 - 1;
            if (this.isMouseOver(event.mouseX, event.mouseY, titleX, titleY = 15, titleWidth, fontRenderer.field_78288_b)) {
                narrationText = titleText;
                currentHoveredElement = "language_title";
            }
            if (narrationText == null) {
                String warningText = "(" + I18n.func_135052_a((String)"options.languageWarning", (Object[])new Object[0]) + ")";
                int xCenter = guiLanguage.field_146294_l / 2 - 1;
                int yStart = guiLanguage.field_146295_m - 57;
                int textWidth = fontRenderer.func_78256_a(warningText);
                int xStart = xCenter - textWidth / 2;
                if (this.isMouseOver(event.mouseX, event.mouseY, xStart, yStart, textWidth, fontRenderer.field_78288_b)) {
                    narrationText = warningText;
                    currentHoveredElement = "language_warning";
                }
            }
            if (narrationText == null && (languageListField = this.findField(GuiLanguage.class, "field_146450_f", "field_146450_f")) != null) {
                Object languageList = languageListField.get(guiLanguage);
                Field topField = this.findField(languageList.getClass(), "field_148153_b", "top");
                Field bottomField = this.findField(languageList.getClass(), "field_148154_c", "bottom");
                if (topField != null && bottomField != null) {
                    int slotIndex;
                    Method getSlotIndexMethod;
                    int listTop = (Integer)topField.get(languageList);
                    int listBottom = (Integer)bottomField.get(languageList);
                    if (event.mouseY >= listTop && event.mouseY <= listBottom && (getSlotIndexMethod = this.findMethod(languageList.getClass())) != null && (slotIndex = ((Integer)getSlotIndexMethod.invoke(languageList, event.mouseX, event.mouseY + 2)).intValue()) >= 0) {
                        Field languageMapField = this.findField(languageList.getClass(), "field_148177_m", "field_148177_m");
                        Field languageCodeListField = this.findField(languageList.getClass(), "field_148176_l", "field_148176_l");
                        if (languageMapField != null && languageCodeListField != null) {
                            String languageCode;
                            Language language;
                            Map languageMap = (Map)languageMapField.get(languageList);
                            List languageCodeList = (List)languageCodeListField.get(languageList);
                            if (slotIndex < languageCodeList.size() && (language = (Language)languageMap.get(languageCode = (String)languageCodeList.get(slotIndex))) != null) {
                                narrationText = language.toString();
                                currentHoveredElement = "language_entry_" + slotIndex;
                            }
                        }
                    }
                }
            }
            if (currentHoveredElement != null) {
                if (!Objects.equals(currentHoveredElement, this.lastHoveredElement)) {
                    this.lastHoveredElement = currentHoveredElement;
                    this.hoverStartTime = System.currentTimeMillis();
                    this.lastNarratedHoverText = null;
                } else if (this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay && narrationText != null && !narrationText.equals(this.lastNarratedHoverText)) {
                    AudioPlayer.speakAsync(narrationText);
                    this.lastNarratedHoverText = narrationText;
                }
            } else {
                this.lastHoveredElement = null;
                this.hoverStartTime = -1L;
                this.lastNarratedHoverText = null;
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Failed to narrate language screen: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private Field findField(Class<?> clazz, String srgName, String deobfName) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Field field = currentClass.getDeclaredField(srgName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                try {
                    Field field = currentClass.getDeclaredField(deobfName);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private Method findMethod(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Method method = currentClass.getDeclaredMethod("func_148124_c", Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    private FontRenderer findFontRenderer(GuiScreen screen) {
        try {
            Field fontRendererField = this.findField(GuiScreen.class, "field_146289_q", "fontRendererObj");
            if (fontRendererField != null) {
                return (FontRenderer)fontRendererField.get(screen);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

