/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class MainMenuNarrator {
    private String lastNarratedText = null;
    private Object currentHoveredElement = null;
    private long hoverStartTime = -1L;
    private static final float ROTATION_DEGREES = -20.0f;
    int delay = NarratorConfig.mainMenuNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableMainMenuListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (!(event.gui instanceof GuiMainMenu)) {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
            return;
        }
        GuiMainMenu mainMenu = (GuiMainMenu)event.gui;
        Minecraft mc = Minecraft.func_71410_x();
        String hoveredElement = null;
        int mouseX = Mouse.getX() * mainMenu.field_146294_l / mc.field_71443_c;
        int mouseY = mainMenu.field_146295_m - Mouse.getY() * mainMenu.field_146295_m / mc.field_71440_d - 1;
        try {
            String splashText;
            Field splashTextField = this.findField();
            if (splashTextField != null && (splashText = (String)splashTextField.get(mainMenu)) != null && !splashText.isEmpty()) {
                int stringWidth = mc.field_71466_p.func_78256_a(splashText);
                float f1 = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Minecraft.func_71386_F() % 1000L) / 1000.0f * (float)Math.PI * 2.0f)) * 0.1f));
                int translationX = mainMenu.field_146294_l / 2 + 90;
                int translationY = 70;
                if (this.isMouseOverRotated(translationX, translationY, stringWidth, mc.field_71466_p.field_78288_b, f1 = f1 * 100.0f / (float)(stringWidth + 32), mouseX, mouseY)) {
                    hoveredElement = splashText;
                }
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Failed to access splash text: " + e.getMessage());
            e.printStackTrace();
        }
        if (hoveredElement == null) {
            int lineHeight = mc.field_71466_p.field_78288_b;
            List brandings = FMLCommonHandler.instance().getBrandings(true);
            ArrayList mutableBrandings = new ArrayList(brandings);
            Collections.reverse(mutableBrandings);
            for (int i = 0; i < mutableBrandings.size(); ++i) {
                int width;
                int y;
                int x;
                String branding = (String)mutableBrandings.get(i);
                if (branding == null || branding.isEmpty() || !this.isMouseOver(x = 1, y = mainMenu.field_146295_m - (11 + i * (lineHeight + 1)), width = mc.field_71466_p.func_78256_a(branding), lineHeight, mouseX, mouseY)) continue;
                hoveredElement = branding;
                break;
            }
            if (hoveredElement == null) {
                String copyrightText = "Copyright Mojang AB. Do not distribute!";
                int y = mainMenu.field_146295_m - 11;
                int x = mainMenu.field_146294_l - mc.field_71466_p.func_78256_a(copyrightText) - 3;
                if (this.isMouseOver(x, y, mc.field_71466_p.func_78256_a(copyrightText), lineHeight, mouseX, mouseY)) {
                    hoveredElement = copyrightText;
                }
            }
        }
        if (hoveredElement != null) {
            String narrationText;
            if (hoveredElement != this.currentHoveredElement) {
                this.currentHoveredElement = hoveredElement;
                this.hoverStartTime = System.currentTimeMillis();
                this.lastNarratedText = null;
            } else if (System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay && !(narrationText = EnumChatFormatting.func_110646_a((String)hoveredElement).trim()).equals(this.lastNarratedText)) {
                AudioPlayer.speakAsync(narrationText);
                this.lastNarratedText = narrationText;
            }
        } else {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
        }
    }

    private Field findField() {
        for (Class currentClass = GuiMainMenu.class; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Field field = currentClass.getDeclaredField("field_73975_c");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                try {
                    Field field = currentClass.getDeclaredField("splashText");
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private boolean isMouseOverRotated(int rotationCenterX, int rotationCenterY, int textWidth, int textHeight, float scale, int mouseX, int mouseY) {
        float relX = mouseX - rotationCenterX;
        float relY = mouseY - rotationCenterY;
        float theta = (float)Math.toRadians(-20.0);
        float cos = MathHelper.func_76134_b((float)(-theta));
        float sin = MathHelper.func_76126_a((float)(-theta));
        float unrotX = relX * cos - relY * sin;
        float unrotY = relX * sin + relY * cos;
        float localX = unrotX / scale;
        float localY = unrotY / scale;
        float localYAdjusted = localY + 8.0f;
        return localX >= (float)(-textWidth) / 2.0f && localX <= (float)textWidth / 2.0f && localYAdjusted >= 0.0f && localYAdjusted <= (float)textHeight;
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

