/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiMemoryErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Mouse;

public class MessageScreenNarrator {
    private final Minecraft mc = Minecraft.func_71410_x();
    private String lastNarratedText = null;
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    int delay = NarratorConfig.messageScreenNarratorHoverDelay;
    private GuiScreen lastGui = null;
    private static final String[] OOM_TEXT_LINES = new String[]{"Out of memory!", "Minecraft has run out of memory.", "This could be caused by a bug in the game or by the", "Java Virtual Machine not being allocated enough", "memory.", "To prevent level corruption, the current game has quit.", "We've tried to free up enough memory to let you go back to", "the main menu and back to playing, but this may not have worked.", "Please restart the game if you see this message again."};
    private static final String OOM_NARRATION_BLOCK_1 = OOM_TEXT_LINES[2] + " " + OOM_TEXT_LINES[3] + " " + OOM_TEXT_LINES[4];
    private static final String OOM_NARRATION_BLOCK_2 = OOM_TEXT_LINES[5] + " " + OOM_TEXT_LINES[6] + " " + OOM_TEXT_LINES[7] + " " + OOM_TEXT_LINES[8];

    private static String cleanFormatting(String text) {
        if (text == null) {
            return null;
        }
        return StringUtils.func_76338_a((String)text);
    }

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        block49: {
            if (!NarratorConfig.enableMessageScreenListener || !KeybindHandler.isNarratorEnabled()) {
                return;
            }
            GuiScreen currentGui = event.gui;
            if (currentGui != this.lastGui) {
                this.currentHoveredElement = null;
                this.hoverStartTime = -1L;
                this.lastNarratedText = null;
                this.lastGui = currentGui;
            }
            if (this.currentHoveredElement != null && !(this.currentHoveredElement instanceof String)) {
                this.currentHoveredElement = null;
                this.hoverStartTime = -1L;
            }
            try {
                if (currentGui instanceof GuiMemoryErrorScreen) {
                    int lineWidth;
                    int lineX;
                    int i;
                    int line1Width;
                    int line1X;
                    int mouseX = Mouse.getX() * currentGui.field_146294_l / this.mc.field_71443_c;
                    int mouseY = currentGui.field_146295_m - Mouse.getY() * currentGui.field_146295_m / this.mc.field_71440_d - 1;
                    String narrationText = null;
                    String hoveredElement = null;
                    int[] textY = new int[OOM_TEXT_LINES.length];
                    textY[0] = currentGui.field_146295_m / 4 - 41;
                    textY[1] = currentGui.field_146295_m / 4 - 1;
                    textY[2] = currentGui.field_146295_m / 4 + 17;
                    textY[3] = currentGui.field_146295_m / 4 + 26;
                    textY[4] = currentGui.field_146295_m / 4 + 35;
                    textY[5] = currentGui.field_146295_m / 4 + 53;
                    textY[6] = currentGui.field_146295_m / 4 + 62;
                    textY[7] = currentGui.field_146295_m / 4 + 71;
                    textY[8] = currentGui.field_146295_m / 4 + 80;
                    int titleWidth = this.mc.field_71466_p.func_78256_a(OOM_TEXT_LINES[0]);
                    int titleX = currentGui.field_146294_l / 2 - titleWidth / 2 - 1;
                    if (this.isMouseOver(titleX, textY[0], titleWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                        narrationText = OOM_TEXT_LINES[0];
                        hoveredElement = OOM_TEXT_LINES[0];
                    }
                    if (hoveredElement == null && this.isMouseOver(line1X = currentGui.field_146294_l / 2 - 141, textY[1], line1Width = this.mc.field_71466_p.func_78256_a(OOM_TEXT_LINES[1]), this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                        narrationText = OOM_TEXT_LINES[1];
                        hoveredElement = OOM_TEXT_LINES[1];
                    }
                    if (hoveredElement == null) {
                        for (i = 2; i <= 4; ++i) {
                            lineX = currentGui.field_146294_l / 2 - 141;
                            lineWidth = this.mc.field_71466_p.func_78256_a(OOM_TEXT_LINES[i]);
                            if (!this.isMouseOver(lineX, textY[i], lineWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) continue;
                            narrationText = OOM_NARRATION_BLOCK_1;
                            hoveredElement = OOM_NARRATION_BLOCK_1;
                            break;
                        }
                    }
                    if (hoveredElement == null) {
                        for (i = 5; i <= 8; ++i) {
                            lineX = currentGui.field_146294_l / 2 - 141;
                            lineWidth = this.mc.field_71466_p.func_78256_a(OOM_TEXT_LINES[i]);
                            if (!this.isMouseOver(lineX, textY[i], lineWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) continue;
                            narrationText = OOM_NARRATION_BLOCK_2;
                            hoveredElement = OOM_NARRATION_BLOCK_2;
                            break;
                        }
                    }
                    if (hoveredElement != null) {
                        if (!Objects.equals(hoveredElement, this.currentHoveredElement)) {
                            this.currentHoveredElement = hoveredElement;
                            this.hoverStartTime = System.currentTimeMillis();
                        } else if (System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                            String cleanedNarrationText = MessageScreenNarrator.cleanFormatting(narrationText);
                            if (!Objects.equals(cleanedNarrationText, this.lastNarratedText)) {
                                AudioPlayer.speakAsync(cleanedNarrationText);
                                this.lastNarratedText = cleanedNarrationText;
                            }
                            this.hoverStartTime = -1L;
                        }
                    } else {
                        this.currentHoveredElement = null;
                        this.hoverStartTime = -1L;
                        this.lastNarratedText = null;
                    }
                    break block49;
                }
                if (currentGui instanceof GuiDisconnected) {
                    String hoveredElement;
                    String narrationText;
                    block50: {
                        GuiDisconnected disconnectedGui = (GuiDisconnected)currentGui;
                        int mouseX = Mouse.getX() * disconnectedGui.field_146294_l / this.mc.field_71443_c;
                        int mouseY = disconnectedGui.field_146295_m - Mouse.getY() * disconnectedGui.field_146295_m / this.mc.field_71440_d - 1;
                        narrationText = null;
                        hoveredElement = null;
                        String screenTitle = null;
                        List reasonLines = null;
                        String fullReasonText = null;
                        try {
                            Field componentField;
                            Field linesField;
                            Field titleField;
                            try {
                                titleField = GuiDisconnected.class.getDeclaredField("field_146306_a");
                            }
                            catch (NoSuchFieldException e) {
                                titleField = GuiDisconnected.class.getDeclaredField("reason");
                            }
                            titleField.setAccessible(true);
                            screenTitle = (String)titleField.get(disconnectedGui);
                            try {
                                linesField = GuiDisconnected.class.getDeclaredField("field_146305_g");
                            }
                            catch (NoSuchFieldException e) {
                                linesField = GuiDisconnected.class.getDeclaredField("multilineMessage");
                            }
                            linesField.setAccessible(true);
                            reasonLines = (List)linesField.get(disconnectedGui);
                            IChatComponent fullReasonComponent = null;
                            try {
                                componentField = GuiDisconnected.class.getDeclaredField("field_146304_f");
                            }
                            catch (NoSuchFieldException e) {
                                componentField = GuiDisconnected.class.getDeclaredField("message");
                            }
                            componentField.setAccessible(true);
                            fullReasonComponent = (IChatComponent)componentField.get(disconnectedGui);
                            if (fullReasonComponent != null) {
                                fullReasonText = fullReasonComponent.func_150260_c();
                            }
                            if (screenTitle == null || reasonLines == null) break block50;
                            int titleY = disconnectedGui.field_146295_m / 2 - 51;
                            int titleWidth = this.mc.field_71466_p.func_78256_a(screenTitle);
                            int titleX = disconnectedGui.field_146294_l / 2 - titleWidth / 2 - 1;
                            if (this.isMouseOver(titleX, titleY, titleWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                                narrationText = screenTitle;
                                hoveredElement = screenTitle;
                            }
                            if (hoveredElement != null) break block50;
                            int startY = titleY + 20;
                            for (int i = 0; i < reasonLines.size(); ++i) {
                                String line = (String)reasonLines.get(i);
                                int lineY = startY + i * this.mc.field_71466_p.field_78288_b;
                                int lineWidth = this.mc.field_71466_p.func_78256_a(line);
                                int lineX = disconnectedGui.field_146294_l / 2 - lineWidth / 2 - 1;
                                if (!this.isMouseOver(lineX, lineY, lineWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) continue;
                                if (fullReasonText != null) {
                                    narrationText = fullReasonText;
                                    hoveredElement = fullReasonText;
                                } else {
                                    narrationText = line;
                                    hoveredElement = line;
                                }
                                break;
                            }
                        }
                        catch (Exception titleField) {
                            // empty catch block
                        }
                    }
                    if (hoveredElement != null) {
                        if (!Objects.equals(hoveredElement, this.currentHoveredElement)) {
                            this.currentHoveredElement = hoveredElement;
                            this.hoverStartTime = System.currentTimeMillis();
                        } else if (System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                            String cleanedNarrationText = MessageScreenNarrator.cleanFormatting(narrationText);
                            if (!Objects.equals(cleanedNarrationText, this.lastNarratedText)) {
                                AudioPlayer.speakAsync(cleanedNarrationText);
                                this.lastNarratedText = cleanedNarrationText;
                            }
                            this.hoverStartTime = -1L;
                        }
                    } else {
                        this.currentHoveredElement = null;
                        this.hoverStartTime = -1L;
                        this.lastNarratedText = null;
                    }
                    break block49;
                }
                if (!(currentGui instanceof GuiConfirmOpenLink)) break block49;
                String warningText = null;
                try {
                    Field warningField;
                    try {
                        warningField = GuiConfirmOpenLink.class.getDeclaredField("field_146363_r");
                    }
                    catch (NoSuchFieldException e) {
                        warningField = GuiConfirmOpenLink.class.getDeclaredField("openLinkWarning");
                    }
                    warningField.setAccessible(true);
                    warningText = (String)warningField.get(currentGui);
                }
                catch (Exception warningField) {
                    // empty catch block
                }
                if (warningText != null) {
                    int textY;
                    int mouseX = Mouse.getX() * currentGui.field_146294_l / this.mc.field_71443_c;
                    int mouseY = currentGui.field_146295_m - Mouse.getY() * currentGui.field_146295_m / this.mc.field_71440_d - 1;
                    int textWidth = this.mc.field_71466_p.func_78256_a(warningText);
                    int textX = currentGui.field_146294_l / 2 - textWidth / 2 - 1;
                    if (this.isMouseOver(textX, textY = 109, textWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                        if (!Objects.equals(warningText, this.currentHoveredElement)) {
                            this.currentHoveredElement = warningText;
                            this.hoverStartTime = System.currentTimeMillis();
                        } else if (System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                            String cleanedNarrationText = MessageScreenNarrator.cleanFormatting(warningText);
                            if (!Objects.equals(cleanedNarrationText, this.lastNarratedText)) {
                                AudioPlayer.speakAsync(cleanedNarrationText);
                                this.lastNarratedText = cleanedNarrationText;
                            }
                            this.hoverStartTime = -1L;
                        }
                    } else {
                        this.currentHoveredElement = null;
                        this.hoverStartTime = -1L;
                        this.lastNarratedText = null;
                    }
                }
            }
            catch (Throwable e) {
                this.currentHoveredElement = null;
                this.hoverStartTime = -1L;
                this.lastNarratedText = null;
                this.lastGui = null;
            }
        }
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

