/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiScreenHorseInventory;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.client.event.GuiScreenEvent;

public class MobNarrator {
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    private String currentNarrationKey = null;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    int delay = NarratorConfig.mobNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableMobListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (!(event.gui instanceof GuiScreenHorseInventory) && !(event.gui instanceof GuiMerchant)) {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
            return;
        }
        int mouseX = event.mouseX;
        int mouseY = event.mouseY;
        if (mouseX == this.lastMouseX && mouseY == this.lastMouseY) {
            if (this.currentHoveredElement != null && this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                HoverResult result = this.getHoverResult(event, mouseX, mouseY);
                if (result != null && result.narrationText != null && !result.narrationText.isEmpty()) {
                    AudioPlayer.speakAsync(result.narrationText);
                }
                this.hoverStartTime = -1L;
            }
            return;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        HoverResult result = this.getHoverResult(event, mouseX, mouseY);
        if (result != null) {
            if (!Objects.equals(this.currentNarrationKey, result.narrationKey)) {
                this.currentHoveredElement = result.hoveredElement;
                this.currentNarrationKey = result.narrationKey;
                this.hoverStartTime = System.currentTimeMillis();
            }
        } else {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
        }
    }

    private HoverResult getHoverResult(GuiScreenEvent.DrawScreenEvent.Post event, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = event.gui;
        try {
            Field guiLeftField = this.findField(GuiContainer.class, "guiLeft", "field_147003_i");
            Field guiTopField = this.findField(GuiContainer.class, "guiTop", "field_147009_r");
            Field ySizeField = this.findField(GuiContainer.class, "ySize", "field_146999_f");
            if (guiLeftField == null || guiTopField == null || ySizeField == null) {
                return null;
            }
            int guiLeft = guiLeftField.getInt(gui);
            int guiTop = guiTopField.getInt(gui);
            if (gui instanceof GuiScreenHorseInventory) {
                int inventoryLabelHeight;
                int horseLabelHeight;
                GuiScreenHorseInventory horseGui = (GuiScreenHorseInventory)gui;
                Field horseInventoryField = this.findField(GuiScreenHorseInventory.class, "field_147029_w", "field_147029_w");
                Field playerInventoryField = this.findField(GuiScreenHorseInventory.class, "field_147030_v", "field_147030_v");
                if (horseInventoryField == null || playerInventoryField == null) {
                    return null;
                }
                IInventory horseInventory = (IInventory)horseInventoryField.get(horseGui);
                IInventory playerInventory = (IInventory)playerInventoryField.get(horseGui);
                int horseLabelX = guiLeft + 7;
                int horseLabelY = guiTop + 5;
                String horseTypeName = horseInventory.func_145818_k_() ? horseInventory.func_145825_b() : I18n.func_135052_a((String)horseInventory.func_145825_b(), (Object[])new Object[0]);
                int horseLabelWidth = mc.field_71466_p.func_78256_a(horseTypeName);
                if (this.isMouseOver(mouseX, mouseY, horseLabelX, horseLabelY, horseLabelWidth, horseLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(horseTypeName, "horse_type", horseTypeName);
                }
                int inventoryLabelX = guiLeft + 7;
                int inventoryLabelY = guiTop + 72;
                String inventoryLabelText = playerInventory.func_145818_k_() ? playerInventory.func_145825_b() : I18n.func_135052_a((String)playerInventory.func_145825_b(), (Object[])new Object[0]);
                int inventoryLabelWidth = mc.field_71466_p.func_78256_a(inventoryLabelText);
                if (this.isMouseOver(mouseX, mouseY, inventoryLabelX, inventoryLabelY, inventoryLabelWidth, inventoryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(inventoryLabelText, "inventory_label", "container.inventory");
                }
            } else if (gui instanceof GuiMerchant) {
                int inventoryLabelHeight;
                int villagerLabelHeight;
                GuiMerchant merchantGui = (GuiMerchant)gui;
                int villagerLabelX = guiLeft + 68;
                int villagerLabelY = guiTop + 5;
                String villagerLabelText = I18n.func_135052_a((String)"entity.Villager.name", (Object[])new Object[0]);
                int villagerLabelWidth = mc.field_71466_p.func_78256_a(villagerLabelText);
                if (this.isMouseOver(mouseX, mouseY, villagerLabelX, villagerLabelY, villagerLabelWidth, villagerLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(villagerLabelText, "villager_name", "entity.Villager.name");
                }
                int inventoryLabelX = guiLeft + 7;
                int inventoryLabelY = guiTop + 72;
                String inventoryLabelText = I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]);
                int inventoryLabelWidth = mc.field_71466_p.func_78256_a(inventoryLabelText);
                if (this.isMouseOver(mouseX, mouseY, inventoryLabelX, inventoryLabelY, inventoryLabelWidth, inventoryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(inventoryLabelText, "inventory_label", "container.inventory");
                }
                Field merchantField = this.findField(GuiMerchant.class, "field_147037_w", "field_147037_w");
                Field selectedTradeField = this.findField(GuiMerchant.class, "field_147041_z", "field_147041_z");
                if (merchantField != null && selectedTradeField != null) {
                    IMerchant merchant = (IMerchant)merchantField.get(merchantGui);
                    int selectedTradeIndex = selectedTradeField.getInt(merchantGui);
                    MerchantRecipeList recipes = merchant.func_70934_b((EntityPlayer)mc.field_71439_g);
                    if (selectedTradeIndex >= 0 && selectedTradeIndex < recipes.size()) {
                        int y;
                        int x;
                        int y2;
                        int x2;
                        int y3;
                        int x3;
                        MerchantRecipe recipe = (MerchantRecipe)recipes.get(selectedTradeIndex);
                        ItemStack input1 = recipe.func_77394_a();
                        if (input1 != null && this.isMouseOver(mouseX, mouseY, x3 = guiLeft + 35, y3 = guiTop + 23, 17, 17)) {
                            List tooltip = input1.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
                            String narrationText = String.join((CharSequence)", ", tooltip);
                            narrationText = narrationText.replaceAll("\u00a7[0-9a-f]", "");
                            return new HoverResult(narrationText, input1.func_82833_r(), "villager_trade_input1");
                        }
                        ItemStack input2 = recipe.func_77396_b();
                        if (input2 != null && this.isMouseOver(mouseX, mouseY, x2 = guiLeft + 61, y2 = guiTop + 23, 17, 17)) {
                            List tooltip = input2.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
                            String narrationText = String.join((CharSequence)", ", tooltip);
                            narrationText = narrationText.replaceAll("\u00a7[0-9a-f]", "");
                            return new HoverResult(narrationText, input2.func_82833_r(), "villager_trade_input2");
                        }
                        ItemStack output = recipe.func_77397_d();
                        if (output != null && this.isMouseOver(mouseX, mouseY, x = guiLeft + 119, y = guiTop + 23, 17, 17)) {
                            List tooltip = output.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
                            String narrationText = String.join((CharSequence)", ", tooltip);
                            narrationText = narrationText.replaceAll("\u00a7[0-9a-f]", "");
                            return new HoverResult(narrationText, output.func_82833_r(), "villager_trade_output");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] An error occurred during mob inventory narration.");
            e.printStackTrace();
        }
        return null;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private Field findField(Class<?> clazz, String deobfName, String srgName) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(deobfName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException f) {
                try {
                    Field f2 = c.getDeclaredField(srgName);
                    f2.setAccessible(true);
                    return f2;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private static class HoverResult {
        public final String narrationText;
        public final Object hoveredElement;
        public final String narrationKey;

        public HoverResult(String text, Object element, String key) {
            this.narrationText = text;
            this.hoveredElement = element;
            this.narrationKey = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HoverResult that = (HoverResult)o;
            return Objects.equals(this.narrationKey, that.narrationKey);
        }

        public int hashCode() {
            return Objects.hash(this.narrationKey);
        }
    }
}

