/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.client.GuiScrollingList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;

@SideOnly(value=Side.CLIENT)
public class ModListNarrator {
    private final Minecraft mc = Minecraft.func_71410_x();
    private Object lastHoveredElement = null;
    private String lastNarratedText = null;
    private long hoverStartTime = -1L;
    int delay = NarratorConfig.modListNarratorHoverDelay;

    @SubscribeEvent
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        String currentHoveredElement;
        String narrationText;
        block33: {
            if (!NarratorConfig.enableModListListener || !KeybindHandler.isNarratorEnabled()) {
                return;
            }
            if (!(event.gui instanceof GuiModList)) {
                this.lastHoveredElement = null;
                this.hoverStartTime = -1L;
                this.lastNarratedText = null;
                return;
            }
            GuiModList gui = (GuiModList)event.gui;
            narrationText = null;
            currentHoveredElement = null;
            try {
                Field selectedModField;
                ModContainer currentSelectedMod;
                String title = "Mod List";
                int titleWidth = this.mc.field_71466_p.func_78256_a(title);
                int titleX = (gui.field_146294_l - titleWidth) / 2 - 1;
                int titleY = 15;
                if (this.isMouseOver(event.mouseX, event.mouseY, titleX, titleY, titleWidth, this.mc.field_71466_p.field_78288_b)) {
                    narrationText = "Mod List";
                    currentHoveredElement = "mod_list_title";
                }
                if (narrationText != null) break block33;
                Field modListField = this.findField(GuiModList.class, "modList", "modList");
                if (modListField == null) {
                    return;
                }
                GuiScrollingList modList = (GuiScrollingList)modListField.get(gui);
                List mods = Loader.instance().getActiveModList();
                if (mods.isEmpty()) {
                    return;
                }
                Field topField = this.findField(GuiScrollingList.class, "top", "top");
                Field bottomField = this.findField(GuiScrollingList.class, "bottom", "bottom");
                Field leftField = this.findField(GuiScrollingList.class, "left", "left");
                Field rightField = this.findField(GuiScrollingList.class, "right", "right");
                Field slotHeightField = this.findField(GuiScrollingList.class, "slotHeight", "slotHeight");
                Field scrollDistanceField = this.findField(GuiScrollingList.class, "scrollDistance", "scrollDistance");
                if (topField != null && bottomField != null && leftField != null && rightField != null && slotHeightField != null && scrollDistanceField != null) {
                    int hoveredIndex;
                    ModContainer mod;
                    ModMetadata metadata;
                    float yOffset;
                    int top = topField.getInt(modList);
                    int bottom = bottomField.getInt(modList);
                    int left = leftField.getInt(modList);
                    int right = rightField.getInt(modList);
                    int slotHeight = slotHeightField.getInt(modList);
                    float scrollDistance = scrollDistanceField.getFloat(modList);
                    if (event.mouseX >= left && event.mouseX + 8 <= right && event.mouseY >= top && event.mouseY <= bottom && (yOffset = (float)(event.mouseY - 3) + scrollDistance - (float)top) >= 0.0f && yOffset < (float)(mods.size() * slotHeight) && (metadata = (mod = (ModContainer)mods.get(hoveredIndex = (int)yOffset / slotHeight)).getMetadata()) != null) {
                        String name = metadata.name != null ? metadata.name : mod.getModId();
                        String version = metadata.version != null ? metadata.version : mod.getDisplayVersion();
                        String childModsInfo = metadata.childMods != null ? metadata.getChildModCountString() : "0 child mods";
                        narrationText = String.format("%s, %s, %s", name, version, childModsInfo);
                        currentHoveredElement = mod;
                    }
                }
                if (narrationText != null || (currentSelectedMod = (ModContainer)(selectedModField = this.findField(GuiModList.class, "selectedMod", "selectedMod")).get(gui)) == null) break block33;
                ModMetadata metadata = currentSelectedMod.getMetadata();
                FontRenderer fontRenderer = this.findFontRenderer((GuiScreen)gui);
                if (metadata != null && !metadata.autogenerated) {
                    int childModsWidth;
                    String childModsText;
                    int urlWidth;
                    int authorsWidth;
                    int modIdWidth;
                    int versionWidth;
                    String nameText;
                    int nameWidth;
                    String logoFile;
                    Field listWidthField = this.findField(GuiModList.class, "listWidth", "listWidth");
                    int listWidth = listWidthField.getInt(gui);
                    int offset = listWidth + 19;
                    int shifty = 34;
                    if (fontRenderer == null) break block33;
                    int fieldHeight = fontRenderer.field_78288_b;
                    int textX = offset;
                    int textSpacing = 10;
                    String string = logoFile = metadata.logoFile != null ? metadata.logoFile : "";
                    if (!logoFile.isEmpty() && !"Forge".equals(metadata.modId)) {
                        shifty += 65;
                    }
                    if (this.isMouseOver(event.mouseX, event.mouseY, textX, shifty, nameWidth = fontRenderer.func_78256_a(nameText = metadata.name), fieldHeight)) {
                        narrationText = nameText;
                        currentHoveredElement = "name_text";
                    }
                    String versionText = String.format("Version: %s (%s)", currentSelectedMod.getDisplayVersion(), currentSelectedMod.getVersion());
                    if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, textX, shifty += 12, versionWidth = fontRenderer.func_78256_a(versionText), fieldHeight)) {
                        narrationText = versionText;
                        currentHoveredElement = "version_text";
                    }
                    String modIdText = String.format("Mod ID: '%s' Mod State: %s", currentSelectedMod.getModId(), Loader.instance().getModState(currentSelectedMod));
                    if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, textX, shifty += textSpacing, modIdWidth = fontRenderer.func_78256_a(modIdText), fieldHeight)) {
                        narrationText = modIdText;
                        currentHoveredElement = "modid_text";
                    }
                    shifty += textSpacing;
                    if (!metadata.credits.isEmpty()) {
                        int creditsWidth;
                        String creditsText = String.format("Credits: %s", metadata.credits);
                        if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, textX, shifty, creditsWidth = fontRenderer.func_78256_a(creditsText), fieldHeight)) {
                            narrationText = creditsText;
                            currentHoveredElement = "credits_text";
                        }
                        shifty += textSpacing;
                    }
                    String authorsText = String.format("Authors: %s", metadata.getAuthorList());
                    if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, textX, shifty, authorsWidth = fontRenderer.func_78256_a(authorsText), fieldHeight)) {
                        narrationText = authorsText;
                        currentHoveredElement = "authors_text";
                    }
                    String urlText = String.format("URL: %s", metadata.url);
                    if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, textX, shifty += textSpacing, urlWidth = fontRenderer.func_78256_a(urlText), fieldHeight)) {
                        narrationText = urlText;
                        currentHoveredElement = "url_text";
                    }
                    String string2 = childModsText = metadata.childMods.isEmpty() ? "No child mods for this mod" : String.format("Child mods: %s", metadata.getChildModList());
                    if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, textX, shifty += textSpacing, childModsWidth = fontRenderer.func_78256_a(childModsText), fieldHeight)) {
                        narrationText = childModsText;
                        currentHoveredElement = "childmods_text";
                    }
                    shifty += textSpacing;
                    int descriptionX = offset;
                    int descriptionY = shifty += textSpacing;
                    int descriptionWidth = gui.field_146294_l - offset - 20;
                    if (narrationText != null || metadata.description == null || metadata.description.isEmpty() || descriptionWidth <= 20) break block33;
                    List formattedDescription = fontRenderer.func_78271_c(metadata.description, descriptionWidth);
                    int lineY = descriptionY;
                    for (String line : formattedDescription) {
                        String cleanLine = EnumChatFormatting.func_110646_a((String)line);
                        int lineWidth = fontRenderer.func_78256_a(cleanLine);
                        if (lineWidth > 0 && this.isMouseOver(event.mouseX, event.mouseY, descriptionX, lineY, lineWidth, fieldHeight)) {
                            narrationText = EnumChatFormatting.func_110646_a((String)metadata.description);
                            currentHoveredElement = "description_text";
                            break block33;
                        }
                        lineY += fieldHeight;
                    }
                    break block33;
                }
                int offset = (gui.field_146294_l + this.findField(GuiModList.class, "listWidth", "listWidth").getInt(gui)) / 2;
                if (fontRenderer != null) {
                    int fieldHeight = fontRenderer.field_78288_b;
                    String nameText = currentSelectedMod.getName();
                    int nameWidth = fontRenderer.func_78256_a(nameText);
                    if (this.isMouseOver(event.mouseX, event.mouseY, offset - nameWidth / 2 - 1, 34, nameWidth, fieldHeight)) {
                        narrationText = nameText;
                        currentHoveredElement = "name_text";
                    }
                    String versionText = String.format("Version: %s", currentSelectedMod.getVersion());
                    int versionWidth = fontRenderer.func_78256_a(versionText);
                    if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, offset - versionWidth / 2 - 1, 44, versionWidth, fieldHeight)) {
                        narrationText = versionText;
                        currentHoveredElement = "version_text";
                    }
                    String stateText = String.format("Mod State: %s", Loader.instance().getModState(currentSelectedMod));
                    int stateWidth = fontRenderer.func_78256_a(stateText);
                    if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, offset - stateWidth / 2 - 1, 54, stateWidth, fieldHeight)) {
                        narrationText = stateText;
                        currentHoveredElement = "modstate_text";
                    }
                    String noInfoText = "No mod information found";
                    int noInfoWidth = fontRenderer.func_78256_a(noInfoText);
                    if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, offset - noInfoWidth / 2 - 1, 64, noInfoWidth, fieldHeight)) {
                        narrationText = noInfoText;
                        currentHoveredElement = "no_info_text";
                    }
                    String askText = "Ask your mod author to provide a mod mcmod.info file";
                    int askWidth = fontRenderer.func_78256_a(askText);
                    if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, offset - askWidth / 2 - 1, 74, askWidth, fieldHeight)) {
                        narrationText = askText;
                        currentHoveredElement = "ask_author_text";
                    }
                }
            }
            catch (Exception e) {
                NarratorConfig.logError("[Narrator] Failed to narrate mod list: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (narrationText != null) {
            if (currentHoveredElement != null && !Objects.equals(currentHoveredElement, this.lastHoveredElement)) {
                this.lastHoveredElement = currentHoveredElement;
                this.hoverStartTime = System.currentTimeMillis();
                this.lastNarratedText = null;
            } else if (this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                if (!narrationText.equals(this.lastNarratedText)) {
                    AudioPlayer.speakAsync(narrationText);
                    this.lastNarratedText = narrationText;
                }
                this.hoverStartTime = -1L;
            }
        } else {
            this.lastHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
        }
    }

    private Field findField(Class<?> clazz, String deobfName, String srgName) {
        try {
            Field field = clazz.getDeclaredField(deobfName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            try {
                Field field = clazz.getDeclaredField(srgName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException ex) {
                return null;
            }
        }
    }

    private FontRenderer findFontRenderer(GuiScreen screen) {
        try {
            Field fontRendererField = this.findField(GuiScreen.class, "fontRendererObj", "field_146289_q");
            if (fontRendererField != null) {
                return (FontRenderer)fontRendererField.get(screen);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

