/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenAddServer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ServerListEntryLanDetected;
import net.minecraft.client.gui.ServerListEntryLanScan;
import net.minecraft.client.gui.ServerListEntryNormal;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.LanServerDetector;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Mouse;

public class MultiplayerNarrator {
    private String lastHoveredElement = null;
    private long lastHoverTime = -1L;
    private String lastNarratedTextField = null;
    private long textFieldHoverStartTime = -1L;
    private Object currentHoveredTextFieldElement = null;
    int delay = NarratorConfig.multiplayerNarratorHoverDelay;
    private GuiScreen lastGui = null;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        int titleY;
        int titleX;
        String titleText;
        String hoveredElementId;
        String narrationText;
        if (!NarratorConfig.enableMultiplayerListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        GuiScreen currentGui = event.gui;
        if (currentGui != this.lastGui) {
            this.lastHoveredElement = null;
            this.lastHoverTime = -1L;
            this.lastNarratedTextField = null;
            this.textFieldHoverStartTime = -1L;
            this.currentHoveredTextFieldElement = null;
            this.lastGui = currentGui;
        }
        int mouseX = Mouse.getX() * currentGui.field_146294_l / currentGui.field_146297_k.field_71443_c;
        int mouseY = currentGui.field_146295_m - Mouse.getY() * currentGui.field_146295_m / currentGui.field_146297_k.field_71440_d - 1;
        if (currentGui instanceof GuiMultiplayer) {
            int titleY2;
            GuiMultiplayer gui = (GuiMultiplayer)currentGui;
            long currentTime = System.currentTimeMillis();
            String narrationText2 = null;
            String hoveredElement = null;
            String titleText2 = StatCollector.func_74838_a((String)"multiplayer.title");
            int titleWidth = gui.field_146297_k.field_71466_p.func_78256_a(titleText2);
            int titleX2 = gui.field_146294_l / 2 - titleWidth / 2 - 1;
            if (this.isMouseOver(titleX2, titleY2 = 19, titleWidth, gui.field_146297_k.field_71466_p.field_78288_b, mouseX, mouseY)) {
                narrationText2 = titleText2;
                hoveredElement = "multiplayerTitle";
            }
            if (hoveredElement == null) {
                try {
                    Field tooltipField = this.findField(GuiMultiplayer.class, "field_146812_y", "field_146812_y");
                    if (tooltipField != null) {
                        tooltipField.setAccessible(true);
                        String tooltipText = (String)tooltipField.get(gui);
                        if (tooltipText != null && !tooltipText.isEmpty()) {
                            String cleanedTooltipText;
                            ArrayList tooltipLines = Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)tooltipText));
                            hoveredElement = narrationText2 = (cleanedTooltipText = EnumChatFormatting.func_110646_a((String)String.join((CharSequence)", ", tooltipLines)));
                        }
                    }
                }
                catch (Exception e) {
                    NarratorConfig.logError("[Narrator] Failed to get hovered element info from tooltip field: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (hoveredElement == null) {
                try {
                    Field selectionListField = this.findField(GuiMultiplayer.class, "field_146803_h", "serverListSelector");
                    if (selectionListField != null) {
                        Method getSelectedSlotMethod;
                        Object v;
                        selectionListField.setAccessible(true);
                        Object serverSelectionList = selectionListField.get(gui);
                        Field topField = this.findField(serverSelectionList.getClass(), "field_148153_b", "top");
                        Field bottomField = this.findField(serverSelectionList.getClass(), "field_148154_c", "bottom");
                        Field leftField = this.findField(serverSelectionList.getClass(), "field_148152_e", "left");
                        Field rightField = this.findField(serverSelectionList.getClass(), "field_148151_d", "right");
                        Field slotHeightField = this.findField(serverSelectionList.getClass(), "field_148149_f", "slotHeight");
                        Field amountScrolledField = this.findField(serverSelectionList.getClass(), "field_148169_q", "amountScrolled");
                        int top = topField != null ? ((Number)topField.get(serverSelectionList)).intValue() : 32;
                        int bottom = bottomField != null ? ((Number)bottomField.get(serverSelectionList)).intValue() : gui.field_146295_m - 64;
                        int left = leftField != null ? ((Number)leftField.get(serverSelectionList)).intValue() : 0;
                        int right = rightField != null ? ((Number)rightField.get(serverSelectionList)).intValue() : gui.field_146294_l;
                        int slotHeight = slotHeightField != null ? ((Number)slotHeightField.get(serverSelectionList)).intValue() : 36;
                        float amountScrolled = 0.0f;
                        if (amountScrolledField != null && (v = amountScrolledField.get(serverSelectionList)) instanceof Number) {
                            amountScrolled = ((Number)v).floatValue();
                        }
                        if (mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom && (getSelectedSlotMethod = this.findMethod(serverSelectionList.getClass(), "func_148124_c", "getSlotIndexFromScreenCoords", Integer.TYPE, Integer.TYPE)) != null) {
                            Method getListEntryMethod;
                            int slotTop;
                            int slotBottom;
                            getSelectedSlotMethod.setAccessible(true);
                            Object idxObj = getSelectedSlotMethod.invoke(serverSelectionList, mouseX, mouseY);
                            int selectedIndex = -1;
                            if (idxObj instanceof Number) {
                                selectedIndex = ((Number)idxObj).intValue();
                            }
                            if (selectedIndex >= 0 && (slotBottom = (slotTop = top + selectedIndex * slotHeight - (int)amountScrolled) + slotHeight) > top && slotTop < bottom && (getListEntryMethod = this.findMethod(serverSelectionList.getClass(), "func_148180_b", "getListEntry", Integer.TYPE)) != null) {
                                int scanY;
                                String scanText;
                                int scanWidth;
                                int scanX;
                                getListEntryMethod.setAccessible(true);
                                GuiListExtended.IGuiListEntry entry = (GuiListExtended.IGuiListEntry)getListEntryMethod.invoke(serverSelectionList, selectedIndex);
                                if (entry instanceof ServerListEntryNormal) {
                                    Field serverDataField = this.findField(entry.getClass(), "field_148301_e", "field_148301_e");
                                    if (serverDataField != null) {
                                        ServerData serverData = (ServerData)serverDataField.get(entry);
                                        String motd = EnumChatFormatting.func_110646_a((String)serverData.field_78843_d);
                                        String name = EnumChatFormatting.func_110646_a((String)serverData.field_78847_a);
                                        String popInfo = EnumChatFormatting.func_110646_a((String)serverData.field_78846_c);
                                        narrationText2 = name + ", " + motd;
                                        if (popInfo != null && !popInfo.isEmpty()) {
                                            narrationText2 = narrationText2 + ", " + popInfo;
                                        }
                                        hoveredElement = narrationText2;
                                    }
                                } else if (entry instanceof ServerListEntryLanDetected) {
                                    Field lanServerField = this.findField(entry.getClass(), "field_148291_b", "field_148291_b");
                                    if (lanServerField != null) {
                                        LanServerDetector.LanServer lanServer = (LanServerDetector.LanServer)lanServerField.get(entry);
                                        Method motdMethod = this.findMethod(lanServer.getClass(), "func_77487_a", "getServerMotd", new Class[0]);
                                        Method ipPortMethod = this.findMethod(lanServer.getClass(), "func_77488_b", "getServerIpPort", new Class[0]);
                                        if (motdMethod != null && ipPortMethod != null) {
                                            String motd = (String)motdMethod.invoke((Object)lanServer, new Object[0]);
                                            motd = EnumChatFormatting.func_110646_a((String)motd);
                                            String ipPort = (String)ipPortMethod.invoke((Object)lanServer, new Object[0]);
                                            hoveredElement = narrationText2 = StatCollector.func_74838_a((String)"lanServer.title") + ", " + motd + ", " + ipPort;
                                        }
                                    }
                                } else if (entry instanceof ServerListEntryLanScan && this.isMouseOver(scanX = gui.field_146294_l / 2 - (scanWidth = gui.field_146297_k.field_71466_p.func_78256_a(scanText = StatCollector.func_74838_a((String)"lanServer.scanning"))) / 2 - 1, scanY = slotTop + slotHeight / 2 - gui.field_146297_k.field_71466_p.field_78288_b / 2 + 1, scanWidth, gui.field_146297_k.field_71466_p.field_78288_b, mouseX, mouseY)) {
                                    hoveredElement = narrationText2 = scanText;
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    NarratorConfig.logError("[Narrator] Failed to narrate server: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (hoveredElement != null) {
                if (!hoveredElement.equals(this.lastHoveredElement)) {
                    this.lastHoveredElement = hoveredElement;
                    this.lastHoverTime = currentTime;
                } else if (this.lastHoverTime != -1L && currentTime - this.lastHoverTime >= (long)this.delay) {
                    AudioPlayer.speakAsync(narrationText2);
                    this.lastHoverTime = -1L;
                }
            } else {
                this.lastHoveredElement = null;
                this.lastHoverTime = -1L;
            }
        }
        if (currentGui.getClass().getName().contains("GuiScreenServerList")) {
            String labelText;
            int labelWidth;
            int labelY;
            int labelX;
            long currentTime = System.currentTimeMillis();
            narrationText = null;
            hoveredElementId = null;
            titleText = StatCollector.func_74838_a((String)"selectServer.direct");
            int titleWidth = currentGui.field_146297_k.field_71466_p.func_78256_a(titleText);
            titleX = currentGui.field_146294_l / 2 - titleWidth / 2 - 1;
            if (this.isMouseOver(titleX, titleY = 19, titleWidth, currentGui.field_146297_k.field_71466_p.field_78288_b, mouseX, mouseY)) {
                narrationText = titleText;
                hoveredElementId = "directConnectTitle";
            }
            if (hoveredElementId == null && this.isMouseOver(labelX = currentGui.field_146294_l / 2 - 101, labelY = 99, labelWidth = currentGui.field_146297_k.field_71466_p.func_78256_a(labelText = StatCollector.func_74838_a((String)"addServer.enterIp")), currentGui.field_146297_k.field_71466_p.field_78288_b, mouseX, mouseY)) {
                narrationText = labelText;
                hoveredElementId = "directConnectLabel";
            }
            if (hoveredElementId == null) {
                try {
                    GuiTextField textField;
                    Field serverTextField = this.findField(currentGui.getClass(), "field_146302_g", "field_146302_g");
                    if (serverTextField != null && (textField = (GuiTextField)serverTextField.get(currentGui)) != null && this.isMouseOver(textField, mouseX, mouseY) && !textField.func_146179_b().trim().isEmpty()) {
                        narrationText = textField.func_146179_b();
                        hoveredElementId = "directConnectField";
                    }
                }
                catch (Exception e) {
                    NarratorConfig.logError("[Narrator] Failed to narrate Direct Connect field: " + e.getMessage());
                }
            }
            if (hoveredElementId != null) {
                if (this.currentHoveredTextFieldElement != hoveredElementId) {
                    this.currentHoveredTextFieldElement = hoveredElementId;
                    this.textFieldHoverStartTime = currentTime;
                    this.lastNarratedTextField = null;
                } else if (this.textFieldHoverStartTime != -1L && currentTime - this.textFieldHoverStartTime >= (long)this.delay) {
                    if (!narrationText.equals(this.lastNarratedTextField)) {
                        AudioPlayer.speakAsync(narrationText);
                        this.lastNarratedTextField = narrationText;
                    }
                    this.textFieldHoverStartTime = -1L;
                }
            } else {
                this.currentHoveredTextFieldElement = null;
                this.textFieldHoverStartTime = -1L;
                this.lastNarratedTextField = null;
            }
        }
        if (currentGui instanceof GuiScreenAddServer) {
            long currentTime = System.currentTimeMillis();
            narrationText = null;
            hoveredElementId = null;
            titleText = StatCollector.func_74838_a((String)"addServer.title");
            int titleWidth = currentGui.field_146297_k.field_71466_p.func_78256_a(titleText);
            titleX = currentGui.field_146294_l / 2 - titleWidth / 2 - 1;
            if (this.isMouseOver(titleX, titleY = 16, titleWidth, currentGui.field_146297_k.field_71466_p.field_78288_b, mouseX, mouseY)) {
                narrationText = titleText;
                hoveredElementId = "addServerTitle";
            }
            if (hoveredElementId == null && (narrationText = this.getAddServerLabelHoverText((GuiScreenAddServer)currentGui, mouseX, mouseY)) != null) {
                hoveredElementId = narrationText;
            }
            if (hoveredElementId == null) {
                try {
                    GuiTextField textField;
                    Field serverIPField;
                    GuiTextField textField2;
                    Field serverNameField = this.findField(currentGui.getClass(), "field_146309_g", "serverNameField");
                    if (serverNameField != null && this.isMouseOver(textField2 = (GuiTextField)serverNameField.get(currentGui), mouseX, mouseY) && !textField2.func_146179_b().trim().isEmpty()) {
                        narrationText = textField2.func_146179_b();
                        hoveredElementId = "nameField";
                    }
                    if ((serverIPField = this.findField(currentGui.getClass(), "field_146308_f", "serverIPField")) != null && narrationText == null && this.isMouseOver(textField = (GuiTextField)serverIPField.get(currentGui), mouseX, mouseY) && !textField.func_146179_b().trim().isEmpty()) {
                        narrationText = textField.func_146179_b();
                        hoveredElementId = "ipField";
                    }
                }
                catch (Exception e) {
                    NarratorConfig.logError("[Narrator] Failed to narrate Add Server fields: " + e.getMessage());
                }
            }
            if (hoveredElementId != null) {
                if (this.currentHoveredTextFieldElement != hoveredElementId) {
                    this.currentHoveredTextFieldElement = hoveredElementId;
                    this.textFieldHoverStartTime = currentTime;
                    this.lastNarratedTextField = null;
                } else if (this.textFieldHoverStartTime != -1L && currentTime - this.textFieldHoverStartTime >= (long)this.delay) {
                    if (this.lastNarratedTextField == null || !this.lastNarratedTextField.equals(narrationText)) {
                        AudioPlayer.speakAsync(narrationText);
                        this.lastNarratedTextField = narrationText;
                    }
                    this.textFieldHoverStartTime = -1L;
                }
            } else {
                this.currentHoveredTextFieldElement = null;
                this.textFieldHoverStartTime = -1L;
                this.lastNarratedTextField = null;
            }
        }
    }

    private String getAddServerLabelHoverText(GuiScreenAddServer gui, int mouseX, int mouseY) {
        int nameLabelX = gui.field_146294_l / 2 - 101;
        int nameLabelY = 52;
        String nameLabel = StatCollector.func_74838_a((String)"addServer.enterName");
        int nameLabelWidth = gui.field_146297_k.field_71466_p.func_78256_a(nameLabel);
        if (this.isMouseOver(nameLabelX, nameLabelY, nameLabelWidth, gui.field_146297_k.field_71466_p.field_78288_b, mouseX, mouseY)) {
            return nameLabel;
        }
        int ipLabelX = gui.field_146294_l / 2 - 101;
        int ipLabelY = 93;
        String ipLabel = StatCollector.func_74838_a((String)"addServer.enterIp");
        int ipLabelWidth = gui.field_146297_k.field_71466_p.func_78256_a(ipLabel);
        if (this.isMouseOver(ipLabelX, ipLabelY, ipLabelWidth, gui.field_146297_k.field_71466_p.field_78288_b, mouseX, mouseY)) {
            return ipLabel;
        }
        return null;
    }

    private boolean isMouseOver(GuiTextField textField, int mouseX, int mouseY) {
        if (!textField.func_146176_q()) {
            return false;
        }
        return mouseX >= textField.field_146209_f && mouseX <= textField.field_146209_f + textField.field_146218_h && mouseY >= textField.field_146210_g && mouseY <= textField.field_146210_g + textField.field_146219_i;
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private Field findField(Class<?> clazz, String srgName, String deobfName) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Field field = currentClass.getDeclaredField(srgName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                try {
                    Field field = currentClass.getDeclaredField(deobfName);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private Method findMethod(Class<?> clazz, String srgName, String deobfName, Class<?> ... parameterTypes) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (String name : new String[]{srgName, deobfName}) {
                try {
                    return currentClass.getDeclaredMethod(name, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return null;
    }
}

