/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiFlatPresets;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;

public class PresetNarrator {
    private Object lastNarratedObject = null;
    private long hoverStartTime = -1L;
    private boolean hasNarratedOnHover = false;
    int delay = NarratorConfig.presetNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enablePresetListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (event.gui instanceof GuiFlatPresets) {
            GuiFlatPresets guiScreen = (GuiFlatPresets)event.gui;
            int mouseX = event.mouseX;
            int mouseY = event.mouseY;
            String hoveredIdentifier = null;
            String narrationText = null;
            try {
                String shareLabel;
                Field fontRendererField;
                String titleText = StatCollector.func_74838_a((String)"createWorld.customize.presets.title");
                try {
                    fontRendererField = GuiScreen.class.getDeclaredField("field_146289_q");
                }
                catch (NoSuchFieldException e) {
                    fontRendererField = GuiScreen.class.getDeclaredField("fontRendererObj");
                }
                fontRendererField.setAccessible(true);
                FontRenderer fontRenderer = (FontRenderer)fontRendererField.get(guiScreen);
                int titleWidth = fontRenderer.func_78256_a(titleText);
                int titleX = (guiScreen.field_146294_l - titleWidth) / 2 - 1;
                int titleY = 8;
                if (this.isMouseOverString(titleText, titleX, titleY, (GuiScreen)guiScreen, mouseX, mouseY)) {
                    hoveredIdentifier = "title_flat_presets";
                    narrationText = titleText;
                }
                if (hoveredIdentifier == null && this.isMouseOverString(shareLabel = StatCollector.func_74838_a((String)"createWorld.customize.presets.share"), 49, 30, (GuiScreen)guiScreen, mouseX, mouseY)) {
                    hoveredIdentifier = "shareLabel";
                    narrationText = shareLabel;
                }
                Field presetTextFieldField = GuiFlatPresets.class.getDeclaredField("field_146433_u");
                presetTextFieldField.setAccessible(true);
                GuiTextField presetTextField = (GuiTextField)presetTextFieldField.get(guiScreen);
                if (hoveredIdentifier == null && presetTextField != null && this.isMouseOver(presetTextField, mouseX, mouseY)) {
                    hoveredIdentifier = "presetTextField";
                    narrationText = presetTextField.func_146179_b();
                }
                String listLabel = StatCollector.func_74838_a((String)"createWorld.customize.presets.list");
                if (hoveredIdentifier == null && this.isMouseOverString(listLabel, 49, 70, (GuiScreen)guiScreen, mouseX, mouseY)) {
                    hoveredIdentifier = "listLabel";
                    narrationText = listLabel;
                }
            }
            catch (Exception titleText) {
                // empty catch block
            }
            try {
                Field listSlotField = GuiFlatPresets.class.getDeclaredField("field_146435_s");
                listSlotField.setAccessible(true);
                GuiSlot listSlotObject = (GuiSlot)listSlotField.get(guiScreen);
                if (hoveredIdentifier == null && listSlotObject != null && mouseX >= listSlotObject.field_148152_e && mouseX <= listSlotObject.field_148151_d && mouseY >= listSlotObject.field_148153_b && mouseY <= listSlotObject.field_148154_c) {
                    Method getSlotIndexMethod = listSlotObject.getClass().getSuperclass().getDeclaredMethod("func_148124_c", Integer.TYPE, Integer.TYPE);
                    getSlotIndexMethod.setAccessible(true);
                    int slotIndex = (Integer)getSlotIndexMethod.invoke((Object)listSlotObject, mouseX, mouseY);
                    Field presetsListField = GuiFlatPresets.class.getDeclaredField("field_146431_f");
                    presetsListField.setAccessible(true);
                    List presetsList = (List)presetsListField.get(null);
                    if (presetsList != null && slotIndex >= 0 && slotIndex < presetsList.size()) {
                        Object presetItem = presetsList.get(slotIndex);
                        Field presetNameField = presetItem.getClass().getDeclaredField("field_148232_b");
                        presetNameField.setAccessible(true);
                        String selectedPresetName = (String)presetNameField.get(presetItem);
                        hoveredIdentifier = "presetItem" + slotIndex;
                        narrationText = selectedPresetName;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (hoveredIdentifier != null) {
                this.narrateOnHover(narrationText, hoveredIdentifier);
            } else if (this.lastNarratedObject != null) {
                this.stopNarrationOnHover(this.lastNarratedObject);
            }
        }
    }

    private void narrateOnHover(String text, Object identifier) {
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        if (this.lastNarratedObject == null || !this.lastNarratedObject.equals(identifier)) {
            this.lastNarratedObject = identifier;
            this.hoverStartTime = System.currentTimeMillis();
            this.hasNarratedOnHover = false;
        }
        if (!this.hasNarratedOnHover && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
            AudioPlayer.speakAsync(text);
            this.hasNarratedOnHover = true;
        }
    }

    private void stopNarrationOnHover(Object identifier) {
        if (this.lastNarratedObject != null && this.lastNarratedObject.equals(identifier)) {
            this.lastNarratedObject = null;
            this.hasNarratedOnHover = false;
        }
    }

    private boolean isMouseOver(GuiTextField textField, int mouseX, int mouseY) {
        return mouseX >= textField.field_146209_f && mouseX < textField.field_146209_f + textField.field_146218_h && mouseY >= textField.field_146210_g && mouseY < textField.field_146210_g + textField.field_146219_i;
    }

    private boolean isMouseOverString(String text, int x, int y, GuiScreen guiScreen, int mouseX, int mouseY) {
        try {
            Field fontRendererField;
            try {
                fontRendererField = GuiScreen.class.getDeclaredField("field_146289_q");
            }
            catch (NoSuchFieldException e) {
                fontRendererField = GuiScreen.class.getDeclaredField("fontRendererObj");
            }
            fontRendererField.setAccessible(true);
            FontRenderer fontRenderer = (FontRenderer)fontRendererField.get(guiScreen);
            int stringWidth = fontRenderer.func_78256_a(text);
            int stringHeight = fontRenderer.field_78288_b;
            return mouseX >= x && mouseX < x + stringWidth + 1 && mouseY >= y && mouseY < y + stringHeight;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

