/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.gui.BuyRealmsScreen;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Mouse;

public class RealmsNarrator {
    private final Minecraft mc = Minecraft.func_71410_x();
    private GuiScreen lastNarratedScreen = null;
    private Object lastHoveredElement = null;
    private String lastNarratedText = null;
    private long hoverStartTime = -1L;
    int delay = NarratorConfig.realmsNarratorHoverDelay;

    @SubscribeEvent
    public void onGuiScreenDisplayed(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableRealmsListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (event.gui == null) {
            return;
        }
        if (event.gui.getClass().getName().equals("net.minecraft.client.gui.GuiScreenRealmsProxy")) {
            if (event.gui != this.lastNarratedScreen) {
                this.lastNarratedScreen = event.gui;
            }
            this.handleRealmsHoverNarration(event.gui);
        } else {
            this.lastNarratedScreen = null;
            this.lastHoveredElement = null;
            this.lastNarratedText = null;
            this.hoverStartTime = -1L;
        }
    }

    private void handleRealmsHoverNarration(GuiScreen guiScreen) {
        try {
            Field realmsScreenField = guiScreen.getClass().getDeclaredField("field_154330_a");
            realmsScreenField.setAccessible(true);
            RealmsScreen realmsScreen = (RealmsScreen)realmsScreenField.get(guiScreen);
            int mouseX = Mouse.getX() * guiScreen.field_146294_l / this.mc.field_71443_c;
            int mouseY = guiScreen.field_146295_m - Mouse.getY() * guiScreen.field_146295_m / this.mc.field_71440_d;
            String narrationText = null;
            String hoveredElement = null;
            if (realmsScreen instanceof BuyRealmsScreen) {
                int titleY;
                String title = StatCollector.func_74838_a((String)"mco.buy.realms.title");
                int titleWidth = this.mc.field_71466_p.func_78256_a(title);
                int titleX = (guiScreen.field_146294_l - titleWidth) / 2 - 1;
                if (this.isMouseOver(titleX, titleY = 11, titleWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                    narrationText = title;
                    hoveredElement = "buy_realms_title";
                }
            } else if (realmsScreen instanceof RealmsMainScreen) {
                int logoWidth = 95;
                int logoX = (guiScreen.field_146294_l - logoWidth) / 2 - 4;
                int logoY = 5;
                int logoHeight = 26;
                if (this.isMouseOver(logoX, logoY, logoWidth, logoHeight, mouseX, mouseY)) {
                    narrationText = "Minecraft Realms";
                    hoveredElement = "realms_logo";
                }
                if (narrationText == null) {
                    boolean isHoveringOverLink;
                    Field onLinkField;
                    Method inPendingInvitationAreaMethod = realmsScreen.getClass().getDeclaredMethod("inPendingInvitationArea", Integer.TYPE, Integer.TYPE);
                    inPendingInvitationAreaMethod.setAccessible(true);
                    boolean isHoveringOverInviteIcon = (Boolean)inPendingInvitationAreaMethod.invoke((Object)realmsScreen, mouseX, mouseY - 1);
                    if (isHoveringOverInviteIcon) {
                        Field numberOfPendingInvitesField = this.findField(realmsScreen.getClass(), "numberOfPendingInvites");
                        int pendingInvitesCount = (Integer)numberOfPendingInvitesField.get(realmsScreen);
                        narrationText = pendingInvitesCount != 0 ? StatCollector.func_74838_a((String)"mco.invites.pending") : StatCollector.func_74838_a((String)"mco.invites.nopending");
                        hoveredElement = "pending_invite_icon";
                    }
                    if (narrationText == null && (onLinkField = this.findField(realmsScreen.getClass(), "onLink")) != null && (isHoveringOverLink = ((Boolean)onLinkField.get(realmsScreen)).booleanValue())) {
                        narrationText = StatCollector.func_74838_a((String)"mco.selectServer.whatisrealms");
                        hoveredElement = "realms_link";
                    }
                }
            } else if (realmsScreen.getClass().getName().equals("com.mojang.realmsclient.gui.RealmsGenericErrorScreen")) {
                Field line1Field = this.findField(realmsScreen.getClass(), "line1");
                Field line2Field = this.findField(realmsScreen.getClass(), "line2");
                if (line1Field != null) {
                    String line1 = (String)line1Field.get(realmsScreen);
                    int line1Width = this.mc.field_71466_p.func_78256_a(line1);
                    int line1X = (guiScreen.field_146294_l - line1Width) / 2 - 1;
                    int line1Y = 80;
                    if (!line1.trim().isEmpty() && this.isMouseOver(line1X, line1Y, line1Width, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                        narrationText = line1;
                        hoveredElement = "error_line1";
                    }
                }
                if (line2Field != null && hoveredElement == null) {
                    String line2 = (String)line2Field.get(realmsScreen);
                    int line2Width = this.mc.field_71466_p.func_78256_a(line2);
                    int line2X = (guiScreen.field_146294_l - line2Width) / 2 - 1;
                    int line2Y = 100;
                    if (!line2.trim().isEmpty() && this.isMouseOver(line2X, line2Y, line2Width, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                        narrationText = line2;
                        hoveredElement = "error_line2";
                    }
                }
            }
            if (hoveredElement != null) {
                if (!Objects.equals(this.lastHoveredElement, hoveredElement)) {
                    this.lastHoveredElement = hoveredElement;
                    this.hoverStartTime = System.currentTimeMillis();
                    this.lastNarratedText = null;
                } else if (this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                    if (narrationText != null && !narrationText.equals(this.lastNarratedText)) {
                        AudioPlayer.speakAsync(narrationText);
                        this.lastNarratedText = narrationText;
                    }
                    this.hoverStartTime = -1L;
                }
            } else {
                this.lastHoveredElement = null;
                this.hoverStartTime = -1L;
                this.lastNarratedText = null;
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Failed to narrate Realms screen: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private Field findField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

