/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiResourcePackAvailable;
import net.minecraft.client.gui.GuiResourcePackList;
import net.minecraft.client.gui.GuiResourcePackSelected;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenResourcePacks;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.ResourcePackListEntry;
import net.minecraft.client.resources.ResourcePackListEntryDefault;
import net.minecraft.client.resources.ResourcePackListEntryFound;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;

public class ResourcePackNarrator {
    private String lastHoveredElement = null;
    private long hoverStartTime = -1L;
    int delay = NarratorConfig.resourcePackNarratorHoverDelay;

    @SubscribeEvent
    public void onGuiScreenDisplayed(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableResourcePackListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (!(event.gui instanceof GuiScreenResourcePacks)) {
            this.lastHoveredElement = null;
            this.hoverStartTime = -1L;
            return;
        }
        GuiScreenResourcePacks gui = (GuiScreenResourcePacks)event.gui;
        String narrationText = null;
        try {
            int folderInfoY;
            String folderInfoText;
            int folderInfoWidth;
            int folderInfoX;
            GuiResourcePackSelected selectedList;
            GuiResourcePackAvailable availableList;
            Field selectedListField;
            Field availableListField;
            int mainTitleY;
            FontRenderer fontRenderer = this.findFontRenderer((GuiScreen)gui);
            if (fontRenderer == null) {
                return;
            }
            String mainTitle = I18n.func_135052_a((String)"resourcePack.title", (Object[])new Object[0]);
            int mainTitleWidth = fontRenderer.func_78256_a(mainTitle);
            int mainTitleX = (gui.field_146294_l - mainTitleWidth) / 2 - 1;
            if (this.isMouseOver(event.mouseX, event.mouseY, mainTitleX, mainTitleY = 15, mainTitleWidth, fontRenderer.field_78288_b)) {
                narrationText = mainTitle;
            }
            if (narrationText == null) {
                availableListField = this.findField(GuiScreenResourcePacks.class, "field_146970_i", "field_146970_i");
                selectedListField = this.findField(GuiScreenResourcePacks.class, "field_146967_r", "field_146967_r");
                if (availableListField == null || selectedListField == null) {
                    return;
                }
                availableList = (GuiResourcePackAvailable)availableListField.get(gui);
                selectedList = (GuiResourcePackSelected)selectedListField.get(gui);
                float availableScroll = this.getScrollAmount((GuiResourcePackList)availableList);
                float selectedScroll = this.getScrollAmount((GuiResourcePackList)selectedList);
                String availableTitle = I18n.func_135052_a((String)"resourcePack.available.title", (Object[])new Object[0]);
                int availableTitleWidth = fontRenderer.func_78256_a(EnumChatFormatting.BOLD + availableTitle);
                int availableListLeft = gui.field_146294_l / 2 - 4 - 200;
                int availableTitleX = availableListLeft + availableList.field_148155_a / 2 - availableTitleWidth / 2;
                int availableTitleY = availableList.field_148153_b + 2 - (int)availableScroll;
                int availableHoverTop = Math.max(availableTitleY, availableList.field_148153_b + 1);
                int availableHoverHeight = availableTitleY + fontRenderer.field_78288_b - availableHoverTop;
                if (availableHoverHeight > 0 && this.isMouseOver(event.mouseX, event.mouseY, availableTitleX, availableHoverTop, availableTitleWidth + 1, availableHoverHeight + 1)) {
                    narrationText = availableTitle;
                }
                if (narrationText == null) {
                    String selectedTitle = I18n.func_135052_a((String)"resourcePack.selected.title", (Object[])new Object[0]);
                    int selectedTitleWidth = fontRenderer.func_78256_a(EnumChatFormatting.BOLD + selectedTitle);
                    int selectedListLeft = gui.field_146294_l / 2 + 4;
                    int selectedTitleX = selectedListLeft + selectedList.field_148155_a / 2 - selectedTitleWidth / 2;
                    int selectedTitleY = selectedList.field_148153_b + 2 - (int)selectedScroll;
                    int selectedHoverTop = Math.max(selectedTitleY, selectedList.field_148153_b + 1);
                    int selectedHoverHeight = selectedTitleY + fontRenderer.field_78288_b - selectedHoverTop;
                    if (selectedHoverHeight > 0 && this.isMouseOver(event.mouseX, event.mouseY, selectedTitleX, selectedHoverTop, selectedTitleWidth + 1, selectedHoverHeight + 1)) {
                        narrationText = selectedTitle;
                    }
                }
            }
            if (narrationText == null && this.isMouseOver(event.mouseX, event.mouseY, folderInfoX = gui.field_146294_l / 2 - 77 - (folderInfoWidth = fontRenderer.func_78256_a(folderInfoText = I18n.func_135052_a((String)"resourcePack.folderInfo", (Object[])new Object[0]))) / 2 - 1, folderInfoY = gui.field_146295_m - 27, folderInfoWidth, fontRenderer.field_78288_b)) {
                narrationText = folderInfoText;
            }
            if (narrationText == null) {
                availableListField = this.findField(GuiScreenResourcePacks.class, "field_146970_i", "field_146970_i");
                selectedListField = this.findField(GuiScreenResourcePacks.class, "field_146967_r", "field_146967_r");
                if (availableListField == null || selectedListField == null) {
                    return;
                }
                availableList = (GuiResourcePackAvailable)availableListField.get(gui);
                selectedList = (GuiResourcePackSelected)selectedListField.get(gui);
                narrationText = this.getResourcePackNarrationText((GuiResourcePackList)availableList, event.mouseX, event.mouseY);
                if (narrationText == null) {
                    narrationText = this.getResourcePackNarrationText((GuiResourcePackList)selectedList, event.mouseX, event.mouseY);
                }
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Failed to narrate resource pack screen: " + e.getMessage());
            e.printStackTrace();
        }
        if (narrationText != null) {
            if (!narrationText.equals(this.lastHoveredElement)) {
                this.lastHoveredElement = narrationText;
                this.hoverStartTime = System.currentTimeMillis();
            } else if (this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                AudioPlayer.speakAsync(narrationText);
                this.hoverStartTime = -1L;
            }
        } else {
            this.lastHoveredElement = null;
            this.hoverStartTime = -1L;
        }
    }

    private String getResourcePackNarrationText(GuiResourcePackList list, int mouseX, int mouseY) throws Exception {
        Method getSlotIndexMethod = this.findMethod(list.getClass().getSuperclass(), "func_148124_c", "getSlotIndexFromScreenCoords", Integer.TYPE, Integer.TYPE);
        Field resourcePacksField = this.findField(GuiResourcePackList.class, "field_148204_l", "field_148204_l");
        Field topField = this.findField(list.getClass().getSuperclass(), "field_148153_b", "top");
        Field bottomField = this.findField(list.getClass().getSuperclass(), "field_148154_c", "bottom");
        Field leftField = this.findField(list.getClass().getSuperclass(), "field_148152_e", "left");
        Field rightField = this.findField(list.getClass().getSuperclass(), "field_148151_d", "right");
        if (getSlotIndexMethod == null || resourcePacksField == null || topField == null || bottomField == null || leftField == null || rightField == null) {
            return null;
        }
        int top = topField.getInt(list);
        int bottom = bottomField.getInt(list);
        int left = leftField.getInt(list);
        int right = rightField.getInt(list);
        if (mouseX < left || mouseX > right || mouseY < top || mouseY > bottom) {
            return null;
        }
        int slotIndex = (Integer)getSlotIndexMethod.invoke((Object)list, mouseX, mouseY);
        if (slotIndex != -1) {
            List entries = (List)resourcePacksField.get(list);
            if (slotIndex >= 0 && slotIndex < entries.size()) {
                ResourcePackListEntry entry = (ResourcePackListEntry)entries.get(slotIndex);
                if (entry instanceof ResourcePackListEntryFound) {
                    ResourcePackRepository.Entry packEntry = this.getEntryFromFoundEntry((ResourcePackListEntryFound)entry);
                    if (packEntry != null) {
                        String name = EnumChatFormatting.func_110646_a((String)this.getPackNameFromEntry(packEntry));
                        String description = this.getDescriptionFromEntry(packEntry);
                        String narration = name;
                        if (description != null && !description.isEmpty()) {
                            narration = narration + ", " + description;
                        }
                        return narration;
                    }
                } else if (entry instanceof ResourcePackListEntryDefault) {
                    return this.getSpecialPackNarrationFromEntry((ResourcePackListEntryDefault)entry);
                }
            }
        }
        return null;
    }

    private String getSpecialPackNarrationFromEntry(ResourcePackListEntryDefault entry) throws Exception {
        Method getPackNameMethod = this.findMethod(ResourcePackListEntryDefault.class, "func_148312_b", "func_148312_b", new Class[0]);
        Method getDescriptionMethod = this.findMethod(ResourcePackListEntryDefault.class, "func_148311_a", "func_148311_a", new Class[0]);
        String name = (String)getPackNameMethod.invoke((Object)entry, new Object[0]);
        String description = (String)getDescriptionMethod.invoke((Object)entry, new Object[0]);
        String narration = name;
        if (description != null && !description.isEmpty()) {
            narration = narration + ", " + EnumChatFormatting.func_110646_a((String)description);
        }
        return narration;
    }

    private ResourcePackRepository.Entry getEntryFromFoundEntry(ResourcePackListEntryFound entry) throws Exception {
        Field entryField = this.findField(ResourcePackListEntryFound.class, "field_148319_c", "field_148319_c");
        if (entryField != null) {
            return (ResourcePackRepository.Entry)entryField.get(entry);
        }
        return null;
    }

    private String getPackNameFromEntry(ResourcePackRepository.Entry entry) throws Exception {
        Method getPackNameMethod = this.findMethod(ResourcePackRepository.Entry.class, "func_110515_d", "getResourcePackName", new Class[0]);
        if (getPackNameMethod != null) {
            return (String)getPackNameMethod.invoke((Object)entry, new Object[0]);
        }
        return null;
    }

    private String getDescriptionFromEntry(ResourcePackRepository.Entry entry) {
        try {
            Method getTexturePackDescriptionMethod = this.findMethod(ResourcePackRepository.Entry.class, "func_110519_e", "getTexturePackDescription", new Class[0]);
            if (getTexturePackDescriptionMethod != null) {
                String description = (String)getTexturePackDescriptionMethod.invoke((Object)entry, new Object[0]);
                return EnumChatFormatting.func_110646_a((String)description);
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Failed to get pack description: " + e.getMessage());
        }
        return null;
    }

    private Field findField(Class<?> clazz, String srgName, String deobfName) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Field field = currentClass.getDeclaredField(srgName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                try {
                    Field field = currentClass.getDeclaredField(deobfName);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private Method findMethod(Class<?> clazz, String srgName, String deobfName, Class<?> ... parameterTypes) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Method method = currentClass.getDeclaredMethod(srgName, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                try {
                    Method method = currentClass.getDeclaredMethod(deobfName, parameterTypes);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private FontRenderer findFontRenderer(GuiScreen screen) {
        try {
            Field fontRendererField = this.findField(GuiScreen.class, "field_146289_q", "fontRendererObj");
            if (fontRendererField != null) {
                return (FontRenderer)fontRendererField.get(screen);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private int getScrollAmount(GuiResourcePackList list) {
        try {
            Field scrollField = this.findField(list.getClass().getSuperclass(), "field_148169_q", "amountScrolled");
            if (scrollField != null) {
                return Math.round(((Float)scrollField.get(list)).floatValue());
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Failed to get scroll amount: " + e.getMessage());
        }
        return 0;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

