/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.achievement.GuiStats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.stats.StatList;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;

public class StatsNarrator {
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    private String currentNarrationKey = null;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    int delay = NarratorConfig.statsNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableStatsListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (!(event.gui instanceof GuiStats)) {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
            return;
        }
        int mouseX = event.mouseX;
        int mouseY = event.mouseY;
        if (mouseX == this.lastMouseX && mouseY == this.lastMouseY) {
            if (this.currentHoveredElement != null && this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                HoverResult result = this.getHoverResult(event, mouseX, mouseY);
                if (result != null && result.narrationText != null && !result.narrationText.isEmpty()) {
                    AudioPlayer.speakAsync(result.narrationText);
                }
                this.hoverStartTime = -1L;
            }
            return;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        HoverResult result = this.getHoverResult(event, mouseX, mouseY);
        if (result != null) {
            if (!Objects.equals(this.currentNarrationKey, result.narrationKey)) {
                this.currentHoveredElement = result.hoveredElement;
                this.currentNarrationKey = result.narrationKey;
                this.hoverStartTime = System.currentTimeMillis();
            }
        } else {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
        }
    }

    private HoverResult getHoverResult(GuiScreenEvent.DrawScreenEvent.Post event, int mouseX, int mouseY) {
        GuiStats gui = (GuiStats)event.gui;
        try {
            HoverResult titleResult = this.handleTitleStats(gui, mouseX, mouseY);
            if (titleResult != null) {
                return titleResult;
            }
            GuiSlot activeSlot = this.findActiveGuiSlotFromGuiStats(gui);
            if (activeSlot != null) {
                String slotClassName = activeSlot.getClass().getName();
                if (slotClassName.contains("StatsGeneral")) {
                    return this.handleGeneralStats(gui, activeSlot, mouseX, mouseY);
                }
                if (slotClassName.contains("StatsBlock")) {
                    return this.handleBlockStats(gui, activeSlot, mouseX, mouseY);
                }
                if (slotClassName.contains("StatsItem")) {
                    return this.handleItemsStats(gui, activeSlot, mouseX, mouseY);
                }
                if (slotClassName.contains("StatsMobsList")) {
                    return this.handleMobsStats(gui, activeSlot, mouseX, mouseY);
                }
            }
        }
        catch (Throwable t) {
            NarratorConfig.logError("[Narrator] An error occurred during stats narration: " + t.getMessage());
            t.printStackTrace();
        }
        return null;
    }

    private HoverResult handleTitleStats(GuiStats gui, int mouseX, int mouseY) {
        try {
            String titleText = I18n.func_135052_a((String)"gui.stats", (Object[])new Object[0]);
            Minecraft mc = Minecraft.func_71410_x();
            int textWidth = mc.field_71466_p.func_78256_a(titleText);
            int textHeight = mc.field_71466_p.field_78288_b;
            int titleX = gui.field_146294_l / 2 - textWidth / 2 - 1;
            int titleY = 19;
            if (mouseX >= titleX && mouseX <= titleX + textWidth && mouseY >= titleY && mouseY <= titleY + textHeight) {
                return new HoverResult(titleText, "gui_title", "gui_title");
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] An error occurred during title narration: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    private GuiSlot findActiveGuiSlotFromGuiStats(GuiStats gui) throws Exception {
        Object value;
        Field field = this.findField(GuiStats.class, "field_146545_u", "displaySlot");
        if (field != null && (value = field.get(gui)) instanceof GuiSlot) {
            return (GuiSlot)value;
        }
        return null;
    }

    private HoverResult handleGeneralStats(GuiStats gui, GuiSlot slot, int mouseX, int mouseY) throws Exception {
        List statsList = StatList.field_75941_c;
        Field statWriterField = this.findField(GuiStats.class, "field_146546_t", "field_146546_t");
        Method writeStatMethod = this.findMethod(StatFileWriter.class, "func_77444_a", "writeStat", StatBase.class);
        Field typeField = this.findField(StatBase.class, "field_75976_b", "type");
        Method getSlotIndexMethod = this.findMethod(GuiSlot.class, "func_148124_c", "getSlotIndexFromScreenCoords", Integer.TYPE, Integer.TYPE);
        if (statWriterField == null || writeStatMethod == null || typeField == null || getSlotIndexMethod == null) {
            return null;
        }
        int slotIndex = (Integer)getSlotIndexMethod.invoke((Object)slot, mouseX, mouseY);
        if (slotIndex >= 0 && slotIndex < statsList.size()) {
            Method formatMethod;
            if (!this.isSlotVisible(slot, mouseY)) {
                return null;
            }
            StatBase stat = (StatBase)statsList.get(slotIndex);
            IChatComponent statNameComponent = stat.func_150951_e();
            String statNameText = statNameComponent.func_150261_e();
            int statValue = (Integer)writeStatMethod.invoke(statWriterField.get(gui), stat);
            Object statType = typeField.get(stat);
            String formattedValue = "";
            if (statType != null && (formatMethod = this.findMethod(statType.getClass(), "func_75843_a", "format", Integer.TYPE)) != null) {
                formattedValue = (String)formatMethod.invoke(statType, statValue);
            }
            String narrationText = String.format("%s: %s", statNameText, formattedValue);
            return new HoverResult(narrationText, stat, stat.field_75975_e);
        }
        return null;
    }

    private HoverResult handleBlockStats(GuiStats gui, GuiSlot slot, int mouseX, int mouseY) throws Exception {
        List statsList = this.findStatsListInSlot(slot);
        if (statsList == null) {
            return null;
        }
        Method getSlotIndexMethod = this.findMethod(GuiSlot.class, "func_148124_c", "getSlotIndexFromScreenCoords", Integer.TYPE, Integer.TYPE);
        if (getSlotIndexMethod == null) {
            return null;
        }
        int slotIndex = (Integer)getSlotIndexMethod.invoke((Object)slot, mouseX, mouseY);
        if (slotIndex < 0 || slotIndex >= statsList.size()) {
            boolean isBlocks = true;
            return this.handleHeaderStats(isBlocks, gui, mouseX, mouseY);
        }
        if (!this.isSlotVisible(slot, mouseY)) {
            return null;
        }
        Field statWriterField = this.findField(GuiStats.class, "field_146546_t", "field_146546_t");
        Method writeStatMethod = this.findMethod(StatFileWriter.class, "func_77444_a", "writeStat", StatBase.class);
        Method getItemMethod = this.findMethod(StatCrafting.class, "func_150959_a", "func_150959_a", new Class[0]);
        if (statWriterField == null || writeStatMethod == null || getItemMethod == null) {
            return null;
        }
        StatBase stat = (StatBase)statsList.get(slotIndex);
        Item item = (Item)getItemMethod.invoke((Object)stat, new Object[0]);
        String itemName = new ItemStack(item).func_82833_r();
        int slotLeft = gui.field_146294_l / 2 - 124;
        int itemX = slotLeft + 56;
        int craftedStatX = slotLeft + 113;
        int usedStatX = slotLeft + 163;
        int minedStatX = slotLeft + 213;
        if (mouseX >= itemX && mouseX <= itemX + 20) {
            return new HoverResult(itemName, stat, "item_name_" + stat.field_75975_e);
        }
        if (mouseX >= craftedStatX && mouseX <= craftedStatX + 20) {
            StatBase craftedStat = this.findStatByItem(Arrays.asList(StatList.field_75928_D), item, getItemMethod);
            if (craftedStat != null) {
                int craftedValue = (Integer)writeStatMethod.invoke(statWriterField.get(gui), craftedStat);
                String narration = I18n.func_135052_a((String)"stat.crafted", (Object[])new Object[0]) + ": " + craftedValue;
                return new HoverResult(narration, "crafted_" + stat.field_75975_e, "crafted_stat_" + stat.field_75975_e);
            }
            String narrationEmpty = I18n.func_135052_a((String)"stat.crafted", (Object[])new Object[0]) + ": none";
            return new HoverResult(narrationEmpty, "crafted_" + stat.field_75975_e, "crafted_stat_" + stat.field_75975_e);
        }
        if (mouseX >= usedStatX && mouseX <= usedStatX + 20) {
            StatBase usedStat = this.findStatByItem(Arrays.asList(StatList.field_75929_E), item, getItemMethod);
            if (usedStat != null) {
                int usedValue = (Integer)writeStatMethod.invoke(statWriterField.get(gui), usedStat);
                String narration = I18n.func_135052_a((String)"stat.used", (Object[])new Object[0]) + ": " + usedValue;
                return new HoverResult(narration, "used_" + stat.field_75975_e, "used_stat_" + stat.field_75975_e);
            }
            String narrationEmpty = I18n.func_135052_a((String)"stat.used", (Object[])new Object[0]) + ": none";
            return new HoverResult(narrationEmpty, "used_" + stat.field_75975_e, "used_stat_" + stat.field_75975_e);
        }
        if (mouseX >= minedStatX && mouseX <= minedStatX + 20) {
            StatBase minedStat = this.findStatByItem(StatList.field_75939_e, item, getItemMethod);
            if (minedStat != null) {
                int minedValue = (Integer)writeStatMethod.invoke(statWriterField.get(gui), minedStat);
                String narration = I18n.func_135052_a((String)"stat.mined", (Object[])new Object[0]) + ": " + minedValue;
                return new HoverResult(narration, "mined_" + stat.field_75975_e, "mined_stat_" + stat.field_75975_e);
            }
            String narrationEmpty = I18n.func_135052_a((String)"stat.mined", (Object[])new Object[0]) + ": none";
            return new HoverResult(narrationEmpty, "mined_" + stat.field_75975_e, "mined_stat_" + stat.field_75975_e);
        }
        return null;
    }

    private HoverResult handleItemsStats(GuiStats gui, GuiSlot slot, int mouseX, int mouseY) throws Exception {
        List statsList = this.findStatsListInSlot(slot);
        if (statsList == null) {
            return null;
        }
        Method getSlotIndexMethod = this.findMethod(GuiSlot.class, "func_148124_c", "getSlotIndexFromScreenCoords", Integer.TYPE, Integer.TYPE);
        if (getSlotIndexMethod == null) {
            return null;
        }
        int slotIndex = (Integer)getSlotIndexMethod.invoke((Object)slot, mouseX, mouseY);
        if (slotIndex < 0 || slotIndex >= statsList.size()) {
            boolean isBlocks = false;
            return this.handleHeaderStats(isBlocks, gui, mouseX, mouseY);
        }
        if (!this.isSlotVisible(slot, mouseY)) {
            return null;
        }
        Field statWriterField = this.findField(GuiStats.class, "field_146546_t", "field_146546_t");
        Method writeStatMethod = this.findMethod(StatFileWriter.class, "func_77444_a", "writeStat", StatBase.class);
        Method getItemMethod = this.findMethod(StatCrafting.class, "func_150959_a", "func_150959_a", new Class[0]);
        if (statWriterField == null || writeStatMethod == null || getItemMethod == null) {
            return null;
        }
        StatBase stat = (StatBase)statsList.get(slotIndex);
        Item item = (Item)getItemMethod.invoke((Object)stat, new Object[0]);
        String itemName = new ItemStack(item).func_82833_r();
        int slotLeft = gui.field_146294_l / 2 - 124;
        int itemX = slotLeft + 56;
        int depletedStatX = slotLeft + 113;
        int craftedStatX = slotLeft + 163;
        int usedStatX = slotLeft + 213;
        if (mouseX >= itemX && mouseX <= itemX + 20) {
            return new HoverResult(itemName, stat, "item_name_" + stat.field_75975_e);
        }
        if (mouseX >= depletedStatX && mouseX <= depletedStatX + 20) {
            StatBase depletedStat = this.findStatByItem(Arrays.asList(StatList.field_75930_F), item, getItemMethod);
            if (depletedStat != null) {
                int depletedValue = (Integer)writeStatMethod.invoke(statWriterField.get(gui), depletedStat);
                String narration = I18n.func_135052_a((String)"stat.depleted", (Object[])new Object[0]) + ": " + depletedValue;
                return new HoverResult(narration, "depleted_" + stat.field_75975_e, "depleted_stat_" + stat.field_75975_e);
            }
            String narrationEmpty = I18n.func_135052_a((String)"stat.depleted", (Object[])new Object[0]) + ": none";
            return new HoverResult(narrationEmpty, "depleted_" + stat.field_75975_e, "depleted_stat_" + stat.field_75975_e);
        }
        if (mouseX >= craftedStatX && mouseX <= craftedStatX + 20) {
            StatBase craftedStat = this.findStatByItem(Arrays.asList(StatList.field_75928_D), item, getItemMethod);
            if (craftedStat != null) {
                int craftedValue = (Integer)writeStatMethod.invoke(statWriterField.get(gui), craftedStat);
                String narration = I18n.func_135052_a((String)"stat.crafted", (Object[])new Object[0]) + ": " + craftedValue;
                return new HoverResult(narration, "crafted_" + stat.field_75975_e, "crafted_stat_" + stat.field_75975_e);
            }
            String narrationEmpty = I18n.func_135052_a((String)"stat.crafted", (Object[])new Object[0]) + ": none";
            return new HoverResult(narrationEmpty, "crafted_" + stat.field_75975_e, "crafted_stat_" + stat.field_75975_e);
        }
        if (mouseX >= usedStatX && mouseX <= usedStatX + 20) {
            StatBase usedStat = this.findStatByItem(Arrays.asList(StatList.field_75929_E), item, getItemMethod);
            if (usedStat != null) {
                int usedValue = (Integer)writeStatMethod.invoke(statWriterField.get(gui), usedStat);
                String narration = I18n.func_135052_a((String)"stat.used", (Object[])new Object[0]) + ": " + usedValue;
                return new HoverResult(narration, "used_" + stat.field_75975_e, "used_stat_" + stat.field_75975_e);
            }
            String narrationEmpty = I18n.func_135052_a((String)"stat.used", (Object[])new Object[0]) + ": none";
            return new HoverResult(narrationEmpty, "used_" + stat.field_75975_e, "used_stat_" + stat.field_75975_e);
        }
        return null;
    }

    private HoverResult handleMobsStats(GuiStats gui, GuiSlot slot, int mouseX, int mouseY) throws Exception {
        List mobsList = this.findStatsListInSlot(slot);
        if (mobsList == null) {
            return null;
        }
        Method getSlotIndexMethod = this.findMethod(GuiSlot.class, "func_148124_c", "getSlotIndexFromScreenCoords", Integer.TYPE, Integer.TYPE);
        if (getSlotIndexMethod == null) {
            return null;
        }
        int slotIndex = (Integer)getSlotIndexMethod.invoke((Object)slot, mouseX, mouseY);
        if (!this.isSlotVisible(slot, mouseY)) {
            return null;
        }
        if (slotIndex >= 0 && slotIndex < mobsList.size()) {
            EntityList.EntityEggInfo mobInfo = (EntityList.EntityEggInfo)mobsList.get(slotIndex);
            Field statWriterField = this.findField(GuiStats.class, "field_146546_t", "field_146546_t");
            Method writeStatMethod = this.findMethod(StatFileWriter.class, "func_77444_a", "writeStat", StatBase.class);
            Field topField = this.findField(GuiSlot.class, "field_148153_b", "top");
            Method getAmountScrolledMethod = this.findMethod(GuiSlot.class, "func_148148_g", "getAmountScrolled", new Class[0]);
            Method getSlotHeightMethod = this.findMethod(GuiSlot.class, "func_148146_j", "getSlotHeight", new Class[0]);
            if (statWriterField == null || writeStatMethod == null || topField == null || getAmountScrolledMethod == null || getSlotHeightMethod == null) {
                return null;
            }
            int kills = (Integer)writeStatMethod.invoke(statWriterField.get(gui), mobInfo.field_151512_d);
            int killedBy = (Integer)writeStatMethod.invoke(statWriterField.get(gui), mobInfo.field_151513_e);
            int slotLeft = gui.field_146294_l / 2 - 124;
            int lineHeight = Minecraft.func_71410_x().field_71466_p.field_78288_b;
            int top = (Integer)topField.get(slot);
            int slotHeight = (Integer)getSlotHeightMethod.invoke((Object)slot, new Object[0]);
            int amountScrolled = (Integer)getAmountScrolledMethod.invoke((Object)slot, new Object[0]);
            int slotY = top + slotIndex * slotHeight - amountScrolled;
            String mobName = I18n.func_135052_a((String)("entity." + EntityList.func_75617_a((int)mobInfo.field_75613_a) + ".name"), (Object[])new Object[0]);
            int mobNameX = slotLeft + 7;
            int mobNameY = slotY + 4;
            int mobNameWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(mobName);
            if (mouseX >= mobNameX && mouseX <= mobNameX + mobNameWidth && mouseY >= mobNameY && mouseY <= mobNameY + lineHeight) {
                return new HoverResult(mobName, mobInfo, "mob_name_" + mobName);
            }
            String narrationTextKills = StatCollector.func_74837_a((String)"stat.entityKills", (Object[])new Object[]{kills, mobName});
            int killsTextWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(narrationTextKills);
            int killsX = slotLeft + 17;
            int killsY = slotY + 4 + lineHeight;
            if (mouseX >= killsX && mouseX <= killsX + killsTextWidth && mouseY >= killsY && mouseY <= killsY + lineHeight) {
                return new HoverResult(narrationTextKills, "mob_kills_" + mobName, "mob_kills_" + mobName);
            }
            String narrationTextKilledBy = killedBy > 0 ? StatCollector.func_74837_a((String)"stat.entityKilledBy", (Object[])new Object[]{mobName, killedBy}) : StatCollector.func_74837_a((String)"stat.entityKilledBy.none", (Object[])new Object[]{mobName});
            int killedByTextWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(narrationTextKilledBy);
            int killedByX = slotLeft + 17;
            int killedByY = slotY + 4 + lineHeight * 2;
            if (mouseX >= killedByX && mouseX <= killedByX + killedByTextWidth && mouseY >= killedByY && mouseY <= killedByY + lineHeight) {
                return new HoverResult(narrationTextKilledBy, "mob_killed_by_" + mobName, "mob_killed_by_" + mobName);
            }
        }
        return null;
    }

    private boolean isSlotVisible(GuiSlot slot, int mouseY) throws Exception {
        try {
            Field topField = this.findField(GuiSlot.class, "field_148153_b", "top");
            Field bottomField = this.findField(GuiSlot.class, "field_148154_c", "bottom");
            Field scrollDistanceField = this.findField(GuiSlot.class, "field_148169_q", "amountScrolled");
            Field slotHeightField = this.findField(GuiSlot.class, "field_148149_f", "slotHeight");
            if (topField == null || bottomField == null || scrollDistanceField == null || slotHeightField == null) {
                NarratorConfig.logError("[Narrator] Failed to find required GuiSlot fields for visibility check. Reflection may have failed.");
                return false;
            }
            int top = (Integer)topField.get(slot);
            int bottom = (Integer)bottomField.get(slot);
            return mouseY >= top && mouseY <= bottom;
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] An error occurred during isSlotVisible check. Reflection may have failed.");
            e.printStackTrace();
            return false;
        }
    }

    private HoverResult handleHeaderStats(boolean flag, GuiStats gui, int mouseX, int mouseY) throws Exception {
        GuiSlot activeSlot = this.findActiveGuiSlotFromGuiStats(gui);
        if (activeSlot == null) {
            return null;
        }
        Field topField = this.findField(GuiSlot.class, "field_148153_b", "top");
        Field bottomField = this.findField(GuiSlot.class, "field_148154_c", "bottom");
        if (topField == null || bottomField == null) {
            return null;
        }
        int top = (Integer)topField.get(activeSlot);
        int bottom = (Integer)bottomField.get(activeSlot);
        int slotLeft = gui.field_146294_l / 2 - 124;
        int headerIconSize = 18;
        int craftedX = slotLeft + 113;
        int usedX = slotLeft + 163;
        int minedX = slotLeft + 213;
        if (mouseX >= craftedX && mouseX <= craftedX + headerIconSize && mouseY >= top && mouseY <= bottom) {
            return flag ? new HoverResult(I18n.func_135052_a((String)"stat.crafted", (Object[])new Object[0]), "header_crafted", "header_crafted") : new HoverResult(I18n.func_135052_a((String)"stat.depleted", (Object[])new Object[0]), "header_depleted", "header_depleted");
        }
        if (mouseX >= usedX && mouseX <= usedX + headerIconSize && mouseY >= top && mouseY <= bottom) {
            return flag ? new HoverResult(I18n.func_135052_a((String)"stat.used", (Object[])new Object[0]), "header_used", "header_used") : new HoverResult(I18n.func_135052_a((String)"stat.crafted", (Object[])new Object[0]), "header_crafted", "header_crafted");
        }
        if (mouseX >= minedX && mouseX <= minedX + headerIconSize && mouseY >= top && mouseY <= bottom) {
            return flag ? new HoverResult(I18n.func_135052_a((String)"stat.mined", (Object[])new Object[0]), "header_mined", "header_mined") : new HoverResult(I18n.func_135052_a((String)"stat.used", (Object[])new Object[0]), "header_used", "header_used");
        }
        return null;
    }

    private List findStatsListInSlot(GuiSlot slot) {
        Class<?> clazz = slot.getClass();
        try {
            Object listObject;
            Field field = null;
            if (clazz.getName().contains("StatsBlock") || clazz.getName().contains("StatsItem")) {
                field = this.findField(clazz, "field_148219_m", "statsHolder");
            } else if (clazz.getName().contains("StatsMobs")) {
                field = this.findField(clazz, "field_148222_l", "field_148222_l");
            }
            if (field != null && (listObject = field.get(slot)) instanceof List) {
                return (List)listObject;
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] An exception occurred while trying to access the stats list field.");
            e.printStackTrace();
            return null;
        }
        return null;
    }

    private StatBase findStatByItem(List<StatBase> statsList, Item item, Method getItemMethod) throws Exception {
        if (statsList == null) {
            return null;
        }
        for (StatBase stat : statsList) {
            Item statItem;
            if (!(stat instanceof StatCrafting) || (statItem = (Item)getItemMethod.invoke((Object)stat, new Object[0])) != item) continue;
            return stat;
        }
        return null;
    }

    private Field findField(Class<?> clazz, String srgName, String deobfName) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(srgName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException f) {
                try {
                    Field f2 = c.getDeclaredField(deobfName);
                    f2.setAccessible(true);
                    return f2;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private Method findMethod(Class<?> clazz, String srgName, String deobfName, Class<?> ... parameterTypes) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Method m = c.getDeclaredMethod(srgName, parameterTypes);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException m) {
                try {
                    Method m2 = c.getDeclaredMethod(deobfName, parameterTypes);
                    m2.setAccessible(true);
                    return m2;
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private static class HoverResult {
        public final String narrationText;
        public final Object hoveredElement;
        public final String narrationKey;

        public HoverResult(String text, Object element, String key) {
            this.narrationText = text;
            this.hoveredElement = element;
            this.narrationKey = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HoverResult that = (HoverResult)o;
            return Objects.equals(this.narrationKey, that.narrationKey);
        }

        public int hashCode() {
            return Objects.hash(this.narrationKey);
        }
    }
}

