/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiRenameWorld;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.util.StatCollector;
import net.minecraft.world.storage.SaveFormatComparator;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Mouse;

public class WorldNarrator {
    private final Minecraft mc = Minecraft.func_71410_x();
    private String lastNarratedText = null;
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    int delay = NarratorConfig.worldNarratorHoverDelay;
    private Object currentGuiScreen = null;

    private String formatWorldDate(long lastPlayed) {
        Date date = new Date(lastPlayed);
        return DateFormat.getDateTimeInstance(3, 3, Locale.getDefault()).format(date);
    }

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        Object[] result;
        if (!NarratorConfig.enableWorldListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (this.currentGuiScreen != event.gui) {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
            this.currentGuiScreen = event.gui;
        }
        if (!(event.gui instanceof GuiSelectWorld || event.gui instanceof GuiRenameWorld || event.gui instanceof GuiCreateWorld || event.gui instanceof GuiYesNo)) {
            return;
        }
        String narrationText = null;
        Object hoveredElement = null;
        if (event.gui instanceof GuiSelectWorld) {
            result = this.getSelectWorldHoverText((GuiSelectWorld)event.gui);
            narrationText = (String)result[0];
            hoveredElement = result[1];
        } else if (event.gui instanceof GuiRenameWorld) {
            result = this.getRenameWorldHoverText((GuiRenameWorld)event.gui);
            narrationText = (String)result[0];
            hoveredElement = result[1];
        } else if (event.gui instanceof GuiCreateWorld) {
            result = this.getCreateWorldHoverText((GuiCreateWorld)event.gui);
            narrationText = (String)result[0];
            hoveredElement = result[1];
        } else if (event.gui instanceof GuiYesNo) {
            result = this.getYesNoHoverText((GuiYesNo)event.gui);
            narrationText = (String)result[0];
            hoveredElement = result[1];
        }
        if (hoveredElement != null) {
            if (this.currentHoveredElement != hoveredElement) {
                this.currentHoveredElement = hoveredElement;
                this.hoverStartTime = System.currentTimeMillis();
                this.lastNarratedText = null;
            }
            if (this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                boolean shouldNarrateOnce;
                boolean bl = shouldNarrateOnce = hoveredElement instanceof String || hoveredElement instanceof GuiTextField || hoveredElement.toString().startsWith("gui_yesno");
                if (shouldNarrateOnce) {
                    if (this.lastNarratedText == null && narrationText != null && !narrationText.trim().isEmpty()) {
                        AudioPlayer.speakAsync(narrationText);
                        this.lastNarratedText = narrationText;
                    }
                } else if (narrationText != null && !narrationText.equals(this.lastNarratedText) && !narrationText.trim().isEmpty()) {
                    AudioPlayer.speakAsync(narrationText);
                    this.lastNarratedText = narrationText;
                }
            }
        } else {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
        }
    }

    private Object[] getSelectWorldHoverText(GuiSelectWorld guiSelectWorld) {
        try {
            Field rightField;
            Field leftField;
            Field bottomField;
            Field topField;
            int mouseX = Mouse.getX() * guiSelectWorld.field_146294_l / this.mc.field_71443_c;
            int mouseY = guiSelectWorld.field_146295_m - Mouse.getY() * guiSelectWorld.field_146295_m / this.mc.field_71440_d;
            String titleText = StatCollector.func_74838_a((String)"selectWorld.title");
            int titleWidth = this.mc.field_71466_p.func_78256_a(titleText);
            int titleX = (guiSelectWorld.field_146294_l - titleWidth) / 2 - 1;
            int titleY = 20;
            if (this.isMouseOver(titleX, titleY, titleWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                return new Object[]{titleText, "title_select_world"};
            }
            Field worldSelectionListField = GuiSelectWorld.class.getDeclaredField("field_146638_t");
            worldSelectionListField.setAccessible(true);
            Object worldSelectionList = worldSelectionListField.get(guiSelectWorld);
            try {
                topField = worldSelectionList.getClass().getSuperclass().getDeclaredField("field_148153_b");
            }
            catch (NoSuchFieldException e) {
                topField = worldSelectionList.getClass().getSuperclass().getDeclaredField("top");
            }
            topField.setAccessible(true);
            int listTop = (Integer)topField.get(worldSelectionList);
            try {
                bottomField = worldSelectionList.getClass().getSuperclass().getDeclaredField("field_148154_c");
            }
            catch (NoSuchFieldException e) {
                bottomField = worldSelectionList.getClass().getSuperclass().getDeclaredField("bottom");
            }
            bottomField.setAccessible(true);
            int listBottom = (Integer)bottomField.get(worldSelectionList);
            try {
                leftField = worldSelectionList.getClass().getSuperclass().getDeclaredField("field_148152_e");
            }
            catch (NoSuchFieldException e) {
                leftField = worldSelectionList.getClass().getSuperclass().getDeclaredField("left");
            }
            leftField.setAccessible(true);
            int listLeft = (Integer)leftField.get(worldSelectionList);
            try {
                rightField = worldSelectionList.getClass().getSuperclass().getDeclaredField("field_148151_d");
            }
            catch (NoSuchFieldException e) {
                rightField = worldSelectionList.getClass().getSuperclass().getDeclaredField("right");
            }
            rightField.setAccessible(true);
            int listRight = (Integer)rightField.get(worldSelectionList);
            if (mouseY < listTop + 1 || mouseY > listBottom + 1 || mouseX < listLeft || mouseX > listRight) {
                return new Object[]{null, null};
            }
            Method getIndexUnderMouseMethod = this.findMethod(worldSelectionList.getClass(), Integer.TYPE, Integer.TYPE);
            if (getIndexUnderMouseMethod == null) {
                return new Object[]{null, null};
            }
            getIndexUnderMouseMethod.setAccessible(true);
            int hoveredIndex = (Integer)getIndexUnderMouseMethod.invoke(worldSelectionList, mouseX, mouseY);
            if (hoveredIndex >= 0) {
                Field worldSummaryListField = GuiSelectWorld.class.getDeclaredField("field_146639_s");
                worldSummaryListField.setAccessible(true);
                List worldSummaryList = (List)worldSummaryListField.get(guiSelectWorld);
                if (hoveredIndex < worldSummaryList.size()) {
                    SaveFormatComparator worldSummary = (SaveFormatComparator)worldSummaryList.get(hoveredIndex);
                    String worldName = worldSummary.func_75788_b();
                    if (worldName == null || worldName.isEmpty()) {
                        worldName = StatCollector.func_74838_a((String)"selectWorld.world") + " " + (hoveredIndex + 1);
                    }
                    String folderName = worldSummary.func_75786_a();
                    String lastPlayed = this.formatWorldDate(worldSummary.func_75784_e());
                    Field gameModeArrayField = GuiSelectWorld.class.getDeclaredField("field_146635_w");
                    gameModeArrayField.setAccessible(true);
                    String[] gameModeArray = (String[])gameModeArrayField.get(guiSelectWorld);
                    String gameMode = gameModeArray[worldSummary.func_75790_f().func_77148_a()];
                    if (worldSummary.func_75789_g()) {
                        gameMode = StatCollector.func_74838_a((String)"gameMode.hardcore");
                    }
                    if (worldSummary.func_75783_h()) {
                        gameMode = gameMode + ", " + StatCollector.func_74838_a((String)"selectWorld.cheats");
                    }
                    return new Object[]{worldName + ", " + folderName + " (" + lastPlayed + "), " + gameMode, worldSummary};
                }
            }
            return new Object[]{null, null};
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Error in WorldNarrator (GuiSelectWorld): " + e.getMessage());
            e.printStackTrace();
            return new Object[]{null, null};
        }
    }

    private Object[] getRenameWorldHoverText(GuiRenameWorld guiRenameWorld) {
        try {
            int titleY;
            int mouseX = Mouse.getX() * guiRenameWorld.field_146294_l / this.mc.field_71443_c;
            int mouseY = guiRenameWorld.field_146295_m - Mouse.getY() * guiRenameWorld.field_146295_m / this.mc.field_71440_d;
            String enterNameText = StatCollector.func_74838_a((String)"selectWorld.enterName");
            int enterNameWidth = this.mc.field_71466_p.func_78256_a(enterNameText);
            int enterNameX = guiRenameWorld.field_146294_l / 2 - 101;
            int enterNameY = 47;
            if (this.isMouseOver(enterNameX, enterNameY, enterNameWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                return new Object[]{enterNameText, "label_enter_name_rename_world"};
            }
            String titleText = StatCollector.func_74838_a((String)"selectWorld.renameTitle");
            int titleWidth = this.mc.field_71466_p.func_78256_a(titleText);
            int titleX = (guiRenameWorld.field_146294_l - titleWidth) / 2 - 1;
            if (this.isMouseOver(titleX, titleY = 20, titleWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                return new Object[]{titleText, "title_rename_world"};
            }
            GuiTextField textField = null;
            for (Field field : GuiRenameWorld.class.getDeclaredFields()) {
                if (!field.getType().equals(GuiTextField.class)) continue;
                field.setAccessible(true);
                textField = (GuiTextField)field.get(guiRenameWorld);
                break;
            }
            if (textField != null && this.isMouseOver(textField, mouseX, mouseY)) {
                String narrationText = textField.func_146179_b();
                return new Object[]{narrationText, textField};
            }
            return new Object[]{null, null};
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Error in WorldNarrator (GuiRenameWorld): " + e.getMessage());
            e.printStackTrace();
            return new Object[]{null, null};
        }
    }

    private Object[] getCreateWorldHoverText(GuiCreateWorld guiCreateWorld) {
        try {
            int mouseX = Mouse.getX() * guiCreateWorld.field_146294_l / this.mc.field_71443_c;
            int mouseY = guiCreateWorld.field_146295_m - Mouse.getY() * guiCreateWorld.field_146295_m / this.mc.field_71440_d;
            GuiTextField worldNameTextField = null;
            GuiTextField seedTextField = null;
            String folderName = "";
            boolean isMoreOptionsOpen = false;
            Field worldNameField = GuiCreateWorld.class.getDeclaredField("field_146333_g");
            worldNameField.setAccessible(true);
            worldNameTextField = (GuiTextField)worldNameField.get(guiCreateWorld);
            Field seedField = GuiCreateWorld.class.getDeclaredField("field_146335_h");
            seedField.setAccessible(true);
            seedTextField = (GuiTextField)seedField.get(guiCreateWorld);
            Field folderNameField = GuiCreateWorld.class.getDeclaredField("field_146336_i");
            folderNameField.setAccessible(true);
            folderName = (String)folderNameField.get(guiCreateWorld);
            Field moreOptionsOpenField = GuiCreateWorld.class.getDeclaredField("field_146344_y");
            moreOptionsOpenField.setAccessible(true);
            isMoreOptionsOpen = moreOptionsOpenField.getBoolean(guiCreateWorld);
            String titleText = StatCollector.func_74838_a((String)"selectWorld.create");
            int titleWidth = this.mc.field_71466_p.func_78256_a(titleText);
            int titleX = (guiCreateWorld.field_146294_l - titleWidth) / 2 - 1;
            int titleY = 20;
            if (this.isMouseOver(titleX, titleY, titleWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                return new Object[]{titleText, "title_create_world"};
            }
            if (isMoreOptionsOpen) {
                int enterSeedX = guiCreateWorld.field_146294_l / 2 - 101;
                int enterSeedY = 47;
                String enterSeedText = StatCollector.func_74838_a((String)"selectWorld.enterSeed");
                int enterSeedWidth = this.mc.field_71466_p.func_78256_a(enterSeedText);
                if (this.isMouseOver(enterSeedX, enterSeedY, enterSeedWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                    return new Object[]{enterSeedText, "label_enter_seed"};
                }
                int seedInfoX = guiCreateWorld.field_146294_l / 2 - 101;
                int seedInfoY = 85;
                String seedInfoText = StatCollector.func_74838_a((String)"selectWorld.seedInfo");
                int seedInfoWidth = this.mc.field_71466_p.func_78256_a(seedInfoText);
                if (this.isMouseOver(seedInfoX, seedInfoY, seedInfoWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                    return new Object[]{seedInfoText, "label_seed_info"};
                }
                if (this.isMouseOver(seedTextField, mouseX, mouseY)) {
                    String narrationText = seedTextField.func_146179_b();
                    return new Object[]{narrationText, seedTextField};
                }
            } else {
                int enterNameX = guiCreateWorld.field_146294_l / 2 - 101;
                int enterNameY = 47;
                String enterNameText = StatCollector.func_74838_a((String)"selectWorld.enterName");
                int enterNameWidth = this.mc.field_71466_p.func_78256_a(enterNameText);
                if (this.isMouseOver(enterNameX, enterNameY, enterNameWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                    return new Object[]{enterNameText, "label_enter_name"};
                }
                if (this.isMouseOver(worldNameTextField, mouseX, mouseY)) {
                    String narrationText = worldNameTextField.func_146179_b();
                    return new Object[]{narrationText, worldNameTextField};
                }
                int resultFolderX = guiCreateWorld.field_146294_l / 2 - 101;
                int resultFolderY = 85;
                String resultFolderText = StatCollector.func_74838_a((String)"selectWorld.resultFolder") + " " + folderName;
                int resultFolderWidth = this.mc.field_71466_p.func_78256_a(resultFolderText);
                if (this.isMouseOver(resultFolderX, resultFolderY, resultFolderWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                    return new Object[]{resultFolderText, "label_result_folder"};
                }
            }
            return new Object[]{null, null};
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Error in WorldNarrator (GuiCreateWorld): " + e.getMessage());
            e.printStackTrace();
            return new Object[]{null, null};
        }
    }

    private Object[] getYesNoHoverText(GuiYesNo guiYesNo) {
        try {
            Field warningField;
            Field messageField;
            int mouseX = Mouse.getX() * guiYesNo.field_146294_l / this.mc.field_71443_c;
            int mouseY = guiYesNo.field_146295_m - Mouse.getY() * guiYesNo.field_146295_m / this.mc.field_71440_d;
            try {
                messageField = GuiYesNo.class.getDeclaredField("field_146351_f");
            }
            catch (NoSuchFieldException e) {
                messageField = GuiYesNo.class.getDeclaredField("messageLine1");
            }
            messageField.setAccessible(true);
            String question = (String)messageField.get(guiYesNo);
            try {
                warningField = GuiYesNo.class.getDeclaredField("field_146354_r");
            }
            catch (NoSuchFieldException e) {
                warningField = GuiYesNo.class.getDeclaredField("messageLine2");
            }
            warningField.setAccessible(true);
            String warning = (String)warningField.get(guiYesNo);
            int questionWidth = this.mc.field_71466_p.func_78256_a(question);
            int questionX = (guiYesNo.field_146294_l - questionWidth) / 2 - 1;
            int questionY = 70;
            int warningWidth = this.mc.field_71466_p.func_78256_a(warning);
            int warningX = (guiYesNo.field_146294_l - warningWidth) / 2 - 1;
            int warningY = 90;
            if (this.isMouseOver(questionX, questionY, questionWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                return new Object[]{question, "gui_yesno_question"};
            }
            if (this.isMouseOver(warningX, warningY, warningWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                return new Object[]{warning, "gui_yesno_warning"};
            }
            return new Object[]{null, null};
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Error in WorldNarrator (GuiYesNo): " + e.getMessage());
            return new Object[]{null, null};
        }
    }

    private Method findMethod(Class<?> clazz, Class<?> ... parameterTypes) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (String name : new String[]{"func_148124_c", "getSlotIndexFromScreenCoords"}) {
                try {
                    return currentClass.getDeclaredMethod(name, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return null;
    }

    private boolean isMouseOver(GuiTextField textField, int mouseX, int mouseY) {
        if (!textField.func_146176_q()) {
            return false;
        }
        return mouseX >= textField.field_146209_f && mouseX <= textField.field_146209_f + textField.field_146218_h && mouseY >= textField.field_146210_g && mouseY <= textField.field_146210_g + textField.field_146219_i;
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

