/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.network;

import com.gedeongrays.narrator.config.NarratorConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;

public class PiperClient {
    private static File executableFile = null;
    private static File voiceModelFile = null;
    private static File voiceModelJSONFile = null;
    private static File baseDir = null;
    private static File tempDir = null;
    private static File cacheDir = null;
    private static final ScheduledExecutorService cleanupScheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable, "PiperTTS-Cleanup-Thread");
        thread.setDaemon(true);
        return thread;
    });

    public static File getBaseDir() {
        return baseDir;
    }

    private static void extractFiles() throws IOException, URISyntaxException {
        PiperClient.extractDirectory(new File(baseDir, "espeak-ng-data"));
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (osName.contains("win")) {
            PiperClient.extractSpecificFiles(Arrays.asList("pipertts/win/espeak-ng.dll", "pipertts/win/onnxruntime.dll", "pipertts/win/piper_phonemize.dll", "pipertts/win/piper"), baseDir);
            executableFile = new File(baseDir, "piper");
        } else if (osName.contains("linux")) {
            PiperClient.extractSpecificFiles(Arrays.asList("pipertts/linux/libespeak-ng.so.1", "pipertts/linux/libonnxruntime.so.1.14.1", "pipertts/linux/libpiper_phonemize.so.1", "pipertts/linux/piper"), baseDir);
            executableFile = new File(baseDir, "piper");
        } else if (osName.contains("mac")) {
            PiperClient.extractSpecificFiles(Arrays.asList("pipertts/mac/libespeak-ng.1.52.0.1.dylib", "pipertts/mac/libespeak-ng.1.dylib", "pipertts/mac/libonnxruntime.1.14.1.dylib", "pipertts/mac/libpiper_phonemize.1.2.0.dylib", "pipertts/mac/libpiper_phonemize.1.dylib", "pipertts/mac/piper"), baseDir);
            executableFile = new File(baseDir, "piper");
        }
        if (executableFile != null && executableFile.exists()) {
            executableFile.setExecutable(true);
        }
    }

    private static void extractSpecificFiles(List<String> resourcePaths, File destinationDir) throws IOException, URISyntaxException {
        URI uri = PiperClient.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        if (uri.getScheme().equals("file")) {
            NarratorConfig.log("[PiperTTS] Working in the development environment. Skipping extraction from JAR.");
            return;
        }
        String uriString = uri.toString().replace(" ", "%20");
        URI fixedUri = URI.create(uriString);
        try (FileSystem fs = FileSystems.newFileSystem(fixedUri, Collections.emptyMap());){
            for (String resourcePath : resourcePaths) {
                Path source = fs.getPath("/" + resourcePath, new String[0]);
                Path relativeSource = Paths.get(resourcePath, new String[0]).getFileName();
                Path destination = destinationDir.toPath().resolve(relativeSource.toString());
                Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static void extractDirectory(File destinationDir) throws IOException, URISyntaxException {
        URI uri = PiperClient.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        if (uri.getScheme().equals("file")) {
            NarratorConfig.log("[PiperTTS] Working in the development environment. Skipping extraction from JAR.");
            return;
        }
        String uriString = uri.toString().replace(" ", "%20");
        URI fixedUri = URI.create(uriString);
        try (FileSystem fs = FileSystems.newFileSystem(fixedUri, Collections.emptyMap());){
            Path sourceDir = fs.getPath("/pipertts/espeak-ng-data", new String[0]);
            Iterator iterator = Files.walk(sourceDir, new FileVisitOption[0]).iterator();
            while (iterator.hasNext()) {
                Path source = (Path)iterator.next();
                Path relativeSource = sourceDir.relativize(source);
                Path destination = destinationDir.toPath().resolve(relativeSource.toString());
                if (Files.isDirectory(source, new LinkOption[0])) {
                    Files.createDirectories(destination, new FileAttribute[0]);
                    continue;
                }
                Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static void scheduleMaintenance() {
        cleanupScheduler.scheduleWithFixedDelay(() -> {
            File[] files = tempDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().startsWith("piper_tts_")) continue;
                    if (file.delete()) {
                        NarratorConfig.log("[PiperTTS] Old temp file successfully deleted: " + file.getName());
                        continue;
                    }
                    NarratorConfig.log("[PiperTTS] Unable to delete old temp file: " + file.getName());
                }
            }
            PiperClient.performCacheMaintenance();
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private static void performCacheMaintenance() {
        int maxSizeMB = NarratorConfig.cacheMaxSizeMB;
        if (maxSizeMB <= 0) {
            return;
        }
        long maxSizeB = (long)maxSizeMB * 1024L * 1024L;
        try {
            long currentSizeB = FileUtils.sizeOfDirectory((File)cacheDir);
            if (currentSizeB > maxSizeB) {
                NarratorConfig.logf("[PiperTTS] Cache limit exceeded. Current size: %.2f MB, Limit: %d MB. Full cleanup started.\n", (double)currentSizeB / 1048576.0, maxSizeMB);
                PiperClient.clearCacheDirectory();
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[PiperTTS] Error checking size or clearing cache: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void clearCacheDirectory() {
        if (cacheDir == null || !cacheDir.exists() || !cacheDir.isDirectory()) {
            NarratorConfig.logError("[PiperTTS] Unable to clear cache: folder not found.");
            return;
        }
        File[] files = cacheDir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        int filesDeleted = 0;
        long bytesDeleted = 0L;
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    long size = FileUtils.sizeOfDirectory((File)file);
                    FileUtils.deleteDirectory((File)file);
                    bytesDeleted += size;
                    ++filesDeleted;
                    continue;
                }
                if (file.delete()) {
                    long fileSize = file.length();
                    ++filesDeleted;
                    bytesDeleted += fileSize;
                    continue;
                }
                NarratorConfig.logError("[PiperTTS] Failed to delete file in cache: " + file.getName());
            }
            catch (IOException e) {
                NarratorConfig.logError("[PiperTTS] Failed to delete " + file.getName() + " in cache: " + e.getMessage());
            }
        }
        if (filesDeleted > 0) {
            NarratorConfig.logf("[PiperTTS] Complete %s folder cleanup finished. %d files (%.2f MB) deleted.\n", "cache", filesDeleted, (double)bytesDeleted / 1048576.0);
        }
    }

    private static String getCacheKey(String text, String modelIdentifier) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String dataToHash = modelIdentifier + "|" + text;
            byte[] hash = md.digest(dataToHash.getBytes(StandardCharsets.UTF_8));
            return new BigInteger(1, hash).toString(16) + ".wav";
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return String.valueOf(text.hashCode()) + ".wav";
        }
    }

    public static byte[] synthesizeAudio(String text) throws IOException, InterruptedException {
        boolean deleted;
        Throwable throwable;
        File voicesDir = new File(baseDir, "voices");
        String currentLang = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        File langVoicesDir = new File(voicesDir, currentLang);
        if (!langVoicesDir.exists()) {
            langVoicesDir.mkdirs();
            NarratorConfig.log("[PiperTTS] A new directory has been created for the language: " + currentLang);
        }
        voiceModelFile = null;
        voiceModelJSONFile = null;
        String activeModelIdentifier = null;
        File[] onnxFiles = langVoicesDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".onnx"));
        if (onnxFiles != null) {
            for (File onnx : onnxFiles) {
                String baseName = onnx.getName().substring(0, onnx.getName().lastIndexOf(46));
                File json = new File(langVoicesDir, baseName + ".onnx.json");
                if (!json.exists()) continue;
                voiceModelFile = onnx;
                voiceModelJSONFile = json;
                activeModelIdentifier = onnx.getName();
                break;
            }
        }
        if (activeModelIdentifier == null) {
            NarratorConfig.logError("[PiperTTS] Model files not found. Narration is not possible.");
            return null;
        }
        String cacheKey = PiperClient.getCacheKey(text, activeModelIdentifier);
        File cacheFile = new File(cacheDir, cacheKey);
        if (NarratorConfig.enableCaching && cacheFile.exists() && cacheFile.length() > 0L) {
            try {
                NarratorConfig.log("[PiperTTS] The audio file was found in the cache.");
                return Files.readAllBytes(cacheFile.toPath());
            }
            catch (IOException e) {
                NarratorConfig.logError("[PiperTTS] Error reading from cache. Resynthesis.");
                e.printStackTrace();
            }
        }
        if (!(executableFile != null && executableFile.exists() && voiceModelFile != null && voiceModelFile.exists() && voiceModelJSONFile != null && voiceModelJSONFile.exists())) {
            NarratorConfig.logError("[PiperTTS] PiperTTS or model files not found. Narration is not possible.");
            return null;
        }
        File espeakDataDir = new File(baseDir, "espeak-ng-data");
        if (!espeakDataDir.exists()) {
            NarratorConfig.logError("[PiperTTS] Folder espeak-ng-data not found! Narration is not possible.");
            return null;
        }
        File tempAudioFile = File.createTempFile("piper_tts_", ".wav", tempDir);
        ProcessBuilder pb = new ProcessBuilder(executableFile.getAbsolutePath(), "--model", voiceModelFile.getAbsolutePath(), "--output_file", tempAudioFile.getAbsolutePath());
        pb.directory(baseDir);
        Process process = pb.start();
        try (OutputStream os = process.getOutputStream();){
            throwable = null;
            try (InputStream errorStream = process.getErrorStream();){
                int len;
                os.write((text + "\n").getBytes(StandardCharsets.UTF_8));
                os.flush();
                os.close();
                ByteArrayOutputStream errorBytes = new ByteArrayOutputStream();
                byte[] errorBuffer = new byte[1024];
                while ((len = errorStream.read(errorBuffer)) != -1) {
                    errorBytes.write(errorBuffer, 0, len);
                }
                if (errorBytes.size() > 0) {
                    NarratorConfig.logError("[PiperTTS] Errors/logs:\n" + errorBytes.toString("UTF-8"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        int exitCode = process.waitFor();
        NarratorConfig.log("[PiperTTS] The process ended with the code: " + exitCode);
        if (exitCode != 0 || !tempAudioFile.exists() || tempAudioFile.length() == 0L) {
            boolean deleted2;
            NarratorConfig.logError("[PiperTTS] File not created or empty. Size: " + tempAudioFile.length() + " B");
            if (tempAudioFile.exists() && tempAudioFile.length() == 0L && (deleted2 = tempAudioFile.delete())) {
                NarratorConfig.log("[PiperTTS] Deleted empty temp file.");
            }
            return null;
        }
        byte[] audioBytes = Files.readAllBytes(tempAudioFile.toPath());
        if (NarratorConfig.enableCaching) {
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(cacheFile);){
                fos.write(audioBytes);
                NarratorConfig.log("[PiperTTS] The audio file has been saved to the cache.");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        if (tempAudioFile.exists() && (deleted = tempAudioFile.delete())) {
            NarratorConfig.log("[PiperTTS] Deleted temp file: " + tempAudioFile.getName());
        }
        return audioBytes;
    }

    public static File getCacheDir() {
        return cacheDir;
    }

    public static void shutdownCleanupScheduler() {
        cleanupScheduler.shutdown();
    }

    static {
        try {
            File voicesDir;
            baseDir = new File(Minecraft.func_71410_x().field_71412_D, "config/Narrator/PiperTTS");
            if (!baseDir.exists()) {
                baseDir.mkdirs();
            }
            if (!(tempDir = new File(baseDir, "temp")).exists()) {
                tempDir.mkdirs();
            }
            if (!(cacheDir = new File(baseDir, "cache")).exists()) {
                cacheDir.mkdirs();
            }
            if (!(voicesDir = new File(baseDir, "voices")).exists()) {
                voicesDir.mkdirs();
            }
            PiperClient.extractFiles();
            PiperClient.scheduleMaintenance();
        }
        catch (IOException | URISyntaxException e) {
            NarratorConfig.logError("[PiperTTS] Error during file initialization:");
            e.printStackTrace();
        }
    }
}

