/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import top.byteeeee.fuzz.FuzzModClient;
import top.byteeeee.fuzz.config.FuzzConfig;
import top.byteeeee.fuzz.config.FuzzRuleConfig;
import top.byteeeee.fuzz.observers.ReloadClientResourceObserver;
import top.byteeeee.fuzz.observers.rule.fuzzCommandAlias.FuzzCommandAliasObserver;
import top.byteeeee.fuzz.settings.ObserverManager;
import top.byteeeee.fuzz.settings.Rule;
import top.byteeeee.fuzz.settings.ValidatorManager;
import top.byteeeee.fuzz.validators.rule.BiomeColor.BiomeColorValidator;
import top.byteeeee.fuzz.validators.rule.blockOutlineAlpha.BlockOutlineAlphaValidator;
import top.byteeeee.fuzz.validators.rule.blockOutlineColor.BlockOutlineColorValidator;
import top.byteeeee.fuzz.validators.rule.blockOutlineWidth.BlockOutlineWidthValidator;
import top.byteeeee.fuzz.validators.rule.fuzzCommandAlias.FuzzCommandAliasValidator;
import top.byteeeee.fuzz.validators.rule.rainbowBlockoutlineBlinkSpeed.RainbowBlockOutlineBlinkSpeedValidator;

@Environment(value=EnvType.CLIENT)
public class FuzzSettings {
    public static Map<String, Object> DEFAULT_VALUES = new ConcurrentHashMap<String, Object>();
    public static List<String> highlightEntityList = new ArrayList<String>();
    @Rule(options={"none", "en_us", "zh_cn"}, categories={"FUZZ", "QOL"})
    public static String language = "none";
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean usingItemSlowDownDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean sneakingSlowDownDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean hurtShakeDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "render"})
    public static boolean renderHandDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean bedRockFlying = false;
    @Rule(options={"false", "rainbow", "#FFFFFF", "#FF88C2"}, categories={"FUZZ", "feature", "survival", "render"}, validators={BlockOutlineColorValidator.class}, strict=false)
    public static String blockOutlineColor = "false";
    @Rule(options={"0.1024", "1.024", "5.20", "10.0"}, categories={"FUZZ", "feature", "survival", "render"}, validators={RainbowBlockOutlineBlinkSpeedValidator.class}, strict=false)
    public static double rainbowBlockOutlineBlinkSpeed = 1.024;
    @Rule(options={"-1", "0", "255"}, categories={"FUZZ", "feature", "survival", "render"}, validators={BlockOutlineAlphaValidator.class}, strict=false)
    public static int blockOutlineAlpha = -1;
    @Rule(options={"-1.0", "0.0", "10.0"}, categories={"FUZZ", "feature", "survival", "render"}, validators={BlockOutlineWidthValidator.class}, strict=false)
    public static double blockOutlineWidth = -1.0;
    @Rule(options={"false", "#FF88C2"}, categories={"FUZZ", "feature", "survival", "render"}, validators={BiomeColorValidator.class}, observers={ReloadClientResourceObserver.class}, strict=false)
    public static String skyColor = "false";
    @Rule(options={"false", "#FF88C2"}, categories={"FUZZ", "feature", "survival", "render"}, validators={BiomeColorValidator.class}, observers={ReloadClientResourceObserver.class}, strict=false)
    public static String fogColor = "false";
    @Rule(options={"false", "#FF88C2"}, categories={"FUZZ", "feature", "survival", "render"}, validators={BiomeColorValidator.class}, observers={ReloadClientResourceObserver.class}, strict=false)
    public static String waterColor = "false";
    @Rule(options={"false", "#FF88C2"}, categories={"FUZZ", "feature", "survival", "render"}, validators={BiomeColorValidator.class}, observers={ReloadClientResourceObserver.class}, strict=false)
    public static String waterFogColor = "false";
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean campfireSmokeParticleDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL", "carpet"})
    public static boolean quickKickFakePlayer = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL", "carpet"})
    public static boolean quickDropFakePlayerAllItemStack = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL", "experimental"})
    public static boolean letFluidInteractLikeAir = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean fluidPushDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean slimeBlockSlowDownDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean cobwebSlowDownDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean iceSlipperinessDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean soulSandBlockSlowDownDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean honeyBlockSlowDownDisabled = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean bubbleColumnInteractDisabled = false;
    @Rule(options={"false", "true", "sneaking"}, categories={"FUZZ", "feature", "creative", "QOL"})
    public static String pickFluidBucketItemInCreative = "false";
    @Rule(categories={"FUZZ", "feature", "survival", "command"})
    public static boolean commandHighlightEntities = false;
    @Rule(categories={"FUZZ", "feature", "survival", "QOL"})
    public static boolean jumpDelayDisabled = false;
    @Rule(options={"false"}, categories={"FUZZ", "command"}, validators={FuzzCommandAliasValidator.class}, observers={FuzzCommandAliasObserver.class}, strict=false)
    public static String fuzzCommandAlias = "false";
    @Rule(categories={"FUZZ", "render"})
    public static boolean fogRenderDisabled = false;
    @Rule(categories={"FUZZ", "survival", "command"})
    public static boolean commandCoordCompass = false;
    @Rule(options={"false", "fuzz"}, categories={"FUZZ", "QOL"})
    public static String parseCoordInMessage = "false";

    static {
        for (Field field : FuzzSettings.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Rule.class)) continue;
            try {
                field.setAccessible(true);
                Object defaultValue = field.get(null);
                DEFAULT_VALUES.put(field.getName(), defaultValue);
                ValidatorManager.init(field);
                ObserverManager.init(field);
            }
            catch (IllegalAccessException e) {
                FuzzModClient.LOGGER.warn((Object)e);
            }
        }
        FuzzConfig.load();
        FuzzRuleConfig.load();
    }
}

