/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.minecraft.class_124;
import top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler.ArgumentHandlerInterface;
import top.byteeeee.fuzz.commands.fuzzCommands.context.FuzzCommandContext;
import top.byteeeee.fuzz.config.FuzzConfig;
import top.byteeeee.fuzz.settings.ObserverManager;
import top.byteeeee.fuzz.settings.Rule;
import top.byteeeee.fuzz.settings.ValidatorManager;
import top.byteeeee.fuzz.translations.FuzzTranslations;
import top.byteeeee.fuzz.translations.Translator;
import top.byteeeee.fuzz.utils.Messenger;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractArgumentHandler<T>
implements ArgumentHandlerInterface<T> {
    protected static final Translator tr = new Translator("command");
    protected Field currentField;

    @Override
    public void configureArgument(LiteralArgumentBuilder<FabricClientCommandSource> literal, Field field) {
        this.currentField = field;
        RequiredArgumentBuilder<FabricClientCommandSource, T> valueArg = this.buildValueArgument(field);
        ((LiteralArgumentBuilder)literal.executes(ctx -> FuzzCommandContext.showRuleInfo((FabricClientCommandSource)ctx.getSource(), field))).then(valueArg);
    }

    private RequiredArgumentBuilder<FabricClientCommandSource, T> buildValueArgument(Field field) {
        return (RequiredArgumentBuilder)ClientCommandManager.argument((String)"value", this.getArgumentType()).suggests(this::getSuggestions).executes(ctx -> this.executeSetValue((CommandContext<FabricClientCommandSource>)ctx, field));
    }

    private int executeSetValue(CommandContext<FabricClientCommandSource> ctx, Field field) throws CommandSyntaxException {
        Object value = this.parseValue(ctx);
        if (!this.validateInputValue(ctx, value)) {
            return 0;
        }
        Object validatedValue = this.validateWithManager(ctx, field, value);
        if (validatedValue == null) {
            return 0;
        }
        Optional<T> oldValue = this.getOldValue(field);
        if (!oldValue.isPresent()) {
            return 0;
        }
        if (!this.setNewValue(field, validatedValue)) {
            return 0;
        }
        this.sendSuccessMessage(ctx, field, validatedValue);
        ObserverManager.notifyObservers(field, oldValue.get(), validatedValue);
        return 1;
    }

    private boolean validateInputValue(CommandContext<FabricClientCommandSource> ctx, T value) {
        if (this.isStrictMode() && !this.isValidOption(value.toString())) {
            Messenger.tell((FabricClientCommandSource)ctx.getSource(), tr.tr("is_not_valid_value", new Object[0]).method_27692(class_124.field_1061));
            return false;
        }
        return true;
    }

    private T validateWithManager(CommandContext<FabricClientCommandSource> ctx, Field field, T value) {
        T validatedValue = ValidatorManager.validateValue(field, value, (FabricClientCommandSource)ctx.getSource());
        if (validatedValue == null) {
            List<String> descriptions = ValidatorManager.getValidatorDescriptions(field);
            String errorMsg = descriptions.isEmpty() ? "Validation failed" : descriptions.get(0);
            Messenger.tell((FabricClientCommandSource)ctx.getSource(), Messenger.s(errorMsg).method_27692(class_124.field_1061));
            return null;
        }
        return validatedValue;
    }

    private Optional<T> getOldValue(Field field) {
        try {
            Object currentValue = field.get(null);
            return Optional.ofNullable(currentValue);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to get field value", e);
        }
    }

    private boolean setNewValue(Field field, T value) {
        try {
            field.set(null, value);
            FuzzConfig.saveConfig();
            return true;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set field value", e);
        }
    }

    protected boolean isValidOption(String value) {
        if (!this.isStrictMode()) {
            return true;
        }
        String[] options = this.getAnnotationOptions();
        return options.length == 0 || Arrays.asList(options).contains(value);
    }

    protected boolean isStrictMode() {
        return Optional.ofNullable(this.currentField).map(field -> field.getAnnotation(Rule.class)).map(Rule::strict).orElse(false);
    }

    protected String[] getAnnotationOptions() {
        return Optional.ofNullable(this.currentField).map(field -> field.getAnnotation(Rule.class)).map(Rule::options).orElse(new String[0]);
    }

    private void sendSuccessMessage(CommandContext<FabricClientCommandSource> ctx, Field field, T value) {
        String funcNameTrKey = tr.getRuleNameTrKey(field.getName());
        if (FuzzTranslations.isEnglish()) {
            Messenger.tell((FabricClientCommandSource)ctx.getSource(), tr.tr("set_value", field.getName(), value));
        } else {
            Messenger.tell((FabricClientCommandSource)ctx.getSource(), tr.tr("set_value", Messenger.tr(funcNameTrKey, new Object[0]), field.getName(), value));
        }
    }

    protected abstract ArgumentType<T> getArgumentType();
}

