/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.translations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.byteeeee.fuzz.FuzzModClient;
import top.byteeeee.fuzz.FuzzSettings;
import top.byteeeee.fuzz.utils.FileUtil;
import top.byteeeee.yaml.TinyYamlParser;
import top.byteeeee.yaml.exception.YamlParseException;

public class FuzzTranslations {
    private static final String LANG_DIR = "assets/fuzz/lang";
    private static final String DEFAULT_LANGUAGE = "en_us";
    public static final Map<String, Map<String, String>> translations = new LinkedHashMap<String, Map<String, String>>();
    public static final Set<String> languages = new HashSet<String>();

    public static void loadTranslations() {
        try {
            List<String> availableLanguages = FuzzTranslations.getAvailableLanguages();
            for (String language : availableLanguages) {
                try {
                    Map<String, String> translation = FuzzTranslations.loadTranslationForLanguage(language);
                    translations.put(language, translation);
                    languages.add(language);
                }
                catch (IOException | YamlParseException e) {
                    FuzzModClient.LOGGER.warn("Failed to load translation for language: {}", (Object)language, (Object)e);
                }
            }
        }
        catch (IOException | YamlParseException e) {
            FuzzModClient.LOGGER.warn("Failed to get available languages", e);
        }
    }

    private static List<String> getAvailableLanguages() throws IOException, YamlParseException {
        String yamlData = FileUtil.readFile("assets/fuzz/lang/meta/languages.yml");
        Map yamlMap = TinyYamlParser.parse((String)yamlData);
        ArrayList languagesObj = yamlMap.getOrDefault("languages", new ArrayList());
        if (languagesObj instanceof List) {
            return TinyYamlParser.getNestedStringList((Map)yamlMap, (String)"languages");
        }
        return new ArrayList<String>();
    }

    private static Map<String, String> loadTranslationForLanguage(String language) throws IOException, YamlParseException {
        String path = "assets/fuzz/lang/" + language + ".yml";
        String data = FileUtil.readFile(path);
        Map yaml = TinyYamlParser.parse((String)data);
        LinkedHashMap<String, String> translation = new LinkedHashMap<String, String>();
        FuzzTranslations.buildTranslationMap(translation, yaml, "");
        return translation;
    }

    private static void buildTranslationMap(Map<String, String> translation, Map<String, Object> yaml, String prefix) {
        yaml.forEach((key, value) -> {
            String fullKey;
            String string = fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (value instanceof String) {
                translation.put(fullKey, (String)value);
            } else if (value instanceof Map) {
                FuzzTranslations.buildTranslationMap(translation, (Map)value, fullKey);
            } else if (value == null) {
                translation.put(fullKey, "");
            } else {
                translation.put(fullKey, String.valueOf(value));
            }
        });
    }

    public static String getLanguage() {
        String configLanguage = FuzzSettings.language;
        return configLanguage.equalsIgnoreCase("none") ? DEFAULT_LANGUAGE : configLanguage;
    }

    @NotNull
    public static Map<String, String> getTranslation(String lang) {
        return translations.getOrDefault(lang, Collections.emptyMap());
    }

    @Nullable
    public static String translateKeyToFormattedString(String lang, String key) {
        return FuzzTranslations.getTranslation(lang).get(key);
    }

    public static boolean isEnglish() {
        return FuzzSettings.language.startsWith("en") || FuzzSettings.language.equals("none");
    }
}

