/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import top.byteeeee.fuzz.FuzzModClient;
import top.byteeeee.fuzz.FuzzSettings;
import top.byteeeee.fuzz.settings.Rule;

@Environment(value=EnvType.CLIENT)
public class FuzzConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("fuzz");
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("settings.json");

    public static void load() {
        try {
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                FuzzConfig.saveConfig();
                return;
            }
            String json = new String(Files.readAllBytes(CONFIG_FILE), StandardCharsets.UTF_8);
            Map configMap = (Map)GSON.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
            FuzzConfig.loadFromMap(configMap);
        }
        catch (IOException e) {
            FuzzModClient.LOGGER.warn("Failed to load config: {}", (Object)e.getMessage());
        }
    }

    public static void saveConfig() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            String json = GSON.toJson(FuzzConfig.toMap());
            Files.write(CONFIG_FILE, json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            FuzzModClient.LOGGER.warn("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    private static void loadFromMap(Map<String, Object> map) {
        try {
            for (Field field : FuzzSettings.class.getDeclaredFields()) {
                Object value;
                if (!field.isAnnotationPresent(Rule.class) || (value = map.get(field.getName())) == null) continue;
                field.setAccessible(true);
                field.set(null, FuzzConfig.convertValue(field.getType(), value));
            }
        }
        catch (Exception e) {
            FuzzModClient.LOGGER.warn("Field access error: {}", (Object)e.getMessage());
        }
    }

    private static Object convertValue(Class<?> targetType, Object value) {
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return ((Number)value).intValue();
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return ((Number)value).doubleValue();
        }
        return value;
    }

    private static Map<String, Object> toMap() {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        try {
            for (Field field : FuzzSettings.class.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Rule.class)) continue;
                map.put(field.getName(), field.get(null));
            }
        }
        catch (Exception e) {
            FuzzModClient.LOGGER.warn("Field read error: {}", (Object)e.getMessage());
        }
        return map;
    }
}

