/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import top.byteeeee.fuzz.commands.fuzzCommands.FuzzCommandContext;
import top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler.ArgumentHandlerInterface;
import top.byteeeee.fuzz.config.FuzzConfig;
import top.byteeeee.fuzz.settings.Rule;
import top.byteeeee.fuzz.translations.LanguageJudge;
import top.byteeeee.fuzz.translations.Translator;
import top.byteeeee.fuzz.utils.Messenger;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractArgumentHandler<T>
implements ArgumentHandlerInterface<T> {
    protected static final Translator tr = new Translator("command");
    protected Field currentField;

    @Override
    public void configureArgument(LiteralArgumentBuilder<FabricClientCommandSource> literal, Field field) {
        this.currentField = field;
        RequiredArgumentBuilder valueArg = (RequiredArgumentBuilder)ClientCommandManager.argument((String)"value", this.getArgumentType()).suggests(this::getSuggestions).executes(ctx -> this.executeSetValue((CommandContext<FabricClientCommandSource>)ctx, field));
        ((LiteralArgumentBuilder)literal.executes(ctx -> FuzzCommandContext.showFunctionInfo((FabricClientCommandSource)ctx.getSource(), field))).then((ArgumentBuilder)valueArg);
    }

    protected void setFieldValue(Field field, T value) {
        try {
            field.set(null, value);
            FuzzConfig.saveConfig();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set field value", e);
        }
    }

    protected String[] getAnnotationOptions() {
        Rule annotation = this.currentField.getAnnotation(Rule.class);
        return annotation != null ? annotation.options() : new String[]{};
    }

    protected void buildCommonCommand(LiteralArgumentBuilder<FabricClientCommandSource> literal, Field field) {
        ((LiteralArgumentBuilder)literal.executes(ctx -> FuzzCommandContext.showFunctionInfo((FabricClientCommandSource)ctx.getSource(), field))).then(ClientCommandManager.argument((String)"value", this.getArgumentType()).suggests(this::getSuggestions).executes(ctx -> this.executeSetValue((CommandContext<FabricClientCommandSource>)ctx, field)));
    }

    private int executeSetValue(CommandContext<FabricClientCommandSource> ctx, Field field) throws CommandSyntaxException {
        Object value = this.parseValue(ctx);
        this.setFieldValue(field, value);
        String funcNameTrKey = tr.getFuncNameTrKey(field.getName());
        if (LanguageJudge.isEnglish()) {
            Messenger.tell((FabricClientCommandSource)ctx.getSource(), tr.tr("set_value", field.getName(), value));
        } else {
            Messenger.tell((FabricClientCommandSource)ctx.getSource(), tr.tr("set_value", Messenger.tr(funcNameTrKey, new Object[0]), field.getName(), value));
        }
        return 1;
    }

    protected abstract ArgumentType<T> getArgumentType();
}

