/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.commands.fuzzCommands.context;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import top.byteeeee.fuzz.FuzzModClient;
import top.byteeeee.fuzz.FuzzSettings;
import top.byteeeee.fuzz.commands.fuzzCommands.context.FuzzCommandContext;
import top.byteeeee.fuzz.settings.Rule;
import top.byteeeee.fuzz.translations.FuzzTranslations;
import top.byteeeee.fuzz.translations.Translator;
import top.byteeeee.fuzz.utils.MessageTextEventUtils.ClickEventUtil;
import top.byteeeee.fuzz.utils.MessageTextEventUtils.HoverEventUtil;
import top.byteeeee.fuzz.utils.Messenger;

@Environment(value=EnvType.CLIENT)
public class FuzzCategoriesContext {
    protected static final Translator tr = new Translator("categories");

    protected static class_5250 showCategories() {
        Set<String> categories = FuzzCategoriesContext.getAllCategories();
        return FuzzCategoriesContext.createCategoryButtons(categories);
    }

    public static Set<String> getAllCategories() {
        return Arrays.stream(FuzzSettings.class.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Rule.class)).map(field -> field.getAnnotation(Rule.class).categories()).flatMap(Arrays::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static int showFunctionListByCategory(FabricClientCommandSource source, String category) {
        ArrayList<class_5250> messages = new ArrayList<class_5250>();
        FuzzCategoriesContext.addCategoryTitle(messages, category);
        FuzzCategoriesContext.addCategoryFunctions(messages, category);
        messages.forEach(message -> Messenger.tell(source, message));
        return 1;
    }

    private static class_5250 createCategoryButtons(Set<String> categories) {
        class_5250 categoryButtons = Messenger.s("");
        categories.forEach(category -> {
            class_5250 buttonText = FuzzCategoriesContext.createCategoryButton(category);
            categoryButtons.method_10852((class_2561)buttonText).method_27693(" ");
        });
        return categoryButtons;
    }

    private static class_5250 createCategoryButton(String category) {
        return Messenger.s(String.format("[%s]", tr.tr(category, new Object[0]).getString())).method_27694(style -> style.method_10977(class_124.field_1075).method_10958(FuzzCategoriesContext.createClickEvent(category)).method_10949(FuzzCategoriesContext.createHoverEvent(category)));
    }

    private static class_2558 createClickEvent(String category) {
        return ClickEventUtil.event(ClickEventUtil.RUN_COMMAND, "/fuzz list " + category);
    }

    private static class_2568 createHoverEvent(String category) {
        return HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, FuzzCategoriesContext.createHoverText(category));
    }

    private static class_5250 createHoverText(String category) {
        if (FuzzTranslations.isEnglish()) {
            return tr.tr("click_to_view", tr.tr(category, new Object[0])).method_27692(class_124.field_1054);
        }
        return tr.tr("click_to_view", tr.tr(category, new Object[0]), category).method_27692(class_124.field_1054);
    }

    private static void addCategoryTitle(List<class_5250> messages, String category) {
        messages.add(tr.tr("list_title_for_category", tr.tr(category, new Object[0])).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
    }

    private static void addCategoryFunctions(List<class_5250> messages, String category) {
        FuzzCategoriesContext.getRuleFieldsForCategory(category).forEach(field -> FuzzCategoriesContext.addFunctionEntry(messages, field));
    }

    private static List<Field> getRuleFieldsForCategory(String category) {
        return Arrays.stream(FuzzSettings.class.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Rule.class)).filter(field -> Arrays.asList(field.getAnnotation(Rule.class).categories()).contains(category)).collect(Collectors.toList());
    }

    private static void addFunctionEntry(List<class_5250> messages, Field field) {
        try {
            field.setAccessible(true);
            Object value = field.get(null);
            messages.add(FuzzCommandContext.ruleEntryText(field, value));
        }
        catch (IllegalAccessException e) {
            FuzzModClient.LOGGER.error("Error accessing field {}: {}", (Object)field.getName(), (Object)e.getMessage());
        }
    }
}

