/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.settings;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import top.byteeeee.fuzz.FuzzModClient;
import top.byteeeee.fuzz.settings.Observer;
import top.byteeeee.fuzz.settings.Rule;

@Environment(value=EnvType.CLIENT)
public class ObserverManager {
    private static final ConcurrentHashMap<Field, List<Observer<?>>> fieldObservers = new ConcurrentHashMap();

    public static void init(Field field) {
        Rule annotation = field.getAnnotation(Rule.class);
        if (annotation == null) {
            return;
        }
        Class<? extends Observer<?>>[] observerClasses = annotation.observers();
        if (observerClasses.length > 0) {
            ArrayList observers = new ArrayList();
            for (Class<Observer<?>> clazz : observerClasses) {
                try {
                    Observer<?> observer = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    observers.add(observer);
                }
                catch (Exception e) {
                    FuzzModClient.LOGGER.error("Failed to instantiate observer: {}", (Object)clazz.getName(), (Object)e);
                }
            }
            if (!observers.isEmpty()) {
                fieldObservers.put(field, observers);
            }
        }
    }

    public static <T> void notifyObservers(Field field, T oldValue, T newValue) {
        List<Observer<?>> observers = fieldObservers.get(field);
        if (observers != null && !observers.isEmpty()) {
            Iterator<Observer<?>> iterator = observers.iterator();
            while (iterator.hasNext()) {
                Observer<?> observer;
                Observer<?> typedObserver = observer = iterator.next();
                typedObserver.notify(oldValue, newValue);
            }
        }
    }
}

