/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.commands.fuzzCommands;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import top.byteeeee.fuzz.FuzzModClient;
import top.byteeeee.fuzz.FuzzSettings;
import top.byteeeee.fuzz.commands.fuzzCommands.FuzzCategories;
import top.byteeeee.fuzz.settings.Rule;
import top.byteeeee.fuzz.translations.LanguageJudge;
import top.byteeeee.fuzz.translations.Translator;
import top.byteeeee.fuzz.utils.MessageTextEventUtils.ClickEventUtil;
import top.byteeeee.fuzz.utils.MessageTextEventUtils.HoverEventUtil;
import top.byteeeee.fuzz.utils.Messenger;

@Environment(value=EnvType.CLIENT)
public abstract class FuzzCommandContext {
    protected static final Translator tr = new Translator("command");

    public static int showFunctionList(FabricClientCommandSource source) {
        ArrayList<class_5250> messages = new ArrayList<class_5250>();
        messages.add(tr.tr("enable_function", new Object[0]).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        messages.add(tr.tr("mod_version", FuzzModClient.VERSION).method_27692(class_124.field_1080));
        boolean hasEnabledFunctions = false;
        for (Field field : FuzzSettings.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Rule.class)) continue;
            try {
                field.setAccessible(true);
                Object currentValue = field.get(null);
                Object defaultValue = FuzzSettings.DEFAULT_VALUES.get(field.getName());
                if (Objects.equals(currentValue, defaultValue)) continue;
                class_5250 mainText = FuzzCommandContext.functionEntryText(field, currentValue);
                messages.add(mainText);
                hasEnabledFunctions = true;
            }
            catch (IllegalAccessException e) {
                FuzzModClient.LOGGER.error("Unable to access field {}: {}", (Object)field.getName(), (Object)e.getMessage());
            }
        }
        if (!hasEnabledFunctions) {
            messages.add(Messenger.s("\u00b7 \u00b7 \u00b7 \u00b7 \u00b7 \u00b7").method_27692(class_124.field_1080));
        }
        messages.add(FuzzCategories.tr.tr("categories_list", new Object[0]).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        messages.add(FuzzCategories.showCategories());
        messages.add(tr.tr("use_help", new Object[0]).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
        messages.forEach(message -> Messenger.tell(source, message));
        return 1;
    }

    public static int showAllFunctions(FabricClientCommandSource source) {
        ArrayList<class_5250> messages = new ArrayList<class_5250>();
        messages.add(tr.tr("all_functions", new Object[0]).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        List allFields = Arrays.stream(FuzzSettings.class.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Rule.class)).sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
        boolean hasAnyFunction = false;
        for (Field field : allFields) {
            try {
                field.setAccessible(true);
                Object currentValue = field.get(null);
                messages.add(FuzzCommandContext.functionEntryText(field, currentValue));
                hasAnyFunction = true;
            }
            catch (IllegalAccessException e) {
                FuzzModClient.LOGGER.error("Field access error: {}", (Object)field.getName(), (Object)e);
            }
        }
        if (!hasAnyFunction) {
            messages.add(Messenger.s("\u00b7 \u00b7 \u00b7 \u00b7 \u00b7 \u00b7").method_27692(class_124.field_1080));
        }
        messages.add(tr.tr("use_help", new Object[0]).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
        messages.forEach(message -> Messenger.tell(source, message));
        return 1;
    }

    public static class_5250 functionEntryText(Field field, Object value) {
        class_5250 valueDisplay = FuzzCommandContext.optionText(field, value);
        String funcNameTrKey = tr.getFuncNameTrKey(field.getName());
        return Messenger.s("").method_10852((class_2561)Messenger.s("- ").method_27692(class_124.field_1068)).method_10852((class_2561)Messenger.tr(funcNameTrKey, new Object[0])).method_10852((class_2561)(LanguageJudge.isEnglish() ? Messenger.s(" ") : Messenger.s(" (" + field.getName() + ") "))).method_27694(style -> style.method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, Messenger.tr(tr.getFuncDescTrKey(field.getName()), new Object[0]).method_27692(class_124.field_1054))).method_10958(ClickEventUtil.event(ClickEventUtil.RUN_COMMAND, "/fuzz " + field.getName()))).method_10852((class_2561)valueDisplay);
    }

    public static int showFunctionInfo(FabricClientCommandSource source, Field field) {
        ArrayList<class_5250> messages = new ArrayList<class_5250>();
        try {
            String[] extraText;
            String extraKey;
            field.setAccessible(true);
            Object currentValue = field.get(null);
            Object defaultValue = FuzzSettings.DEFAULT_VALUES.get(field.getName());
            Rule annotation = field.getAnnotation(Rule.class);
            class_5250 nameLine = Messenger.s("").method_10852((class_2561)Messenger.tr(tr.getFuncNameTrKey(field.getName()), new Object[0])).method_27692(class_124.field_1067).method_10852((class_2561)(LanguageJudge.isEnglish() ? Messenger.s("") : Messenger.s(" (" + field.getName() + ")").method_27692(class_124.field_1067)));
            messages.add(nameLine);
            class_5250 descLine = Messenger.tr(tr.getFuncDescTrKey(field.getName()), new Object[0]);
            messages.add(descLine);
            int extraIndex = 0;
            while (!(extraKey = "fuzz.settings." + field.getName() + ".extra." + extraIndex).equals(extraText = Messenger.tr(extraKey, new Object[0]).getString())) {
                messages.add(Messenger.s(extraText).method_27692(class_124.field_1080));
                ++extraIndex;
            }
            class_5250 categoriesLine = tr.tr("function_info_categories", new Object[0]).method_27692(class_124.field_1068);
            for (String category : annotation.categories()) {
                class_5250 hoverText = LanguageJudge.isEnglish() ? tr.tr("function_info_click_to_view", FuzzCategories.tr.tr(category, new Object[0])).method_27692(class_124.field_1054) : tr.tr("function_info_click_to_view", FuzzCategories.tr.tr(category, new Object[0]), category).method_27692(class_124.field_1054);
                categoriesLine.method_10852((class_2561)Messenger.s("[" + FuzzCategories.tr.tr(category, new Object[0]).getString() + "]").method_27692(class_124.field_1075).method_27694(arg_0 -> FuzzCommandContext.lambda$showFunctionInfo$4(category, (class_2561)hoverText, arg_0))).method_27693(" ");
            }
            messages.add(categoriesLine);
            class_5250 currentValueLine = tr.tr("current_value", new Object[0]).method_10852((class_2561)Messenger.s(currentValue.toString()).method_10852((class_2561)(Objects.equals(currentValue, defaultValue) ? Messenger.s(" \u2714").method_27694(style -> style.method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, tr.tr("info_default_value", new Object[0]).method_27692(class_124.field_1077))).method_10977(class_124.field_1060)) : Messenger.s(" \u270e").method_27694(style -> style.method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, tr.tr("info_modified_value", new Object[0]).method_27692(class_124.field_1079))).method_10977(class_124.field_1065)))).method_27692(class_124.field_1075));
            messages.add(currentValueLine);
            if (annotation.options().length > 0 || field.getType() == Boolean.TYPE) {
                class_5250 optionsLine = tr.tr("options_option", new Object[0]).method_10852((class_2561)FuzzCommandContext.optionText(field, currentValue));
                messages.add(optionsLine);
            }
            messages.forEach(message -> Messenger.tell(source, message));
            return 1;
        }
        catch (IllegalAccessException e) {
            FuzzModClient.LOGGER.error("Unable to access field {}: {}", (Object)field.getName(), (Object)e.getMessage());
            return 0;
        }
    }

    public static class_5250 optionText(Field field, Object value) {
        Rule annotation = field.getAnnotation(Rule.class);
        String[] options = annotation.options();
        Object defaultValueObj = FuzzSettings.DEFAULT_VALUES.get(field.getName());
        String defaultValue = defaultValueObj != null ? defaultValueObj.toString() : "";
        String currentValue = value.toString();
        boolean isDefaultState = currentValue.equals(defaultValue);
        if (options.length == 0 && field.getType() == Boolean.TYPE) {
            options = new String[]{"false", "true"};
        } else if (options.length == 0) {
            options = new String[]{defaultValue};
        }
        class_5250 optionsText = Messenger.s("");
        boolean hasCustomValue = false;
        for (String option : options) {
            boolean underline;
            class_124 color;
            boolean isCurrent = option.equals(currentValue);
            boolean isDefaultOption = option.equals(defaultValue);
            if (isDefaultState) {
                color = class_124.field_1080;
                underline = isDefaultOption;
            } else {
                color = isDefaultOption ? class_124.field_1077 : class_124.field_1054;
                underline = isCurrent;
            }
            class_5250 button = Messenger.s("[" + option + "]").method_27692(color).method_27694(style -> style.method_30938(Boolean.valueOf(underline)).method_10958(ClickEventUtil.event(ClickEventUtil.RUN_COMMAND, "/fuzz " + field.getName() + " " + option)).method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, Messenger.s(isDefaultOption ? tr.tr("default_value", new Object[0]).getString() + option : tr.tr("set_to", new Object[0]).getString() + option).method_27692(class_124.field_1060))));
            optionsText.method_10852((class_2561)button).method_27693(" ");
            hasCustomValue = hasCustomValue || isCurrent;
        }
        if (!hasCustomValue && !isDefaultState) {
            class_5250 customButton = Messenger.s("[" + currentValue + "]").method_27692(class_124.field_1054).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(ClickEventUtil.event(ClickEventUtil.RUN_COMMAND, "/fuzz " + field.getName() + " " + currentValue)).method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, Messenger.s(tr.tr("custom_value", new Object[0]).getString() + currentValue).method_27692(class_124.field_1060))));
            optionsText.method_10852((class_2561)customButton).method_27693(" ");
        }
        return optionsText;
    }

    private static /* synthetic */ class_2583 lambda$showFunctionInfo$4(String category, class_2561 hoverText, class_2583 style) {
        return style.method_10958(ClickEventUtil.event(ClickEventUtil.RUN_COMMAND, "/fuzz list " + category)).method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, hoverText));
    }
}

