/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.commands.rule.commandCoordCompass;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9779;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import top.byteeeee.fuzz.FuzzSettings;
import top.byteeeee.fuzz.commands.AbstractRuleCommand;
import top.byteeeee.fuzz.translations.Translator;
import top.byteeeee.fuzz.utils.ClientUtil;
import top.byteeeee.fuzz.utils.EntityUtil;
import top.byteeeee.fuzz.utils.IdentifierUtil;
import top.byteeeee.fuzz.utils.Messenger;

@Environment(value=EnvType.CLIENT)
public class CoordCompassCommand
extends AbstractRuleCommand {
    private static final CoordCompassCommand INSTANCE = new CoordCompassCommand();
    private static final Translator tr = new Translator("command.coordCompass");
    private static final String MAIN_CMD_NAME = "coordCompass";
    private static final String RULE_NAME = "commandCoordCompass";
    private static class_243 targetCoord;
    private static boolean isActive;
    private static final class_2960 TARGET_ICON;

    public static CoordCompassCommand getInstance() {
        return INSTANCE;
    }

    @Override
    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)MAIN_CMD_NAME).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"x", (ArgumentType)DoubleArgumentType.doubleArg()).then(ClientCommandManager.argument((String)"y", (ArgumentType)DoubleArgumentType.doubleArg()).then(ClientCommandManager.argument((String)"z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(c -> this.checkEnabled((CommandContext<FabricClientCommandSource>)c, () -> CoordCompassCommand.set((CommandContext<FabricClientCommandSource>)c)))))))).then(ClientCommandManager.literal((String)"clear").executes(c -> this.checkEnabled((CommandContext<FabricClientCommandSource>)c, CoordCompassCommand::clear)))).then(ClientCommandManager.literal((String)"help").executes(c -> this.checkEnabled((CommandContext<FabricClientCommandSource>)c, () -> CoordCompassCommand.help((CommandContext<FabricClientCommandSource>)c)))));
    }

    @Override
    protected boolean getCondition() {
        return FuzzSettings.commandCoordCompass;
    }

    @Override
    protected String getRuleName() {
        return RULE_NAME;
    }

    private static int set(CommandContext<FabricClientCommandSource> context) {
        double x = DoubleArgumentType.getDouble(context, (String)"x");
        double y = DoubleArgumentType.getDouble(context, (String)"y");
        double z = DoubleArgumentType.getDouble(context, (String)"z");
        targetCoord = new class_243(x, y, z);
        isActive = true;
        return 1;
    }

    private static int clear() {
        targetCoord = null;
        isActive = false;
        return 1;
    }

    private static int help(CommandContext<FabricClientCommandSource> ctx) {
        Messenger.tell((FabricClientCommandSource)ctx.getSource(), tr.tr("help.set", new Object[0]).method_27692(class_124.field_1080));
        Messenger.tell((FabricClientCommandSource)ctx.getSource(), tr.tr("help.clear", new Object[0]).method_27692(class_124.field_1080));
        Messenger.tell((FabricClientCommandSource)ctx.getSource(), tr.tr("help.help", new Object[0]).method_27692(class_124.field_1080));
        return 1;
    }

    protected static void renderWorld(WorldRenderContext context) {
        boolean isFar;
        if (!isActive || targetCoord == null || !FuzzSettings.commandCoordCompass) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || context.camera() == null) {
            return;
        }
        class_4587 matrixStack = context.matrixStack();
        if (matrixStack == null) {
            return;
        }
        matrixStack.method_22903();
        class_243 cameraPos = context.camera().method_19326();
        class_243 offset = targetCoord.method_1020(cameraPos);
        int renderDistance = 30;
        class_243 renderOffset = offset;
        boolean bl = isFar = offset.method_1033() > (double)renderDistance * 0.9;
        if (isFar) {
            renderOffset = offset.method_1029().method_1021((double)renderDistance * 0.9);
        }
        class_243 renderPos = cameraPos.method_1019(renderOffset);
        matrixStack.method_46416((float)(renderPos.field_1352 - cameraPos.field_1352), (float)(renderPos.field_1351 - cameraPos.field_1351), (float)(renderPos.field_1350 - cameraPos.field_1350));
        float yaw = -context.camera().method_19330();
        float pitch = context.camera().method_19329();
        matrixStack.method_22907((Quaternionfc)new Quaternionf().rotationYXZ((float)Math.toRadians(yaw), (float)Math.toRadians(pitch), 0.0f));
        float scale = 1.0f;
        matrixStack.method_22905(scale, scale, scale);
        class_4587.class_4665 entry = matrixStack.method_23760();
        class_1921 renderLayer = class_1921.method_62275((class_2960)TARGET_ICON);
        class_4588 vertexConsumer = Objects.requireNonNull(context.consumers()).getBuffer(renderLayer);
        vertexConsumer.method_22918(entry.method_23761(), -1.0f, -1.0f, 0.0f).method_22913(0.0f, 0.0f).method_39415(-1);
        vertexConsumer.method_22918(entry.method_23761(), -1.0f, 1.0f, 0.0f).method_22913(0.0f, 1.0f).method_39415(-1);
        vertexConsumer.method_22918(entry.method_23761(), 1.0f, 1.0f, 0.0f).method_22913(1.0f, 1.0f).method_39415(-1);
        vertexConsumer.method_22918(entry.method_23761(), 1.0f, -1.0f, 0.0f).method_22913(1.0f, 0.0f).method_39415(-1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.method_22909();
    }

    protected static void renderHud(class_332 drawContext, class_9779 renderTickCounter) {
        String distanceText;
        if (!isActive || targetCoord == null) {
            return;
        }
        class_310 client = ClientUtil.getCurrentClient();
        if (client.field_1724 == null) {
            return;
        }
        class_243 playerPos = EntityUtil.getEntityPos((class_1297)ClientUtil.getCurrentPlayer());
        class_243 direction = targetCoord.method_1020(playerPos);
        double distance = playerPos.method_1022(targetCoord);
        double horizontalDistance = Math.sqrt(direction.field_1352 * direction.field_1352 + direction.field_1350 * direction.field_1350);
        boolean isHorizontalClose = horizontalDistance <= 2.0;
        boolean isVerticalClose = Math.abs(direction.field_1351) <= 2.0;
        boolean isClose = isHorizontalClose && isVerticalClose;
        class_243 horizontalDirection = new class_243(direction.field_1352, 0.0, direction.field_1350).method_1029();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int centerX = screenWidth / 2;
        int centerY = CoordCompassCommand.getArrowHudYPosition(screenHeight);
        if (isClose) {
            CoordCompassCommand.renderCircle(drawContext, centerX, centerY);
            CoordCompassCommand.renderXMark(drawContext, centerX, centerY);
        } else if (isHorizontalClose) {
            CoordCompassCommand.renderCircle(drawContext, centerX, centerY);
        } else {
            float playerYaw = client.field_1724.method_5705(renderTickCounter.method_60637(true));
            double targetYaw = Math.atan2(horizontalDirection.field_1350, horizontalDirection.field_1352) * 180.0 / Math.PI - 90.0;
            double angleDiff = (targetYaw - (double)playerYaw + 540.0) % 360.0 - 180.0;
            double angleRad = Math.toRadians(angleDiff);
            int arrowLength = 20;
            int arrowX = centerX + (int)(Math.sin(angleRad) * (double)arrowLength);
            int arrowY = centerY - (int)(Math.cos(angleRad) * (double)arrowLength);
            CoordCompassCommand.renderArrow(drawContext, centerX, centerY, arrowX, arrowY);
        }
        String verticalIndicator = "";
        if (isClose) {
            distanceText = tr.tr("near_the_target", new Object[0]).getString();
        } else {
            if (!isVerticalClose) {
                verticalIndicator = direction.field_1351 > 0.0 ? "\u2191" : "\u2193";
            }
            distanceText = String.format("\u00a7e%s %.1fm %s", verticalIndicator, distance, verticalIndicator);
        }
        drawContext.method_25303(client.field_1772, distanceText, centerX - client.field_1772.method_1727(distanceText) / 2, centerY + 20, -256);
        String targetX = CoordCompassCommand.formatCoord(CoordCompassCommand.targetCoord.field_1352);
        String targetY = CoordCompassCommand.formatCoord(CoordCompassCommand.targetCoord.field_1351);
        String targetZ = CoordCompassCommand.formatCoord(CoordCompassCommand.targetCoord.field_1350);
        String playerX = CoordCompassCommand.formatCoord(playerPos.field_1352);
        String playerY = CoordCompassCommand.formatCoord(playerPos.field_1351);
        String playerZ = CoordCompassCommand.formatCoord(playerPos.field_1350);
        String coordText = String.format("\u00a7b[ %s, %s, %s ]\u00a7f \u00a7r\u00a7a[ %s, %s, %s ]", targetX, targetY, targetZ, playerX, playerY, playerZ);
        drawContext.method_25303(client.field_1772, coordText, centerX - client.field_1772.method_1727(coordText) / 2, centerY + 30, -16711681);
    }

    private static int getArrowHudYPosition(int screenHeight) {
        int centerY = ClientUtil.getCurrentPlayer().method_68878() || ClientUtil.getCurrentPlayer().method_7325() ? screenHeight - 62 : (ClientUtil.getCurrentPlayer().method_6096() <= 0 ? screenHeight - 79 : screenHeight - 90);
        return centerY;
    }

    private static void renderXMark(class_332 drawContext, int centerX, int centerY) {
        int size = 8;
        CoordCompassCommand.drawLine(drawContext, centerX - size, centerY - size, centerX + size, centerY + size);
        CoordCompassCommand.drawLine(drawContext, centerX - size, centerY + size, centerX + size, centerY - size);
    }

    private static void renderCircle(class_332 drawContext, int centerX, int centerY) {
        int radius = 13;
        int segments = 66;
        for (int i = 0; i < segments; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)segments;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)segments;
            int x1 = centerX + (int)((double)radius * Math.cos(angle1));
            int y1 = centerY + (int)((double)radius * Math.sin(angle1));
            int x2 = centerX + (int)((double)radius * Math.cos(angle2));
            int y2 = centerY + (int)((double)radius * Math.sin(angle2));
            CoordCompassCommand.drawLine(drawContext, x1, y1, x2, y2);
        }
    }

    private static String formatCoord(double value) {
        if (value == (double)((int)value)) {
            return String.format("%d", (int)value);
        }
        String formatted = String.format("%.2f", value);
        if (formatted.endsWith(".00")) {
            return formatted.substring(0, formatted.length() - 3);
        }
        if (formatted.endsWith("0")) {
            return formatted.substring(0, formatted.length() - 1);
        }
        return formatted;
    }

    private static void renderArrow(class_332 drawContext, int startX, int startY, int endX, int endY) {
        CoordCompassCommand.drawLine(drawContext, startX, startY, endX, endY);
        double angle = Math.atan2(endY - startY, endX - startX);
        int arrowSize = 5;
        int arrow1X = endX - (int)((double)arrowSize * Math.cos(angle - 0.5235987755982988));
        int arrow1Y = endY - (int)((double)arrowSize * Math.sin(angle - 0.5235987755982988));
        int arrow2X = endX - (int)((double)arrowSize * Math.cos(angle + 0.5235987755982988));
        int arrow2Y = endY - (int)((double)arrowSize * Math.sin(angle + 0.5235987755982988));
        CoordCompassCommand.drawLine(drawContext, endX, endY, arrow1X, arrow1Y);
        CoordCompassCommand.drawLine(drawContext, endX, endY, arrow2X, arrow2Y);
    }

    private static void drawLine(class_332 drawContext, int x1, int y1, int x2, int y2) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int x = x1;
        int y = y1;
        while (true) {
            drawContext.method_25294(x, y, x + 1, y + 1, -16711936);
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    static {
        isActive = false;
        TARGET_ICON = IdentifierUtil.of("fuzz", "textures/waypoint/target_point.png");
    }
}

