/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.helpers.rule.parseCoordInMessage;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import top.byteeeee.fuzz.FuzzSettings;
import top.byteeeee.fuzz.helpers.rule.parseCoordInMessage.MatchInfo;
import top.byteeeee.fuzz.translations.Translator;
import top.byteeeee.fuzz.utils.MessageTextEventUtils.ClickEventUtil;
import top.byteeeee.fuzz.utils.MessageTextEventUtils.HoverEventUtil;
import top.byteeeee.fuzz.utils.Messenger;

@Environment(value=EnvType.CLIENT)
public class TextProcessor {
    private static final Pattern COORD_PATTERN = Pattern.compile("(?<=^|\\s|[\\[({])\\s*(-?\\d+(?:\\.\\d+)?)\\s*[,\\s~]+\\s*(-?\\d+(?:\\.\\d+)?)\\s*[,\\s~]+\\s*(-?\\d+(?:\\.\\d+)?)\\s*(?=$|\\s|[])}])");
    private static final Translator tr = new Translator("rule_feedback.parseCoordInMessage");

    public static class_2561 processTextForCoordinates(class_2561 original) {
        ArrayList<class_2561> nodes = new ArrayList<class_2561>();
        ArrayList<String> parts = new ArrayList<String>();
        TextProcessor.collectSegments(original, nodes, parts);
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            sb.append(p);
        }
        String whole = sb.toString();
        Matcher m = COORD_PATTERN.matcher(whole);
        if (!m.find()) {
            return original;
        }
        m.reset();
        ArrayList<MatchInfo> matches = new ArrayList<MatchInfo>();
        while (m.find()) {
            matches.add(new MatchInfo(m.start(), m.end(), m.group(1), m.group(2), m.group(3)));
        }
        class_5250 out = Messenger.s("").method_10862(original.method_10866());
        int cursor = 0;
        int matchIdx = 0;
        for (int i = 0; i < parts.size(); ++i) {
            String segStr = (String)parts.get(i);
            class_2561 segNode = (class_2561)nodes.get(i);
            int segStart = cursor;
            int segEnd = cursor + segStr.length();
            while (matchIdx < matches.size() && ((MatchInfo)matches.get((int)matchIdx)).end <= segStart) {
                ++matchIdx;
            }
            int localPos = 0;
            while (matchIdx < matches.size() && ((MatchInfo)matches.get((int)matchIdx)).start < segEnd) {
                MatchInfo mi = (MatchInfo)matches.get(matchIdx);
                int mStart = mi.start;
                int mEnd = mi.end;
                if (mStart > segStart + localPos) {
                    int len = mStart - (segStart + localPos);
                    out.method_10852((class_2561)Messenger.s(segStr.substring(localPos, localPos + len)).method_10862(segNode.method_10866()));
                }
                int ovStart = Math.max(segStart, mStart);
                int ovEnd = Math.min(segEnd, mEnd);
                int ovLocalStart = ovStart - segStart;
                int ovLocalEnd = ovEnd - segStart;
                String matchedPiece = segStr.substring(ovLocalStart, ovLocalEnd);
                String fuzzCommand = "/coordCompass set " + mi.x + " " + mi.y + " " + mi.z;
                String orgCommand = "/highlight " + mi.x + " " + mi.y + " " + mi.z + " continue";
                String runCommand = Objects.equals(FuzzSettings.parseCoordInMessage, "fuzz") ? fuzzCommand : orgCommand;
                class_5250 clickable = Messenger.s(matchedPiece);
                clickable.method_10862(segNode.method_10866().method_10977(class_124.field_1060).method_30938(Boolean.valueOf(true)).method_10958(ClickEventUtil.event(ClickEventUtil.RUN_COMMAND, runCommand)).method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, tr.tr("hover_text", mi.x + " " + mi.y + " " + mi.z).method_27692(class_124.field_1054))));
                out.method_10852((class_2561)clickable);
                localPos = ovLocalEnd;
                if (mEnd > segEnd) break;
                ++matchIdx;
            }
            if (localPos < segStr.length()) {
                out.method_10852((class_2561)Messenger.s(segStr.substring(localPos)).method_10862(segNode.method_10866()));
            }
            cursor = segEnd;
        }
        return out;
    }

    private static void collectSegments(class_2561 node, List<class_2561> nodes, List<String> parts) {
        String full = node.getString();
        int childrenLen = 0;
        for (class_2561 child : node.method_10855()) {
            childrenLen += child.getString().length();
        }
        int ownLen = full.length() - childrenLen;
        if (ownLen > 0) {
            String ownStr = full.substring(0, ownLen);
            nodes.add(node);
            parts.add(ownStr);
        }
        for (class_2561 child : node.method_10855()) {
            TextProcessor.collectSegments(child, nodes, parts);
        }
    }
}

