/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler.ArgumentHandlerInterface;
import top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler.BooleanHandler;
import top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler.DoubleHandler;
import top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler.IntegerHandler;
import top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler.StringHandler;

@Environment(value=EnvType.CLIENT)
public class ArgumentHandlerFactory {
    private static final Map<Class<?>, Supplier<ArgumentHandlerInterface<?>>> HANDLERS = new ConcurrentHashMap();

    public static ArgumentHandlerInterface<?> create(Class<?> type) {
        Supplier<ArgumentHandlerInterface<?>> supplier = HANDLERS.get(type);
        if (supplier == null) {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        return supplier.get();
    }

    static {
        HANDLERS.put(Boolean.TYPE, BooleanHandler::new);
        HANDLERS.put(Integer.TYPE, IntegerHandler::new);
        HANDLERS.put(Double.TYPE, DoubleHandler::new);
        HANDLERS.put(String.class, StringHandler::new);
    }
}

