/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.commands.fuzzCommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import top.byteeeee.fuzz.FuzzSettings;
import top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler.ArgumentHandlerFactory;
import top.byteeeee.fuzz.commands.fuzzCommands.argumentHandler.ArgumentHandlerInterface;
import top.byteeeee.fuzz.commands.fuzzCommands.context.FuzzCategoriesContext;
import top.byteeeee.fuzz.commands.fuzzCommands.context.FuzzCommandContext;
import top.byteeeee.fuzz.settings.Rule;

@Environment(value=EnvType.CLIENT)
public class FuzzCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register(FuzzCommand.buildFuzzCommand("fuzz"));
        if (!Objects.equals(FuzzSettings.fuzzCommandAlias, "false")) {
            dispatcher.register(FuzzCommand.buildFuzzCommand(FuzzSettings.fuzzCommandAlias));
        }
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> buildFuzzCommand(String commandName) {
        LiteralArgumentBuilder main = (LiteralArgumentBuilder)ClientCommandManager.literal((String)commandName).executes(ctx -> FuzzCommandContext.showRuleList((FabricClientCommandSource)ctx.getSource()));
        LiteralArgumentBuilder listCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").executes(ctx -> FuzzCommandContext.showAllRules((FabricClientCommandSource)ctx.getSource()))).then(ClientCommandManager.argument((String)"category", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            FuzzCategoriesContext.getAllCategories().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return CompletableFuture.completedFuture(builder.build());
        }).executes(ctx -> {
            String category = StringArgumentType.getString((CommandContext)ctx, (String)"category");
            return FuzzCategoriesContext.showFunctionListByCategory((FabricClientCommandSource)ctx.getSource(), category);
        }));
        main.then((ArgumentBuilder)listCommand);
        Arrays.stream(FuzzSettings.class.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Rule.class)).forEach(field -> {
            LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)ClientCommandManager.literal((String)field.getName()).executes(context -> {
                FuzzCommandContext.showRuleList((FabricClientCommandSource)context.getSource());
                FuzzCommandContext.showRuleInfo((FabricClientCommandSource)context.getSource(), field);
                return 1;
            });
            ArgumentHandlerInterface<?> handler = ArgumentHandlerFactory.create(field.getType());
            handler.configureArgument((LiteralArgumentBuilder<FabricClientCommandSource>)cmd, (Field)field);
            main.then((ArgumentBuilder)cmd);
        });
        return main;
    }
}

