/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.commands.fuzzCommands.context;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import top.byteeeee.fuzz.FuzzMod;
import top.byteeeee.fuzz.FuzzModClient;
import top.byteeeee.fuzz.FuzzSettings;
import top.byteeeee.fuzz.commands.fuzzCommands.context.FuzzCategoriesContext;
import top.byteeeee.fuzz.settings.Rule;
import top.byteeeee.fuzz.translations.FuzzTranslations;
import top.byteeeee.fuzz.translations.Translator;
import top.byteeeee.fuzz.utils.MessageTextEventUtils.ClickEventUtil;
import top.byteeeee.fuzz.utils.MessageTextEventUtils.HoverEventUtil;
import top.byteeeee.fuzz.utils.Messenger;

@Environment(value=EnvType.CLIENT)
public abstract class FuzzCommandContext {
    protected static final Translator tr = new Translator("command");

    public static int showRuleList(FabricClientCommandSource source) {
        List<class_5250> messages = FuzzCommandContext.initializeMessageList();
        boolean hasEnabledRules = FuzzCommandContext.collectEnabledRules(messages);
        if (!hasEnabledRules) {
            messages.add(Messenger.s("\u00b7 \u00b7 \u00b7 \u00b7 \u00b7 \u00b7").method_27692(class_124.field_1080));
        }
        FuzzCommandContext.addCategoriesInfo(messages);
        messages.forEach(message -> Messenger.tell(source, message));
        return 1;
    }

    private static List<class_5250> initializeMessageList() {
        ArrayList<class_5250> messages = new ArrayList<class_5250>();
        messages.add(tr.tr("enable_rule", new Object[0]).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        messages.add(tr.tr("mod_version", FuzzMod.getInstance().getVersion()).method_27692(class_124.field_1080));
        return messages;
    }

    private static boolean collectEnabledRules(List<class_5250> messages) {
        boolean hasEnabledRules = false;
        for (Field field : FuzzCommandContext.getRuleAnnotatedFields()) {
            try {
                Object defaultValue;
                field.setAccessible(true);
                Object currentValue = field.get(null);
                if (Objects.equals(currentValue, defaultValue = FuzzSettings.DEFAULT_VALUES.get(field.getName()))) continue;
                messages.add(FuzzCommandContext.ruleEntryText(field, currentValue));
                hasEnabledRules = true;
            }
            catch (IllegalAccessException e) {
                FuzzModClient.LOGGER.error("Field access error: {}", (Object)field.getName(), (Object)e);
            }
        }
        return hasEnabledRules;
    }

    private static void addCategoriesInfo(List<class_5250> messages) {
        messages.add(FuzzCategoriesContext.tr.tr("categories_list", new Object[0]).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        messages.add(FuzzCategoriesContext.showCategories());
        messages.add(tr.tr("use_help", new Object[0]).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
    }

    public static int showAllRules(FabricClientCommandSource source) {
        ArrayList<class_5250> messages = new ArrayList<class_5250>();
        messages.add(tr.tr("all_rules", new Object[0]).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        List<Field> sortedFields = FuzzCommandContext.getSortedRuleAnnotatedFields();
        boolean hasAnyRule = FuzzCommandContext.addRuleEntries(messages, sortedFields);
        if (!hasAnyRule) {
            messages.add(Messenger.s("\u00b7 \u00b7 \u00b7 \u00b7 \u00b7 \u00b7").method_27692(class_124.field_1080));
        }
        messages.add(tr.tr("use_help", new Object[0]).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
        messages.forEach(message -> Messenger.tell(source, message));
        return 1;
    }

    public static class_5250 ruleEntryText(Field field, Object value) {
        class_5250 valueDisplay = FuzzCommandContext.optionText(field, value);
        String funcNameTrKey = tr.getRuleNameTrKey(field.getName());
        return Messenger.s("").method_10852((class_2561)Messenger.s("- ").method_27692(class_124.field_1068)).method_10852((class_2561)Messenger.tr(funcNameTrKey, new Object[0])).method_10852((class_2561)FuzzCommandContext.createFieldNameText(field)).method_27694(style -> style.method_10949(FuzzCommandContext.createHoverEvent(field)).method_10958(FuzzCommandContext.createClickEvent(field))).method_10852((class_2561)valueDisplay);
    }

    private static class_5250 createFieldNameText(Field field) {
        return FuzzTranslations.isEnglish() ? Messenger.s(" ") : Messenger.s(" (" + field.getName() + ") ");
    }

    private static class_2568 createHoverEvent(Field field) {
        return HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, Messenger.tr(tr.getRuleDescTrKey(field.getName()), new Object[0]).method_27692(class_124.field_1054));
    }

    private static class_2558 createClickEvent(Field field) {
        return ClickEventUtil.event(ClickEventUtil.RUN_COMMAND, "/fuzz " + field.getName());
    }

    public static int showRuleInfo(FabricClientCommandSource source, Field field) {
        try {
            List<class_5250> messages = FuzzCommandContext.buildRuleInfoMessages(field);
            messages.forEach(message -> Messenger.tell(source, message));
            return 1;
        }
        catch (IllegalAccessException e) {
            FuzzModClient.LOGGER.error("Field access error: {}", (Object)field.getName(), (Object)e);
            return 0;
        }
    }

    private static List<class_5250> buildRuleInfoMessages(Field field) throws IllegalAccessException {
        ArrayList<class_5250> messages = new ArrayList<class_5250>();
        Object currentValue = FuzzCommandContext.getFieldValue(field);
        Object defaultValue = FuzzSettings.DEFAULT_VALUES.get(field.getName());
        Rule annotation = field.getAnnotation(Rule.class);
        FuzzCommandContext.addRuleHeader(messages, field);
        FuzzCommandContext.addRuleDescription(messages, field);
        FuzzCommandContext.addExtraInformation(messages, field);
        FuzzCommandContext.addCategoriesLine(messages, annotation);
        FuzzCommandContext.addValueInformation(messages, field, currentValue, defaultValue);
        return messages;
    }

    public static class_5250 optionText(Field field, Object value) {
        Rule annotation = field.getAnnotation(Rule.class);
        String[] options = FuzzCommandContext.getOptions(field, annotation);
        String currentValue = value.toString();
        String defaultValue = FuzzCommandContext.getDefaultValue(field);
        boolean isDefaultState = currentValue.equals(defaultValue);
        class_5250 optionsText = Messenger.s("");
        boolean hasCustomValue = false;
        for (String option : options) {
            boolean isDefaultOption;
            boolean isCurrent = option.equals(currentValue);
            hasCustomValue = FuzzCommandContext.addOptionButton(optionsText, field, option, isCurrent, isDefaultOption = option.equals(defaultValue), isDefaultState) || hasCustomValue;
        }
        if (!hasCustomValue && !isDefaultState) {
            FuzzCommandContext.appendCustomValueButton(optionsText, field, currentValue);
        }
        return optionsText;
    }

    private static List<Field> getRuleAnnotatedFields() {
        return Arrays.stream(FuzzSettings.class.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Rule.class)).collect(Collectors.toList());
    }

    private static List<Field> getSortedRuleAnnotatedFields() {
        return FuzzCommandContext.getRuleAnnotatedFields().stream().sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
    }

    private static boolean addRuleEntries(List<class_5250> messages, List<Field> fields) {
        boolean hasAnyRule = false;
        for (Field field : fields) {
            try {
                Object currentValue = FuzzCommandContext.getFieldValue(field);
                messages.add(FuzzCommandContext.ruleEntryText(field, currentValue));
                hasAnyRule = true;
            }
            catch (IllegalAccessException e) {
                FuzzModClient.LOGGER.error("Field access error: {}", (Object)field.getName(), (Object)e);
            }
        }
        return hasAnyRule;
    }

    private static Object getFieldValue(Field field) throws IllegalAccessException {
        field.setAccessible(true);
        return field.get(null);
    }

    private static void addRuleHeader(List<class_5250> messages, Field field) {
        class_5250 nameLine = Messenger.s("").method_10852((class_2561)Messenger.tr(tr.getRuleNameTrKey(field.getName()), new Object[0])).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}).method_10852((class_2561)FuzzCommandContext.createFieldNameText(field).method_27692(class_124.field_1067));
        messages.add(nameLine);
    }

    private static void addRuleDescription(List<class_5250> messages, Field field) {
        messages.add(Messenger.tr(tr.getRuleDescTrKey(field.getName()), new Object[0]));
    }

    private static void addExtraInformation(List<class_5250> messages, Field field) {
        String extraText;
        String extraKey;
        int i = 0;
        while (!(extraKey = "fuzz.rule." + field.getName() + ".extra." + i).equals(extraText = Messenger.tr(extraKey, new Object[0]).getString())) {
            messages.add(Messenger.s(extraText).method_27692(class_124.field_1080));
            ++i;
        }
    }

    private static void addCategoriesLine(List<class_5250> messages, Rule annotation) {
        class_5250 categoriesLine = tr.tr("rule_info_categories", new Object[0]).method_27692(class_124.field_1068);
        for (String category : annotation.categories()) {
            categoriesLine.method_10852((class_2561)FuzzCommandContext.createCategoryButton(category)).method_27693(" ");
        }
        messages.add(categoriesLine);
    }

    private static class_5250 createCategoryButton(String category) {
        class_2561 hoverText = FuzzCommandContext.createCategoryHoverText(category);
        return Messenger.s("[" + FuzzCategoriesContext.tr.tr(category, new Object[0]).getString() + "]").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(ClickEventUtil.event(ClickEventUtil.RUN_COMMAND, "/fuzz list " + category)).method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, hoverText)));
    }

    private static class_2561 createCategoryHoverText(String category) {
        return FuzzTranslations.isEnglish() ? tr.tr("rule_info_click_to_view", FuzzCategoriesContext.tr.tr(category, new Object[0])).method_27692(class_124.field_1054) : tr.tr("rule_info_click_to_view", FuzzCategoriesContext.tr.tr(category, new Object[0]), category).method_27692(class_124.field_1054);
    }

    private static void addValueInformation(List<class_5250> messages, Field field, Object currentValue, Object defaultValue) {
        messages.add(FuzzCommandContext.createCurrentValueLine(currentValue, defaultValue));
        Rule annotation = field.getAnnotation(Rule.class);
        if (annotation.options().length > 0 || field.getType() == Boolean.TYPE) {
            messages.add(tr.tr("options_option", new Object[0]).method_10852((class_2561)FuzzCommandContext.optionText(field, currentValue)));
        }
    }

    private static class_5250 createCurrentValueLine(Object currentValue, Object defaultValue) {
        return tr.tr("current_value", new Object[0]).method_10852((class_2561)Messenger.s(currentValue.toString()).method_10852((class_2561)FuzzCommandContext.createValueStateIcon(currentValue, defaultValue)).method_27692(class_124.field_1075));
    }

    private static class_5250 createValueStateIcon(Object currentValue, Object defaultValue) {
        boolean isDefault = Objects.equals(currentValue, defaultValue);
        return isDefault ? FuzzCommandContext.createDefaultValueIcon() : FuzzCommandContext.createModifiedValueIcon();
    }

    private static class_5250 createDefaultValueIcon() {
        return Messenger.s(" \u2714").method_27694(style -> style.method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, tr.tr("info_default_value", new Object[0]).method_27692(class_124.field_1077))).method_10977(class_124.field_1060));
    }

    private static class_5250 createModifiedValueIcon() {
        return Messenger.s(" \u270e").method_27694(style -> style.method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, tr.tr("info_modified_value", new Object[0]).method_27692(class_124.field_1079))).method_10977(class_124.field_1065));
    }

    private static String[] getOptions(Field field, Rule annotation) {
        String[] options = annotation.options();
        if (options.length == 0 && field.getType() == Boolean.TYPE) {
            return new String[]{"false", "true"};
        }
        if (options.length == 0) {
            String defaultValue = FuzzCommandContext.getDefaultValue(field);
            return new String[]{defaultValue};
        }
        return options;
    }

    private static String getDefaultValue(Field field) {
        Object defaultValueObj = FuzzSettings.DEFAULT_VALUES.get(field.getName());
        return defaultValueObj != null ? defaultValueObj.toString() : "";
    }

    private static boolean addOptionButton(class_5250 optionsText, Field field, String option, boolean isCurrent, boolean isDefaultOption, boolean isDefaultState) {
        class_124 color = FuzzCommandContext.determineOptionColor(isDefaultState, isDefaultOption);
        boolean underline = isDefaultState ? isDefaultOption : isCurrent;
        class_5250 button = FuzzCommandContext.createOptionButton(field, option, isDefaultOption, color, underline);
        optionsText.method_10852((class_2561)button).method_27693(" ");
        return isCurrent;
    }

    private static class_124 determineOptionColor(boolean isDefaultState, boolean isDefaultOption) {
        if (isDefaultState) {
            return class_124.field_1080;
        }
        return isDefaultOption ? class_124.field_1077 : class_124.field_1054;
    }

    private static class_5250 createOptionButton(Field field, String option, boolean isDefaultOption, class_124 color, boolean underline) {
        return Messenger.s("[" + option + "]").method_27692(color).method_27694(style -> style.method_30938(Boolean.valueOf(underline)).method_10958(FuzzCommandContext.createOptionClickEvent(field, option)).method_10949(FuzzCommandContext.createOptionHoverEvent(option, isDefaultOption)));
    }

    private static class_2558 createOptionClickEvent(Field field, String option) {
        return ClickEventUtil.event(ClickEventUtil.RUN_COMMAND, "/fuzz " + field.getName() + " " + option);
    }

    private static class_2568 createOptionHoverEvent(String option, boolean isDefaultOption) {
        String message = isDefaultOption ? tr.tr("default_value", new Object[0]).getString() + option : tr.tr("set_to", new Object[0]).getString() + option;
        return HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, Messenger.s(message).method_27692(class_124.field_1060));
    }

    private static void appendCustomValueButton(class_5250 optionsText, Field field, String currentValue) {
        class_5250 customButton = FuzzCommandContext.createCustomValueButton(field, currentValue);
        optionsText.method_10852((class_2561)customButton).method_27693(" ");
    }

    private static class_5250 createCustomValueButton(Field field, String currentValue) {
        return Messenger.s("[" + currentValue + "]").method_27692(class_124.field_1054).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(FuzzCommandContext.createOptionClickEvent(field, currentValue)).method_10949(FuzzCommandContext.createCustomValueHoverEvent(currentValue)));
    }

    private static class_2568 createCustomValueHoverEvent(String currentValue) {
        return HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, Messenger.s(tr.tr("custom_value", new Object[0]).getString() + currentValue).method_27692(class_124.field_1060));
    }
}

