/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.commands.rule.commandHighLightEntity;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import top.byteeeee.fuzz.FuzzSettings;
import top.byteeeee.fuzz.commands.AbstractRuleCommand;
import top.byteeeee.fuzz.commands.suggestionProviders.ListSuggestionProvider;
import top.byteeeee.fuzz.commands.suggestionProviders.SetSuggestionProvider;
import top.byteeeee.fuzz.config.rule.commandHighlightEntities.CommandHighlightEntitiesConfig;
import top.byteeeee.fuzz.translations.Translator;
import top.byteeeee.fuzz.utils.Messenger;

@Environment(value=EnvType.CLIENT)
public class HighLightEntityCommand
extends AbstractRuleCommand {
    private static final Translator tr = new Translator("command.highlightEntity");
    private static final HighLightEntityCommand INSTANCE = new HighLightEntityCommand();
    private static final String MAIN_CMD_NAME = "highlightEntity";
    private static final String RULE_NAME = "commandHighlightEntities";

    public static HighLightEntityCommand getInstance() {
        return INSTANCE;
    }

    @Override
    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)MAIN_CMD_NAME).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"entityId", (ArgumentType)StringArgumentType.greedyString()).suggests(SetSuggestionProvider.fromEntityRegistry()).executes(c -> this.checkEnabled((CommandContext<FabricClientCommandSource>)c, () -> HighLightEntityCommand.add((FabricClientCommandSource)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"entityId"))))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"entityId", (ArgumentType)StringArgumentType.greedyString()).suggests(ListSuggestionProvider.of(FuzzSettings.highlightEntityList)).executes(c -> this.checkEnabled((CommandContext<FabricClientCommandSource>)c, () -> HighLightEntityCommand.remove((FabricClientCommandSource)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"entityId"))))))).then(ClientCommandManager.literal((String)"clear").executes(c -> this.checkEnabled((CommandContext<FabricClientCommandSource>)c, () -> HighLightEntityCommand.clear((FabricClientCommandSource)c.getSource()))))).then(ClientCommandManager.literal((String)"list").executes(c -> this.checkEnabled((CommandContext<FabricClientCommandSource>)c, () -> HighLightEntityCommand.list((FabricClientCommandSource)c.getSource()))))).then(ClientCommandManager.literal((String)"help").executes(c -> this.checkEnabled((CommandContext<FabricClientCommandSource>)c, () -> HighLightEntityCommand.help((FabricClientCommandSource)c.getSource())))));
    }

    @Override
    protected boolean getCondition() {
        return FuzzSettings.commandHighlightEntities;
    }

    @Override
    protected String getRuleName() {
        return RULE_NAME;
    }

    private static int add(FabricClientCommandSource source, String entity) {
        if (FuzzSettings.highlightEntityList.contains(entity)) {
            Messenger.tell(source, tr.tr("already_in_list", entity).method_27692(class_124.field_1061));
            return 0;
        }
        FuzzSettings.highlightEntityList.add(entity);
        HighLightEntityCommand.saveToJson();
        Messenger.tell(source, tr.tr("added", entity).method_27692(class_124.field_1060));
        return 1;
    }

    private static int remove(FabricClientCommandSource source, String entity) {
        if (!FuzzSettings.highlightEntityList.remove(entity)) {
            Messenger.tell(source, tr.tr("not_in_list", entity).method_27692(class_124.field_1061));
            return 0;
        }
        HighLightEntityCommand.saveToJson();
        Messenger.tell(source, tr.tr("removed", entity).method_27692(class_124.field_1075));
        return 1;
    }

    private static int clear(FabricClientCommandSource source) {
        FuzzSettings.highlightEntityList.clear();
        HighLightEntityCommand.saveToJson();
        Messenger.tell(source, tr.tr("cleared", new Object[0]).method_27692(class_124.field_1060));
        return 1;
    }

    private static int list(FabricClientCommandSource source) {
        List<String> entities = FuzzSettings.highlightEntityList;
        if (entities.isEmpty()) {
            Messenger.tell(source, tr.tr("list_is_empty", new Object[0]).method_27692(class_124.field_1054));
            return 0;
        }
        Messenger.tell(source, tr.tr("list_title", entities.size()).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        for (String entity : entities) {
            Messenger.tell(source, Messenger.s("- " + entity).method_27692(class_124.field_1068));
        }
        return 1;
    }

    private static int help(FabricClientCommandSource source) {
        Messenger.tell(source, tr.tr("add_help", new Object[0]).method_27692(class_124.field_1080));
        Messenger.tell(source, tr.tr("remove_help", new Object[0]).method_27692(class_124.field_1080));
        Messenger.tell(source, tr.tr("clear_help", new Object[0]).method_27692(class_124.field_1080));
        Messenger.tell(source, tr.tr("list_help", new Object[0]).method_27692(class_124.field_1080));
        return 1;
    }

    private static void saveToJson() {
        CommandHighlightEntitiesConfig.getInstance().saveToJson(FuzzSettings.highlightEntityList);
    }
}

