/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.config.template;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import top.byteeeee.fuzz.FuzzModClient;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractListJsonConfig<T> {
    protected final Path configPath;
    protected final Gson gson;
    private final Type listType;

    protected AbstractListJsonConfig(Path configPath) {
        this.configPath = configPath;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{this.getElementType()}).getType();
    }

    protected abstract Class<T> getElementType();

    public void loadFromJson(List<T> targetList) {
        targetList.clear();
        try {
            if (Files.notExists(this.configPath, new LinkOption[0])) {
                this.saveToJson(Collections.emptyList());
                return;
            }
            byte[] bytes = Files.readAllBytes(this.configPath);
            List loadedList = (List)this.gson.fromJson(new String(bytes, StandardCharsets.UTF_8), this.listType);
            if (loadedList != null) {
                targetList.addAll(loadedList);
            }
        }
        catch (IOException e) {
            FuzzModClient.LOGGER.error("Failed to load config: {}", (Object)this.configPath, (Object)e);
        }
    }

    public void saveToJson(List<T> list) {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            Files.write(this.configPath, this.gson.toJson(list, this.listType).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            FuzzModClient.LOGGER.error("Failed to save config: {}", (Object)this.configPath, (Object)e);
        }
    }
}

