/*
 * Decompiled with CFR 0.152.
 */
package top.byteeeee.fuzz.settings;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import top.byteeeee.fuzz.FuzzModClient;
import top.byteeeee.fuzz.settings.Rule;
import top.byteeeee.fuzz.settings.Validator;

@Environment(value=EnvType.CLIENT)
public class ValidatorManager {
    private static final ConcurrentHashMap<Field, List<Validator<?>>> fieldValidators = new ConcurrentHashMap();

    public static void init(Field field) {
        Rule annotation = field.getAnnotation(Rule.class);
        if (annotation == null) {
            return;
        }
        Class<? extends Validator<?>>[] validatorClasses = annotation.validators();
        if (validatorClasses.length > 0) {
            ArrayList validators = new ArrayList();
            for (Class<Validator<?>> clazz : validatorClasses) {
                try {
                    Validator<?> validator = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    validators.add(validator);
                }
                catch (Exception e) {
                    FuzzModClient.LOGGER.error("Failed to instantiate validator: {}", (Object)clazz.getName(), (Object)e);
                }
            }
            if (!validators.isEmpty()) {
                fieldValidators.put(field, validators);
            }
        }
    }

    public static <T> T validateValue(Field field, T value, FabricClientCommandSource source) {
        Object resultValue = value;
        List<Validator<?>> validators = fieldValidators.get(field);
        if (validators != null && !validators.isEmpty()) {
            for (Validator<?> validator : validators) {
                Validator<?> typedValidator = validator;
                resultValue = typedValidator.validate(source, field, resultValue);
                if (resultValue != null) continue;
                return null;
            }
        }
        return resultValue;
    }

    public static List<String> getValidatorDescriptions(Field field) {
        List<Validator<?>> validators = fieldValidators.get(field);
        if (validators == null || validators.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> descriptions = new ArrayList<String>();
        for (Validator<?> validator : validators) {
            descriptions.add(validator.description());
        }
        return descriptions;
    }
}

