/*
 * Decompiled with CFR 0.152.
 */
package com.youtubepickleakinh4;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="tagpickleakinh4")
public class TagPickleAkinH4 {
    private static final File NICK_FILE = new File("config/nicks.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<UUID, String> PLAYER_NICKS = new HashMap<UUID, String>();
    private static final Map<String, PlayerTeam> TAG_TEAMS = new HashMap<String, PlayerTeam>();
    private static final Set<String> ASSIGNED_NICKS = new HashSet<String>();
    private static boolean isRandomNickActive = false;
    private static int nextPlayerNumber = 1;

    public TagPickleAkinH4() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadNicks();
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nickchange").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"tag", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            String tag = StringArgumentType.getString((CommandContext)context, (String)"tag");
            return this.setPlayerNick((CommandSourceStack)context.getSource(), playerName, tag);
        })))).then(Commands.m_82127_((String)"default").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).executes(context -> this.resetPlayerNick((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player"), null))).then(Commands.m_82129_((String)"oldname", (ArgumentType)StringArgumentType.word()).executes(context -> this.resetPlayerNick((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"eskiIsim"))))))).then(Commands.m_82127_((String)"alldefault").executes(context -> this.resetAllNicks((CommandSourceStack)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nickmeter").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"on").executes(context -> {
            isRandomNickActive = true;
            nextPlayerNumber = 1;
            ASSIGNED_NICKS.clear();
            this.assignRandomNicks((CommandSourceStack)context.getSource());
            return 1;
        }))).then(Commands.m_82127_((String)"off").executes(context -> {
            isRandomNickActive = false;
            this.resetAllNicks((CommandSourceStack)context.getSource());
            return 1;
        })));
    }

    private int setPlayerNick(CommandSourceStack source, String playerName, String tag) throws CommandSyntaxException {
        String teamName;
        PlayerTeam team;
        ServerPlayer player = source.m_81377_().m_6846_().m_11255_(playerName);
        if (player == null) {
            source.m_81352_((Component)Component.m_237113_((String)("players '" + playerName + "' not found")));
            return 0;
        }
        ServerScoreboard scoreboard = player.m_20194_().m_129896_();
        PlayerTeam currentTeam = scoreboard.m_83500_(player.m_6302_());
        if (currentTeam instanceof PlayerTeam) {
            PlayerTeam playerTeam = currentTeam;
            scoreboard.m_6519_(player.m_6302_(), playerTeam);
        }
        if ((team = TAG_TEAMS.get(teamName = "tag_" + tag.replaceAll("[^a-zA-Z0-9]", "_").toLowerCase())) == null) {
            team = scoreboard.m_83492_(teamName);
            team.m_83353_((Component)Component.m_237113_((String)("Tag: " + tag)));
            team.m_83360_((Component)Component.m_237113_((String)("[" + tag + "] ")));
            TAG_TEAMS.put(teamName, team);
        }
        scoreboard.m_6546_(player.m_6302_(), team);
        player.refreshTabListName();
        String newNick = player.m_7755_().getString() + " [" + tag + "]";
        PLAYER_NICKS.put(player.m_20148_(), newNick);
        this.saveNicks();
        source.m_81354_((Component)Component.m_237113_((String)(playerName + " fortag '" + tag + "' added.")), true);
        return 1;
    }

    private int assignRandomNicks(CommandSourceStack source) {
        ServerScoreboard scoreboard = source.m_81377_().m_129896_();
        int playerCount = 0;
        for (PlayerTeam team : TAG_TEAMS.values()) {
            if (!team.m_5758_().startsWith("random_")) continue;
            for (String member : team.m_6809_()) {
                scoreboard.m_6519_(member, team);
            }
            scoreboard.m_83475_(team);
        }
        TAG_TEAMS.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith("random_"));
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            String randomNick = this.getNextAvailableNick();
            String teamName = "random_" + randomNick.replace("Player#", "");
            PlayerTeam currentTeam = scoreboard.m_83500_(player.m_6302_());
            if (currentTeam instanceof PlayerTeam) {
                PlayerTeam playerTeam = currentTeam;
                scoreboard.m_6519_(player.m_6302_(), playerTeam);
            }
            PlayerTeam team = scoreboard.m_83492_(teamName);
            team.m_83353_((Component)Component.m_237113_((String)("Random: " + randomNick)));
            team.m_83360_((Component)Component.m_237113_((String)(randomNick + " ")));
            TAG_TEAMS.put(teamName, team);
            scoreboard.m_6546_(player.m_6302_(), team);
            player.refreshTabListName();
            String newNick = randomNick + " " + player.m_7755_().getString();
            PLAYER_NICKS.put(player.m_20148_(), newNick);
            System.out.println("random nick assigned: " + player.m_7755_().getString() + " -> " + newNick);
        }
        this.saveNicks();
        int finalPlayerCount = playerCount;
        source.m_81354_((Component)Component.m_237113_((String)(finalPlayerCount + " Random nicknames were assigned to the player.")), true);
        return 1;
    }

    private String getNextAvailableNick() {
        while (ASSIGNED_NICKS.contains("Player#" + nextPlayerNumber)) {
            ++nextPlayerNumber;
        }
        String nick = "Player#" + nextPlayerNumber;
        ASSIGNED_NICKS.add(nick);
        ++nextPlayerNumber;
        return nick;
    }

    private int resetPlayerNick(CommandSourceStack source, String playerName, String oldname) throws CommandSyntaxException {
        ServerPlayer player = source.m_81377_().m_6846_().m_11255_(playerName);
        if (player == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Oyuncu '" + playerName + "' bulunamad\u0131.")));
            return 0;
        }
        ServerScoreboard scoreboard = player.m_20194_().m_129896_();
        PlayerTeam currentTeam = scoreboard.m_83500_(player.m_6302_());
        if (currentTeam instanceof PlayerTeam) {
            PlayerTeam playerTeam = currentTeam;
            scoreboard.m_6519_(player.m_6302_(), playerTeam);
            if (currentTeam.m_5758_().startsWith("random_")) {
                ASSIGNED_NICKS.remove(currentTeam.m_5758_().replace("random_", "Player#"));
            }
        }
        String originalName = player.m_7755_().getString();
        PLAYER_NICKS.remove(player.m_20148_());
        player.refreshTabListName();
        this.saveNicks();
        source.m_81354_((Component)Component.m_237113_((String)(playerName + " Nickname reset to original name: " + originalName)), true);
        return 1;
    }

    private int resetAllNicks(CommandSourceStack source) {
        ServerScoreboard scoreboard = source.m_81377_().m_129896_();
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            PlayerTeam currentTeam = scoreboard.m_83500_(player.m_6302_());
            if (currentTeam instanceof PlayerTeam) {
                PlayerTeam playerTeam = currentTeam;
                scoreboard.m_6519_(player.m_6302_(), playerTeam);
                if (currentTeam.m_5758_().startsWith("random_")) {
                    ASSIGNED_NICKS.remove(currentTeam.m_5758_().replace("random_", "Player#"));
                }
            }
            player.refreshTabListName();
        }
        for (PlayerTeam team : TAG_TEAMS.values()) {
            if (!team.m_5758_().startsWith("random_")) continue;
            scoreboard.m_83475_(team);
        }
        TAG_TEAMS.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith("random_"));
        PLAYER_NICKS.clear();
        this.saveNicks();
        source.m_81354_((Component)Component.m_237113_((String)"All nicknames have been reset."), true);
        return 1;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (isRandomNickActive) {
            String randomNick = this.getNextAvailableNick();
            String teamName = "random_" + randomNick.replace("Player#", "");
            ServerScoreboard scoreboard = player.m_20194_().m_129896_();
            PlayerTeam currentTeam = scoreboard.m_83500_(player.m_6302_());
            if (currentTeam instanceof PlayerTeam) {
                PlayerTeam playerTeam = currentTeam;
                scoreboard.m_6519_(player.m_6302_(), playerTeam);
            }
            PlayerTeam team = scoreboard.m_83492_(teamName);
            team.m_83353_((Component)Component.m_237113_((String)("Random: " + randomNick)));
            team.m_83360_((Component)Component.m_237113_((String)(randomNick + " ")));
            TAG_TEAMS.put(teamName, team);
            scoreboard.m_6546_(player.m_6302_(), team);
            player.refreshTabListName();
            String newNick = randomNick + " " + player.m_7755_().getString();
            PLAYER_NICKS.put(player.m_20148_(), newNick);
            this.saveNicks();
            System.out.println("Random nickname assigned for new player: " + player.m_7755_().getString() + " -> " + newNick);
        } else {
            String nick = PLAYER_NICKS.get(player.m_20148_());
            if (nick != null) {
                String teamName;
                ServerScoreboard scoreboard = player.m_20194_().m_129896_();
                if (nick.startsWith("Player#")) {
                    String[] parts = nick.split(" ", 2);
                    String randomNick = parts[0];
                    teamName = "random_" + randomNick.replace("Player#", "");
                } else {
                    String tag = nick.replaceAll(".*\\[([^\\]]+)\\]$", "$1");
                    teamName = "tag_" + tag.replaceAll("[^a-zA-Z0-9]", "_").toLowerCase();
                }
                PlayerTeam team = TAG_TEAMS.get(teamName);
                if (team == null) {
                    System.out.println("Team not found: " + teamName);
                    return;
                }
                scoreboard.m_6546_(player.m_6302_(), team);
                player.refreshTabListName();
                System.out.println("Player login: " + player.m_7755_().getString() + " -> " + nick);
            }
        }
    }

    private void loadNicks() {
        if (!NICK_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(NICK_FILE);){
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map loaded = (Map)GSON.fromJson((Reader)reader, type);
            if (loaded != null) {
                loaded.forEach((uuid, nick) -> {
                    PLAYER_NICKS.put(UUID.fromString(uuid), (String)nick);
                    if (nick.startsWith("Player#")) {
                        String randomNick = nick.split(" ", 2)[0];
                        ASSIGNED_NICKS.add(randomNick);
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveNicks() {
        HashMap toSave = new HashMap();
        PLAYER_NICKS.forEach((uuid, nick) -> toSave.put(uuid.toString(), nick));
        try {
            if (!NICK_FILE.getParentFile().exists()) {
                NICK_FILE.getParentFile().mkdirs();
            }
            try (FileWriter writer = new FileWriter(NICK_FILE);){
                GSON.toJson(toSave, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

