/*
 * Decompiled with CFR 0.152.
 */
package com.example.hidenamesv;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class HideNamesCommand {
    private static final String TEAM_NAME = "hidden_names";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hidenameopen").requires(source -> source.hasPermission(3))).executes(context -> {
            HideNamesCommand.hidePlayerNames((CommandSourceStack)context.getSource());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Player names displayed!"), true);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hidenameclose").requires(source -> source.hasPermission(3))).executes(context -> {
            HideNamesCommand.showPlayerNames((CommandSourceStack)context.getSource());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Player names hidden"), true);
            return 1;
        }));
    }

    private static void hidePlayerNames(CommandSourceStack source) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        PlayerTeam team = null;
        if (scoreboard.getPlayerTeam(TEAM_NAME) instanceof PlayerTeam) {
            team = scoreboard.getPlayerTeam(TEAM_NAME);
        }
        if (team == null) {
            team = scoreboard.addPlayerTeam(TEAM_NAME);
            team.setNameTagVisibility(Team.Visibility.NEVER);
        }
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            scoreboard.addPlayerToTeam(player.getScoreboardName(), team);
        }
    }

    private static void showPlayerNames(CommandSourceStack source) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        PlayerTeam team = null;
        if (scoreboard.getPlayerTeam(TEAM_NAME) instanceof PlayerTeam) {
            team = scoreboard.getPlayerTeam(TEAM_NAME);
        }
        if (team != null) {
            scoreboard.removePlayerTeam(team);
        }
    }
}

