/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.hidenamesv15;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class HideNamesCommand15 {
    private static final String BLOCKED_TEAM_NAME = "blocked_names";
    private static boolean hideNamesBehindBlocks = false;
    private static int tickCounter = 0;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hideblockopen").requires(source -> source.m_6761_(2))).executes(context -> {
            hideNamesBehindBlocks = true;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Hiding names behind blocks enabled!"), true);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hideblockclose").requires(source -> source.m_6761_(2))).executes(context -> {
            hideNamesBehindBlocks = false;
            HideNamesCommand15.showAllNamesFromBlocks((CommandSourceStack)context.getSource());
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Hiding names behind blocks disabled!"), true);
            return 1;
        }));
    }

    private static void showAllNamesFromBlocks(CommandSourceStack source) {
        PlayerTeam team;
        ServerScoreboard scoreboard = source.m_81377_().m_129896_();
        PlayerTeam playerTeam = team = scoreboard.m_83489_(BLOCKED_TEAM_NAME) instanceof PlayerTeam ? scoreboard.m_83489_(BLOCKED_TEAM_NAME) : null;
        if (team != null) {
            scoreboard.m_83475_(team);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        PlayerTeam blockedTeam;
        if (!hideNamesBehindBlocks || event.phase != TickEvent.Phase.END || ++tickCounter % 5 != 0) {
            return;
        }
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129783_();
        if (level == null) {
            return;
        }
        ServerScoreboard scoreboard = level.m_6188_();
        PlayerTeam playerTeam = blockedTeam = scoreboard.m_83489_(BLOCKED_TEAM_NAME) instanceof PlayerTeam ? scoreboard.m_83489_(BLOCKED_TEAM_NAME) : null;
        if (blockedTeam == null) {
            blockedTeam = scoreboard.m_83492_(BLOCKED_TEAM_NAME);
            blockedTeam.m_83346_(Team.Visibility.NEVER);
        }
        for (ServerPlayer viewer : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            Vec3 viewerPos = viewer.m_20299_(1.0f);
            for (ServerPlayer target : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                if (viewer == target) continue;
                Vec3 targetPos = target.m_20299_(1.0f);
                ClipContext context = new ClipContext(viewerPos, targetPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)viewer);
                BlockHitResult result = level.m_45547_(context);
                PlayerTeam currentTeam = scoreboard.m_83500_(target.m_6302_());
                if (result.m_6662_() == HitResult.Type.BLOCK) {
                    scoreboard.m_6546_(target.m_6302_(), blockedTeam);
                    continue;
                }
                if (currentTeam == null || !currentTeam.equals(blockedTeam)) continue;
                scoreboard.m_6519_(target.m_6302_(), blockedTeam);
            }
        }
    }
}

