/*
 * Decompiled with CFR 0.152.
 */
package com.youtubepickleakinh3;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class HideNameCommandH3 {
    private static final String GLOBAL_HIDE_TEAM = "hidden_names";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hidename").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"open").executes(context -> HideNameCommandH3.hideAllNames((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"close").executes(context -> HideNameCommandH3.showAllNames((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"default").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> HideNameCommandH3.resetPlayerToDefault((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> HideNameCommandH3.hidePlayerName((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))));
    }

    private static int hideAllNames(CommandSourceStack source) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.m_81377_().m_129896_();
        PlayerTeam globalTeam = scoreboard.m_83489_(GLOBAL_HIDE_TEAM);
        if (globalTeam == null) {
            globalTeam = scoreboard.m_83492_(GLOBAL_HIDE_TEAM);
            globalTeam.m_83346_(Team.Visibility.NEVER);
        }
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            String playerName = player.m_6302_();
            scoreboard.m_6546_(playerName, globalTeam);
        }
        source.m_288197_(() -> Component.m_237113_((String)"All player names hidden."), true);
        return 1;
    }

    private static int showAllNames(CommandSourceStack source) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.m_81377_().m_129896_();
        PlayerTeam globalTeam = scoreboard.m_83489_(GLOBAL_HIDE_TEAM);
        if (globalTeam != null) {
            for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
                String playerName = player.m_6302_();
                scoreboard.m_6519_(playerName, globalTeam);
            }
            scoreboard.m_83475_(globalTeam);
        }
        source.m_288197_(() -> Component.m_237113_((String)"All player names shown."), true);
        return 1;
    }

    private static int hidePlayerName(CommandSourceStack source, String playerName) throws CommandSyntaxException {
        ServerPlayer player = source.m_81377_().m_6846_().m_11255_(playerName);
        if (player == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Player " + playerName + " not found.")));
            return 0;
        }
        ServerScoreboard scoreboard = source.m_81377_().m_129896_();
        PlayerTeam globalTeam = scoreboard.m_83489_(GLOBAL_HIDE_TEAM);
        if (globalTeam == null) {
            globalTeam = scoreboard.m_83492_(GLOBAL_HIDE_TEAM);
            globalTeam.m_83346_(Team.Visibility.NEVER);
        }
        scoreboard.m_6546_(playerName, globalTeam);
        source.m_288197_(() -> Component.m_237113_((String)("Hid name for " + playerName + ".")), true);
        return 1;
    }

    private static int resetPlayerToDefault(CommandSourceStack source, String playerName) throws CommandSyntaxException {
        ServerPlayer player = source.m_81377_().m_6846_().m_11255_(playerName);
        if (player == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Player " + playerName + " not found.")));
            return 0;
        }
        ServerScoreboard scoreboard = source.m_81377_().m_129896_();
        PlayerTeam globalTeam = scoreboard.m_83489_(GLOBAL_HIDE_TEAM);
        if (globalTeam != null) {
            scoreboard.m_6519_(playerName, globalTeam);
        }
        source.m_288197_(() -> Component.m_237113_((String)("Reset " + playerName + " to default settings.")), true);
        return 1;
    }
}

