/*
 * Decompiled with CFR 0.152.
 */
package com.beckytidus.chatbubbles;

import com.beckytidus.chatbubbles.config.ChatBubblesConfig;
import net.minecraft.class_243;
import net.minecraft.class_2561;

public class ChatBubble {
    private final class_2561 message;
    private final class_243 initialPosition;
    private final long creationTime;
    private final int displayDuration;
    private final int fadeDuration;
    private final int fadeInDuration;
    private final double upwardSpeed;

    public ChatBubble(class_2561 message, class_243 position, long creationTime) {
        this.message = message;
        this.initialPosition = position;
        this.creationTime = creationTime;
        this.displayDuration = ChatBubblesConfig.INSTANCE.displayDuration;
        this.fadeDuration = ChatBubblesConfig.INSTANCE.fadeDuration;
        this.fadeInDuration = ChatBubblesConfig.INSTANCE.fadeInDuration;
        this.upwardSpeed = ChatBubblesConfig.INSTANCE.upwardSpeed;
    }

    public class_2561 getMessage() {
        return this.message;
    }

    public class_243 getPosition(long currentTime) {
        long elapsed = currentTime - this.creationTime;
        double secondsElapsed = (double)elapsed / 1000.0;
        double yOffset = secondsElapsed * this.upwardSpeed;
        return this.initialPosition.method_1031(0.0, yOffset, 0.0);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public float getAlpha(long currentTime) {
        long elapsed = currentTime - this.creationTime;
        if (elapsed > (long)(this.displayDuration + this.fadeDuration)) {
            return 0.0f;
        }
        if (elapsed < (long)this.fadeInDuration) {
            float fadeInProgress = (float)elapsed / (float)this.fadeInDuration;
            return fadeInProgress;
        }
        if (elapsed > (long)this.displayDuration) {
            float fadeOutProgress = (float)(elapsed - (long)this.displayDuration) / (float)this.fadeDuration;
            return 1.0f - fadeOutProgress;
        }
        return 1.0f;
    }

    public boolean shouldRemove(long currentTime) {
        return currentTime - this.creationTime > (long)(this.displayDuration + this.fadeDuration);
    }
}

