/*
 * Decompiled with CFR 0.152.
 */
package com.beckytidus.chatbubbles;

import com.beckytidus.chatbubbles.ChatBubble;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_243;
import net.minecraft.class_2561;

public class ChatBubbleManager {
    private static final ChatBubbleManager INSTANCE = new ChatBubbleManager();
    private final ConcurrentHashMap<UUID, List<ChatBubble>> playerBubbles = new ConcurrentHashMap();

    private ChatBubbleManager() {
    }

    public static ChatBubbleManager getInstance() {
        return INSTANCE;
    }

    public void addChatBubble(UUID playerId, class_2561 message, class_243 position) {
        ChatBubble bubble = new ChatBubble(message, position, System.currentTimeMillis());
        this.playerBubbles.computeIfAbsent(playerId, k -> new ArrayList()).add(bubble);
    }

    public List<ChatBubble> getAllBubbles() {
        ArrayList<ChatBubble> allBubbles = new ArrayList<ChatBubble>();
        for (List<ChatBubble> bubbles : this.playerBubbles.values()) {
            allBubbles.addAll(bubbles);
        }
        return allBubbles;
    }

    public void tick() {
        long currentTime = System.currentTimeMillis();
        this.playerBubbles.values().forEach(bubbles -> bubbles.removeIf(bubble -> bubble.shouldRemove(currentTime)));
        this.playerBubbles.entrySet().removeIf(entry -> ((List)entry.getValue()).isEmpty());
    }
}

