/*
 * Decompiled with CFR 0.152.
 */
package com.beckytidus.chatbubbles.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ChatBubblesConfig {
    public static final ChatBubblesConfig INSTANCE = new ChatBubblesConfig();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("chat-bubbles.json");
    public boolean showPlayerName = false;
    public double bubbleHeight = 0.75;
    public double textScale = 0.025;
    public int displayDuration = 3000;
    public int fadeDuration = 1000;
    public int fadeInDuration = 200;
    public int textColor = 0xFFFFFF;
    public double maxDistance = 64.0;
    public double upwardSpeed = 0.1;
    public int backgroundColor = 0;
    public int backgroundTransparency = 85;

    private ChatBubblesConfig() {
    }

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                ChatBubblesConfig loaded = (ChatBubblesConfig)GSON.fromJson(json, ChatBubblesConfig.class);
                ChatBubblesConfig.INSTANCE.showPlayerName = loaded.showPlayerName;
                ChatBubblesConfig.INSTANCE.bubbleHeight = loaded.bubbleHeight;
                ChatBubblesConfig.INSTANCE.textScale = loaded.textScale;
                ChatBubblesConfig.INSTANCE.displayDuration = loaded.displayDuration;
                ChatBubblesConfig.INSTANCE.fadeDuration = loaded.fadeDuration;
                ChatBubblesConfig.INSTANCE.fadeInDuration = loaded.fadeInDuration;
                ChatBubblesConfig.INSTANCE.textColor = loaded.textColor;
                ChatBubblesConfig.INSTANCE.maxDistance = loaded.maxDistance;
                ChatBubblesConfig.INSTANCE.upwardSpeed = loaded.upwardSpeed;
                ChatBubblesConfig.INSTANCE.backgroundColor = loaded.backgroundColor;
                ChatBubblesConfig.INSTANCE.backgroundTransparency = loaded.backgroundTransparency;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ChatBubblesConfig.save();
        }
    }

    public static void save() {
        try {
            String json = GSON.toJson((Object)INSTANCE);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

