/*
 * Decompiled with CFR 0.152.
 */
package com.beckytidus.chatbubbles.mixin;

import com.beckytidus.chatbubbles.ChatBubbleManager;
import com.beckytidus.chatbubbles.config.ChatBubblesConfig;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_338.class})
public class ChatHudMixin {
    @Shadow
    @Final
    private class_310 field_2062;
    private static final Pattern CHAT_PATTERN = Pattern.compile("<([^>]+)>");

    @Inject(method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;Lnet/minecraft/client/gui/hud/MessageIndicator;)V"}, at={@At(value="HEAD")})
    private void onChatMessage(class_2561 message, @Nullable class_7469 signature, @Nullable class_7591 indicator, CallbackInfo ci) {
        String playerName;
        class_1657 player;
        if (this.field_2062.field_1687 == null) {
            return;
        }
        String messageString = message.getString();
        Matcher matcher = CHAT_PATTERN.matcher(messageString);
        if (matcher.find() && (player = this.findPlayerByName(this.field_2062.field_1687, playerName = matcher.group(1))) != null) {
            double height = ChatBubblesConfig.INSTANCE.bubbleHeight;
            class_243 bubblePos = player.method_73189().method_1031(0.0, (double)player.method_17682() + height, 0.0);
            String chatText = messageString.substring(matcher.end()).trim();
            class_2561 bubbleMessage = ChatBubblesConfig.INSTANCE.showPlayerName ? message : class_2561.method_43470((String)chatText);
            ChatBubbleManager.getInstance().addChatBubble(player.method_5667(), bubbleMessage, bubblePos);
        }
    }

    private class_1657 findPlayerByName(class_638 world, String name) {
        for (class_742 player : world.method_18456()) {
            if (!player.method_5477().getString().equals(name)) continue;
            return player;
        }
        return null;
    }
}

