/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.ae2tangilblebookmarks.mixin.emi;

import dev.emi.emi.EmiPort;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.input.EmiBind;
import dev.emi.emi.screen.ConfigScreen;
import dev.emi.emi.screen.widget.config.ConfigSearch;
import dev.emi.emi.screen.widget.config.EmiBindWidget;
import dev.emi.emi.screen.widget.config.GroupNameWidget;
import dev.emi.emi.screen.widget.config.ListWidget;
import dev.emi.emi.screen.widget.config.SubGroupNameWidget;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Supplier;
import me.myogoo.ae2tangilblebookmarks.integration.emi.AE2TBEmiBind;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ConfigScreen.class})
public abstract class EmiConfigScreenMixin
extends Screen {
    @Shadow
    public ListWidget list;
    @Shadow
    private ConfigSearch search;

    protected EmiConfigScreenMixin(Component title) {
        super(title);
    }

    @Shadow
    public static List<ClientTooltipComponent> getFieldTooltip(Field field) {
        return null;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void addCustomBinds(CallbackInfo ci) {
        Supplier<String> searchSupplier = () -> this.search.getSearch();
        String lastGroup = "";
        GroupNameWidget lastGroupWidget = null;
        EmiConfig.ConfigGroup currentGroup = null;
        SubGroupNameWidget currentSubGroupWidget = null;
        for (Field field : AE2TBEmiBind.class.getFields()) {
            EmiConfig.ConfigValue annot = field.getAnnotation(EmiConfig.ConfigValue.class);
            if (annot == null || field.getType() != EmiBind.class) continue;
            try {
                boolean endGroup;
                EmiConfig.ConfigGroup configGroup;
                String group = annot.value().split("\\.")[0];
                if (!group.equals(lastGroup)) {
                    lastGroup = group;
                    MutableComponent text = EmiPort.translatable((String)("config.emi.group." + group.replace('-', '_')));
                    lastGroupWidget = new GroupNameWidget(group, (Component)text);
                    this.list.addEntry((ListWidget.Entry)lastGroupWidget);
                }
                if ((configGroup = field.getAnnotation(EmiConfig.ConfigGroup.class)) != null) {
                    currentGroup = configGroup;
                    MutableComponent text = EmiPort.translatable((String)("config.emi.group." + configGroup.value().replace('-', '_')));
                    currentSubGroupWidget = new SubGroupNameWidget(configGroup.value(), (Component)text);
                    currentSubGroupWidget.parent = lastGroupWidget;
                    this.list.addEntry((ListWidget.Entry)currentSubGroupWidget);
                }
                EmiBind bind = (EmiBind)field.get(null);
                EmiBindWidget entry = new EmiBindWidget((ConfigScreen)this, EmiConfigScreenMixin.getFieldTooltip(field), searchSupplier, bind);
                boolean bl = endGroup = field.getAnnotation(EmiConfig.ConfigGroupEnd.class) != null;
                if (entry != null) {
                    entry.group = currentGroup;
                    entry.endGroup = endGroup;
                    this.list.addEntry((ListWidget.Entry)entry);
                    if (lastGroupWidget != null) {
                        lastGroupWidget.children.add(entry);
                        entry.parentGroups.add(lastGroupWidget);
                    }
                    if (currentSubGroupWidget != null) {
                        currentSubGroupWidget.children.add(entry);
                        entry.parentGroups.add(currentSubGroupWidget);
                    }
                }
                if (!endGroup) continue;
                currentGroup = null;
                currentSubGroupWidget = null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

