/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;
import tfagaming.projects.minecraft.homestead.flags.PlayerFlags;
import tfagaming.projects.minecraft.homestead.flags.WorldFlags;
import tfagaming.projects.minecraft.homestead.logs.Logger;

public class ConfigLoader {
    private File configFile;
    private FileConfiguration config;

    public ConfigLoader(Homestead plugin) {
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            Logger.error("Unable to find the configuration file, closing plugin's instance...");
            plugin.endInstance();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        Logger.info("The configuration file is ready.");
    }

    public <T> T get(String path) {
        return (T)this.config.get(path);
    }

    public List<String> getKeysUnderPath(String path) {
        if (this.config.isConfigurationSection(path)) {
            Set keys = this.config.getConfigurationSection(path).getKeys(false);
            return new ArrayList<String>(keys);
        }
        return new ArrayList<String>();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public long getDefaultPlayerFlags() {
        List<String> keys = this.getKeysUnderPath("default-players-flags");
        long flags = 0L;
        for (String key : keys) {
            boolean value = (Boolean)this.get("default-players-flags." + key);
            if (!value) continue;
            flags = FlagsCalculator.addFlag(flags, PlayerFlags.valueOf(key));
        }
        return flags;
    }

    public long getDefaultWorldFlags() {
        List<String> keys = this.getKeysUnderPath("default-world-flags");
        long flags = 0L;
        for (String key : keys) {
            boolean value = (Boolean)this.get("default-world-flags." + key);
            if (!value) continue;
            flags = FlagsCalculator.addFlag(flags, WorldFlags.valueOf(key));
        }
        return flags;
    }

    public boolean isFlagDisabled(String flag) {
        return ((List)this.get("disabled-flags")).contains(flag);
    }

    public boolean isWelcomeSignEnabled() {
        return (Boolean)this.get("welcome-signs.enabled");
    }

    public String getPrefix() {
        return (String)Homestead.language.get("prefix");
    }

    public boolean isDebugEnabled() {
        return (Boolean)this.get("debug");
    }
}

