/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import com.google.common.base.Function;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.gui.Menu;
import tfagaming.projects.minecraft.homestead.gui.menus.SubAreaFlagsMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.SubAreasMenu;
import tfagaming.projects.minecraft.homestead.sessions.playerinput.PlayerInputSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.java.StringUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class SubAreaSettingsMenu {
    public SubAreaSettingsMenu(Player player, Region region, SerializableSubArea subArea) {
        Menu gui = new Menu(MenuUtils.getTitle(15).replace("{subarea}", subArea.getName()), 27);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{subarea}", subArea.getName());
        ItemStack renameSubAreaButton = MenuUtils.getButton(43, replacements, new OfflinePlayer[0]);
        gui.addItem(11, renameSubAreaButton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!player.hasPermission("homestead.region.subareas.rename")) {
                PlayerUtils.sendMessage(player, 8);
                return;
            }
            player.closeInventory();
            new PlayerInputSession(Homestead.getInstance(), player, (p, input) -> {
                String oldName = subArea.getName();
                region.setSubAreaName(subArea.getId(), (String)input);
                replacements.put("{oldname}", oldName);
                replacements.put("{newname}", (String)input);
                PlayerUtils.sendMessage(player, 61, (Map<String, String>)replacements);
                Homestead.getInstance().runSyncTask(() -> new SubAreaSettingsMenu(player, region, subArea));
            }, (Function<String, Boolean>)((Function)message -> {
                if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 4096L)) {
                    return false;
                }
                if (!StringUtils.isValidSubAreaName(message)) {
                    PlayerUtils.sendMessage(player, 57);
                    return false;
                }
                if (subArea.getName().equalsIgnoreCase((String)message)) {
                    PlayerUtils.sendMessage(player, 11);
                    return false;
                }
                if (region.isSubAreaNameUsed((String)message)) {
                    PlayerUtils.sendMessage(player, 58);
                    return false;
                }
                return true;
            }), __player -> Homestead.getInstance().runSyncTask(() -> new SubAreaSettingsMenu(player, region, subArea)), 88);
        });
        ItemStack flagsSubAreabutton = MenuUtils.getButton(44, replacements, new OfflinePlayer[0]);
        gui.addItem(13, flagsSubAreabutton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!player.hasPermission("homestead.region.subareas.flags")) {
                PlayerUtils.sendMessage(player, 8);
                return;
            }
            new SubAreaFlagsMenu(player, region, subArea);
        });
        ItemStack deleteSubAreaButton = MenuUtils.getButton(45, replacements, new OfflinePlayer[0]);
        gui.addItem(15, deleteSubAreaButton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!player.hasPermission("homestead.region.subareas.delete")) {
                PlayerUtils.sendMessage(player, 8);
                return;
            }
            if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 4096L)) {
                return;
            }
            region.removeSubArea(subArea.getId());
            PlayerUtils.sendMessage(player, 62, (Map<String, String>)replacements);
            new SubAreasMenu(player, region);
        });
        gui.addItem(18, MenuUtils.getBackButton(), (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            new SubAreasMenu(player, region);
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }
}

