/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.commands.CommandBuilder;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.CheckUpdatesSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.FlagsOverrideSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.ImportDataSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.MigrateDataSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.PluginSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin.ReloadSubCmd;
import tfagaming.projects.minecraft.homestead.flags.PlayerFlags;
import tfagaming.projects.minecraft.homestead.flags.WorldFlags;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.tools.commands.AutoCompleteFilter;
import tfagaming.projects.minecraft.homestead.tools.java.StringSimilarity;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class HomesteadAdminCommand
extends CommandBuilder {
    public HomesteadAdminCommand() {
        super("homesteadadmin", "hsadmin");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        if (args.length < 1) {
            PlayerUtils.sendMessage(sender, 0);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (this.getSubcommands().contains(subCommand) && sender instanceof Player && !sender.hasPermission("homestead.commands.homesteadadmin." + subCommand)) {
            PlayerUtils.sendMessage(sender, 8);
            return true;
        }
        switch (subCommand) {
            case "migratedata": {
                new MigrateDataSubCmd().onExecution(sender, args);
                break;
            }
            case "plugin": {
                new PluginSubCmd().onExecution(sender, args);
                break;
            }
            case "reload": {
                new ReloadSubCmd().onExecution(sender, args);
                break;
            }
            case "updates": {
                new CheckUpdatesSubCmd().onExecution(sender, args);
                break;
            }
            case "importdata": {
                new ImportDataSubCmd().onExecution(sender, args);
                break;
            }
            case "flagsoverride": {
                new FlagsOverrideSubCmd().onExecution(sender, args);
                break;
            }
            default: {
                String similaritySubCmds = StringSimilarity.findTopSimilarStrings(this.getSubcommands(), subCommand).stream().collect(Collectors.joining(", "));
                if (sender instanceof Player) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{similarity-subcmds}", similaritySubCmds);
                    PlayerUtils.sendMessage(sender, 7, replacements);
                    break;
                }
                sender.sendMessage(new String[]{"Unknown sub-command, maybe you meant...", similaritySubCmds});
            }
        }
        return true;
    }

    @Override
    public List<String> onAutoComplete(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return Lists.newArrayList();
        }
        Player player = (Player)sender;
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            List subcommands = this.getSubcommands().stream().filter(cmd -> cmd.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
            for (String subcommand : subcommands) {
                if (!player.hasPermission("homestead.commands.homesteadadmin." + subcommand)) continue;
                suggestions.add(subcommand);
            }
            return suggestions;
        }
        if (this.getSubcommands().contains(args[0].toLowerCase()) && !player.hasPermission("homestead.commands.homesteadadmin." + args[0].toLowerCase())) {
            return new ArrayList<String>();
        }
        switch (args[0].toLowerCase()) {
            case "migratedata": {
                if (args.length != 2) break;
                suggestions.addAll(List.of("SQLite", "MySQL", "YAML", "PostgreSQL"));
                break;
            }
            case "importdata": {
                if (args.length != 2) break;
                suggestions.addAll(List.of("GriefPrevention", "LandLord", "ClaimChunk"));
                break;
            }
            case "flagsoverride": {
                if (args.length == 2) {
                    suggestions.addAll(List.of("member", "global", "world"));
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("member")) {
                    Region region = TargetRegionSession.getRegion((OfflinePlayer)player);
                    if (region == null) break;
                    for (SerializableMember member : region.getMembers()) {
                        OfflinePlayer bukkitMember = member.getBukkitOfflinePlayer();
                        if (bukkitMember == null) continue;
                        suggestions.add(bukkitMember.getName());
                    }
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("global")) {
                    suggestions.addAll(PlayerFlags.getFlags());
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("world")) {
                    suggestions.addAll(WorldFlags.getFlags());
                    break;
                }
                if (args.length == 4 && args[1].equalsIgnoreCase("member")) {
                    suggestions.addAll(PlayerFlags.getFlags());
                    break;
                }
                if (!(args.length == 4 && args[1].equalsIgnoreCase("global") || args.length == 4 && args[1].equalsIgnoreCase("world")) && (args.length != 5 || !args[1].equalsIgnoreCase("member"))) break;
                suggestions.addAll(List.of("allow", "deny"));
            }
        }
        return AutoCompleteFilter.filter(suggestions, args);
    }

    public List<String> getSubcommands() {
        return Lists.newArrayList((Object[])new String[]{"migratedata", "plugin", "reload", "updates", "importdata", "flagsoverride"});
    }
}

