/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionInfoMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionMenu;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.java.ListUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.teleportation.DelayedTeleport;

public class RegionsMenu {
    private static final Set<UUID> ADMIN_SHOW_ALL = ConcurrentHashMap.newKeySet();
    private List<Region> regions = new ArrayList<Region>();

    private static boolean isShowAllEnabled(Player p) {
        return p.isOp() && ADMIN_SHOW_ALL.contains(p.getUniqueId());
    }

    private static void toggleShowAll(Player p) {
        if (!p.isOp()) {
            return;
        }
        UUID id = p.getUniqueId();
        if (!ADMIN_SHOW_ALL.add(id)) {
            ADMIN_SHOW_ALL.remove(id);
        }
    }

    private List<Region> computeRegionList(Player player) {
        if (RegionsMenu.isShowAllEnabled(player)) {
            return new ArrayList<Region>(RegionsManager.getAll());
        }
        ArrayList<Region> list = new ArrayList<Region>();
        list.addAll(RegionsManager.getRegionsOwnedByPlayer((OfflinePlayer)player));
        list.addAll(RegionsManager.getRegionsHasPlayerAsMember((OfflinePlayer)player));
        return ListUtils.removeDuplications(list);
    }

    private static ItemStack createAdminToggleItem(Player player) {
        boolean on = RegionsMenu.isShowAllEnabled(player);
        ItemStack item = new ItemStack(on ? Material.EMERALD_BLOCK : Material.REDSTONE_BLOCK);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Show all regions");
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: " + (on ? String.valueOf(ChatColor.GREEN) + "ON" : String.valueOf(ChatColor.RED) + "OFF"));
        lore.add(String.valueOf(ChatColor.DARK_GRAY) + (on ? "(Currently showing all regions.)" : "(Showing only your regions.)"));
        lore.add("");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left-click: " + String.valueOf(ChatColor.WHITE) + "Toggle");
        meta.setLore(lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    private List<ItemStack> getItems(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (player.isOp()) {
            items.add(RegionsMenu.createAdminToggleItem(player));
        }
        for (Region region : this.regions) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            replacements.put("{region-displayname}", region.getDisplayName());
            replacements.put("{region-owner}", region.getOwner().getName());
            replacements.put("{region-bank}", Formatters.formatBalance(region.getBank()));
            replacements.put("{region-createdat}", Formatters.formatDate(region.getCreatedAt()));
            Region targetRegion = TargetRegionSession.getRegion((OfflinePlayer)player);
            if (targetRegion != null && targetRegion.getUniqueId().equals(region.getUniqueId())) {
                items.add(MenuUtils.getButton(5, replacements, new OfflinePlayer[0]));
                continue;
            }
            items.add(MenuUtils.getButton(4, replacements, new OfflinePlayer[0]));
        }
        return items;
    }

    public RegionsMenu(Player player) {
        this.regions = this.computeRegionList(player);
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(0), 36, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), this.getItems(player), (_player, event) -> _player.closeInventory(), (_player, context) -> {
            boolean hasToggle = _player.isOp();
            int index = context.getIndex();
            if (hasToggle && index == 0) {
                if (context.getEvent().isLeftClick()) {
                    RegionsMenu.toggleShowAll(_player);
                    new RegionsMenu((Player)_player);
                }
                return;
            }
            if (hasToggle) {
                --index;
            }
            if (index < 0 || index >= this.regions.size()) {
                return;
            }
            Region region = this.regions.get(index);
            if (context.getEvent().isShiftClick() && context.getEvent().isRightClick()) {
                new RegionInfoMenu((Player)_player, region, () -> new RegionsMenu((Player)_player));
                return;
            }
            if (context.getEvent().isRightClick()) {
                boolean allowed;
                if (region.getLocation() == null) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{region}", region.getName());
                    PlayerUtils.sendMessage(_player, 71, replacements);
                    return;
                }
                boolean bl = allowed = PlayerUtils.isOperator(_player) || _player.getUniqueId().equals(region.getOwnerId()) || PlayerUtils.hasPermissionFlag(region.getUniqueId(), _player, 0x2000000L) && PlayerUtils.hasPermissionFlag(region.getUniqueId(), _player, 0x4000000L);
                if (!allowed) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{region}", region.getName());
                    PlayerUtils.sendMessage(_player, 45, replacements);
                    return;
                }
                new DelayedTeleport((Player)_player, region.getLocation().getBukkitLocation());
                return;
            }
            if (context.getEvent().isShiftClick() && context.getEvent().isLeftClick()) {
                if (TargetRegionSession.getRegion((OfflinePlayer)_player) != null && TargetRegionSession.getRegion((OfflinePlayer)_player).getUniqueId().equals(region.getUniqueId())) {
                    return;
                }
                new TargetRegionSession((Player)_player, region);
                _player.playSound(_player.getLocation(), Sound.BLOCK_LEVER_CLICK, 500.0f, 1.0f);
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(_player, 12, replacements);
                PaginationMenu instance = context.getInstance();
                this.regions = this.computeRegionList((Player)_player);
                instance.setItems(this.getItems((Player)_player));
                return;
            }
            if (context.getEvent().isLeftClick()) {
                new RegionMenu((Player)_player, region);
            }
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }
}

