/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.structure.serializable;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBlock;

public class SerializableSubArea {
    private UUID id = UUID.randomUUID();
    private UUID regionId;
    private String name;
    private String worldName;
    private int[] point1;
    private int[] point2;
    private long flags;
    private long createdAt;

    public SerializableSubArea(UUID regionId, String name, World world, Block point1, Block point2, long flags) {
        this.regionId = regionId;
        this.name = name;
        this.worldName = world.getName();
        this.point1 = SerializableSubArea.getBlockLocation(point1);
        this.point2 = SerializableSubArea.getBlockLocation(point2);
        this.flags = flags;
        this.createdAt = System.currentTimeMillis();
    }

    public SerializableSubArea(UUID id, UUID regionId, String name, String worldName, Block point1, Block point2, long flags, long createdAt) {
        this.regionId = regionId;
        this.name = name;
        this.worldName = worldName;
        this.point1 = SerializableSubArea.getBlockLocation(point1);
        this.point2 = SerializableSubArea.getBlockLocation(point2);
        this.flags = flags;
        this.createdAt = createdAt;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getRegionId() {
        return this.regionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.worldName);
    }

    public Block getFirstPoint() {
        return SerializableSubArea.parseBlockLocation(this.getWorld(), this.point1);
    }

    public Block getSecondPoint() {
        return SerializableSubArea.parseBlockLocation(this.getWorld(), this.point2);
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    private int getMinX() {
        Block firstPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point1);
        Block secondPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point2);
        return Math.min(firstPoint.getX(), secondPoint.getX());
    }

    private int getMaxX() {
        Block firstPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point1);
        Block secondPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point2);
        return Math.max(firstPoint.getX(), secondPoint.getX());
    }

    private int getMinY() {
        Block firstPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point1);
        Block secondPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point2);
        return Math.min(firstPoint.getY(), secondPoint.getY());
    }

    private int getMaxY() {
        Block firstPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point1);
        Block secondPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point2);
        return Math.max(firstPoint.getY(), secondPoint.getY());
    }

    private int getMinZ() {
        Block firstPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point1);
        Block secondPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point2);
        return Math.min(firstPoint.getZ(), secondPoint.getZ());
    }

    private int getMaxZ() {
        Block firstPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point1);
        Block secondPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point2);
        return Math.max(firstPoint.getZ(), secondPoint.getZ());
    }

    public static int getMinX(SerializableBlock firstPoint, SerializableBlock secondPoint) {
        return Math.min(firstPoint.getX(), secondPoint.getX());
    }

    public static int getMaxX(SerializableBlock firstPoint, SerializableBlock secondPoint) {
        return Math.max(firstPoint.getX(), secondPoint.getX());
    }

    public static int getMinY(SerializableBlock firstPoint, SerializableBlock secondPoint) {
        return Math.min(firstPoint.getY(), secondPoint.getY());
    }

    public static int getMaxY(SerializableBlock firstPoint, SerializableBlock secondPoint) {
        return Math.max(firstPoint.getY(), secondPoint.getY());
    }

    public static int getMinZ(SerializableBlock firstPoint, SerializableBlock secondPoint) {
        return Math.min(firstPoint.getZ(), secondPoint.getZ());
    }

    public static int getMaxZ(SerializableBlock firstPoint, SerializableBlock secondPoint) {
        return Math.max(firstPoint.getZ(), secondPoint.getZ());
    }

    public int getVolume() {
        int width = this.getMaxX() - this.getMinX() + 1;
        int height = this.getMaxY() - this.getMinY() + 1;
        int depth = this.getMaxZ() - this.getMinZ() + 1;
        return width * height * depth;
    }

    public static int getVolume(SerializableBlock firstPoint, SerializableBlock secondPoint) {
        int width = SerializableSubArea.getMaxX(firstPoint, secondPoint) - SerializableSubArea.getMinX(firstPoint, secondPoint) + 1;
        int height = SerializableSubArea.getMaxY(firstPoint, secondPoint) - SerializableSubArea.getMinY(firstPoint, secondPoint) + 1;
        int depth = SerializableSubArea.getMaxZ(firstPoint, secondPoint) - SerializableSubArea.getMinZ(firstPoint, secondPoint) + 1;
        return width * height * depth;
    }

    public boolean isBlockInside(Block block) {
        return block.getX() >= this.getMinX() && block.getX() <= this.getMaxX() && block.getY() >= this.getMinY() && block.getY() <= this.getMaxY() && block.getZ() >= this.getMinZ() && block.getZ() <= this.getMaxZ();
    }

    public boolean isLocationInside(Location location) {
        if (location == null || location.getWorld() == null) {
            return false;
        }
        World subAreaWorld = this.getFirstPoint().getWorld();
        if (!location.getWorld().equals((Object)subAreaWorld)) {
            return false;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        return this.isInsideBounds(x, y, z);
    }

    public boolean isIntersectingOtherSubArea(SerializableBlock firstPoint, SerializableBlock secondPoint) {
        if (!this.getFirstPoint().getWorld().equals((Object)firstPoint.getWorld())) {
            return false;
        }
        Block thisFirstPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point1);
        Block thisSecondPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point2);
        int minX1 = Math.min(thisFirstPoint.getX(), thisSecondPoint.getX());
        int minY1 = Math.min(thisFirstPoint.getY(), thisSecondPoint.getY());
        int minZ1 = Math.min(thisFirstPoint.getZ(), thisSecondPoint.getZ());
        int maxX1 = Math.max(thisFirstPoint.getX(), thisSecondPoint.getX());
        int maxY1 = Math.max(thisFirstPoint.getY(), thisSecondPoint.getY());
        int maxZ1 = Math.max(thisFirstPoint.getZ(), thisSecondPoint.getZ());
        int minX2 = Math.min(firstPoint.getX(), secondPoint.getX());
        int minY2 = Math.min(firstPoint.getY(), secondPoint.getY());
        int minZ2 = Math.min(firstPoint.getZ(), secondPoint.getZ());
        int maxX2 = Math.max(firstPoint.getX(), secondPoint.getX());
        int maxY2 = Math.max(firstPoint.getY(), secondPoint.getY());
        int maxZ2 = Math.max(firstPoint.getZ(), secondPoint.getZ());
        return minX1 <= maxX2 && maxX1 >= minX2 && minY1 <= maxY2 && maxY1 >= minY2 && minZ1 <= maxZ2 && maxZ1 >= minZ2;
    }

    private boolean isInsideBounds(int x, int y, int z) {
        Block firstPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point1);
        Block secondPoint = SerializableSubArea.parseBlockLocation(this.getWorld(), this.point2);
        int minX = Math.min(firstPoint.getX(), secondPoint.getX());
        int minY = Math.min(firstPoint.getY(), secondPoint.getY());
        int minZ = Math.min(firstPoint.getZ(), secondPoint.getZ());
        int maxX = Math.max(firstPoint.getX(), secondPoint.getX());
        int maxY = Math.max(firstPoint.getY(), secondPoint.getY());
        int maxZ = Math.max(firstPoint.getZ(), secondPoint.getZ());
        return x >= minX && x <= maxX && y >= minY && y <= maxY && z >= minZ && z <= maxZ;
    }

    public String toString() {
        return String.valueOf(this.id) + "," + String.valueOf(this.regionId) + "," + this.name + "," + this.worldName + "," + SerializableSubArea.toStringBlockLocation(this.getWorld(), this.point1) + "," + SerializableSubArea.toStringBlockLocation(this.getWorld(), this.point2) + "," + this.flags + "," + this.createdAt;
    }

    public static String toStringBlockLocation(World world, int[] coords) {
        return SerializableSubArea.toStringBlockLocation(world, SerializableSubArea.parseBlockLocation(world, coords));
    }

    public static String toStringBlockLocation(World world, Block block) {
        return world.getName() + ";" + block.getX() + ";" + block.getY() + ";" + block.getZ();
    }

    public static SerializableSubArea fromString(String string) {
        if (string == null) {
            return null;
        }
        String[] splitted = string.split(",");
        World world = Bukkit.getWorld((String)splitted[3]);
        return new SerializableSubArea(UUID.fromString(splitted[0]), UUID.fromString(splitted[1]), splitted[2], splitted[3], SerializableSubArea.parseBlockLocation(world, splitted[4]), SerializableSubArea.parseBlockLocation(world, splitted[5]), Long.parseLong(splitted[6]), Long.parseLong(splitted[7]));
    }

    public static Block parseBlockLocation(World world, int[] coords) {
        return new Location(world, (double)coords[0], (double)coords[1], (double)coords[2]).getBlock();
    }

    public static Block parseBlockLocation(World world, String coordsString) {
        String[] splitted = coordsString.split(";");
        int[] coords = new int[]{Integer.parseInt(splitted[1]), Integer.parseInt(splitted[2]), Integer.parseInt(splitted[3])};
        return SerializableSubArea.parseBlockLocation(world, coords);
    }

    public static int[] getBlockLocation(Block block) {
        return new int[]{block.getX(), block.getY(), block.getZ()};
    }
}

