/*
 * Decompiled with CFR 0.152.
 */
package com.technicjelle.BMUtils;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public class BMCopy {
    private BMCopy() {
        throw new IllegalStateException("Utility class");
    }

    public static void streamToWebApp(@NotNull BlueMapAPI blueMapAPI, @NotNull InputStream in, @NotNull String toAsset, boolean overwrite) throws IOException {
        Path toPath = blueMapAPI.getWebApp().getWebRoot().resolve("assets").resolve(toAsset);
        String assetPath = "assets/" + toAsset;
        if (toAsset.endsWith(".js")) {
            blueMapAPI.getWebApp().registerScript(assetPath);
        }
        if (toAsset.endsWith(".css")) {
            blueMapAPI.getWebApp().registerStyle(assetPath);
        }
        if (Files.exists(toPath, new LinkOption[0]) && !overwrite) {
            return;
        }
        Files.createDirectories(toPath.getParent(), new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(toPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            in.transferTo(out);
        }
    }

    public static void streamToMap(@NotNull BlueMapMap map, @NotNull InputStream in, @NotNull String toAsset, boolean overwrite) throws IOException {
        if (map.getAssetStorage().assetExists(toAsset) && !overwrite) {
            return;
        }
        try (OutputStream out = map.getAssetStorage().writeAsset(toAsset);){
            in.transferTo(out);
        }
    }

    public static void fileToWebApp(@NotNull BlueMapAPI blueMapAPI, @NotNull Path from, @NotNull String toAsset, boolean overwrite) throws IOException {
        try (InputStream in = Files.newInputStream(from, new OpenOption[0]);){
            BMCopy.streamToWebApp(blueMapAPI, in, toAsset, overwrite);
        }
    }

    public static void fileToMap(@NotNull BlueMapMap map, @NotNull Path from, @NotNull String toAsset, boolean overwrite) throws IOException {
        try (InputStream in = Files.newInputStream(from, new OpenOption[0]);){
            BMCopy.streamToMap(map, in, toAsset, overwrite);
        }
    }

    public static void jarResourceToWebApp(@NotNull BlueMapAPI blueMapAPI, @NotNull ClassLoader classLoader, @NotNull String fromResource, @NotNull String toAsset, boolean overwrite) throws IOException {
        try (InputStream in = classLoader.getResourceAsStream(fromResource);){
            if (in == null) {
                throw new IOException("Resource not found: " + fromResource);
            }
            BMCopy.streamToWebApp(blueMapAPI, in, toAsset, overwrite);
        }
    }

    public static void jarResourceToMap(@NotNull BlueMapMap map, @NotNull ClassLoader classLoader, @NotNull String fromResource, @NotNull String toAsset, boolean overwrite) throws IOException {
        try (InputStream in = classLoader.getResourceAsStream(fromResource);){
            if (in == null) {
                throw new IOException("Resource not found: " + fromResource);
            }
            BMCopy.streamToMap(map, in, toAsset, overwrite);
        }
    }
}

