/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands.subcommands.admin;

import java.io.File;
import java.util.HashSet;
import org.bukkit.command.CommandSender;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.commands.SubCommandBuilder;
import tfagaming.projects.minecraft.homestead.config.ConfigLoader;
import tfagaming.projects.minecraft.homestead.config.LanguageLoader;
import tfagaming.projects.minecraft.homestead.config.MenusConfigLoader;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;
import tfagaming.projects.minecraft.homestead.tools.validator.YAMLValidator;

public class ReloadSubCmd
extends SubCommandBuilder {
    public ReloadSubCmd() {
        super("reload");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        Homestead instance = Homestead.getInstance();
        try {
            YAMLValidator menusConfigValidator;
            YAMLValidator languageValidator;
            Homestead.config = new ConfigLoader(instance);
            Homestead.language = new LanguageLoader(instance, (String)Homestead.config.get("language"));
            Homestead.menusConfig = new MenusConfigLoader(instance);
            HashSet<String> skipKeys = new HashSet<String>();
            YAMLValidator configValidator = new YAMLValidator("config.yml", new File(instance.getDataFolder(), "config.yml"), skipKeys);
            if (!configValidator.validate()) {
                boolean fixed = configValidator.fix();
                if (fixed) {
                    Homestead.config = new ConfigLoader(instance);
                } else {
                    throw new Exception("Unable to fix the config.yml file.");
                }
            }
            if (!(languageValidator = new YAMLValidator("en-US.yml", Homestead.language.getLanguageFile((String)Homestead.config.get("language")))).validate()) {
                boolean fixed = languageValidator.fix();
                if (fixed) {
                    Homestead.language = new LanguageLoader(instance, (String)Homestead.config.get("language"));
                } else {
                    throw new Exception("Unable to fix the config.yml file.");
                }
            }
            if (!(menusConfigValidator = new YAMLValidator("menus.yml", new File(instance.getDataFolder(), "menus.yml"), skipKeys)).validate()) {
                boolean fixed = menusConfigValidator.fix();
                if (fixed) {
                    Homestead.menusConfig = new MenusConfigLoader(instance);
                } else {
                    throw new Exception("Unable to fix the config.yml file.");
                }
            }
            PlayerUtils.sendMessage(sender, 90);
        }
        catch (Exception e) {
            System.out.println(e);
            PlayerUtils.sendMessage(sender, 87);
        }
        return true;
    }
}

