/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.flags;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;

public class RegionControlFlags {
    public static final long TRUST_PLAYERS = 1L;
    public static final long UNTRUST_PLAYERS = 2L;
    public static final long BAN_PLAYERS = 4L;
    public static final long UNBAN_PLAYERS = 8L;
    public static final long CLAIM_CHUNKS = 16L;
    public static final long UNCLAIM_CHUNKS = 32L;
    public static final long DEPOSIT_MONEY = 64L;
    public static final long WITHDRAW_MONEY = 128L;
    public static final long SET_GLOBAL_FLAGS = 256L;
    public static final long SET_WORLD_FLAGS = 512L;
    public static final long SET_MEMBER_FLAGS = 1024L;
    public static final long SET_SPAWN = 2048L;
    public static final long MANAGE_SUBAREAS = 4096L;
    public static final long RENAME_REGION = 8192L;
    public static final long SET_DESCRIPTION = 16384L;
    public static final long MANAGE_LOGS = 32768L;
    public static final long KICK_PLAYERS = 65536L;
    public static final long SET_WEATHER_AND_TIME = 131072L;

    public static List<String> getFlags() {
        return Lists.newArrayList((Object[])new String[]{"trust-players", "untrust-players", "ban-players", "unban-players", "claim-chunks", "unclaim-chunks", "deposit-money", "withdraw-money", "set-global-flags", "set-world-flags", "set-member-flags", "set-spawn", "manage-subareas", "rename-region", "set-description", "manage-logs", "kick-players", "set-weather-and-time"});
    }

    public static long valueOf(String name) {
        List<String> flags = RegionControlFlags.getFlags();
        if (flags.indexOf(name) == 0) {
            return 1L;
        }
        return 1L << flags.indexOf(name);
    }

    public static String from(long flag) {
        List<String> flags = RegionControlFlags.getFlags();
        for (int i = 0; i < flags.size(); ++i) {
            long value = RegionControlFlags.valueOf(flags.get(i));
            if (value != flag) continue;
            return flags.get(i);
        }
        return "unknown-flag";
    }

    public static List<String> getSet(long flags) {
        List<String> allFlags = RegionControlFlags.getFlags();
        ArrayList<String> enabledFlags = new ArrayList<String>();
        for (String flag : allFlags) {
            long flagValue = RegionControlFlags.valueOf(flag);
            if (!FlagsCalculator.isFlagSet(flags, flagValue)) continue;
            enabledFlags.add(flag);
        }
        return enabledFlags;
    }

    public static List<String> getUnset(long flags) {
        List<String> allFlags = RegionControlFlags.getFlags();
        ArrayList<String> disabledFlags = new ArrayList<String>();
        for (String flag : allFlags) {
            long flagValue = RegionControlFlags.valueOf(flag);
            if (FlagsCalculator.isFlagSet(flags, flagValue)) continue;
            disabledFlags.add(flag);
        }
        return disabledFlags;
    }
}

