/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.gui.InventoryManager;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chat.ChatColorTranslator;

public class Menu
implements Listener {
    private final Homestead plugin = Homestead.getInstance();
    private final Inventory inventory;
    private final Map<Integer, BiConsumer<Player, InventoryClickEvent>> callbacks;

    public Menu(String title, int size) {
        this.inventory = Bukkit.createInventory(null, (int)size, (String)ChatColorTranslator.translate(title));
        this.callbacks = new HashMap<Integer, BiConsumer<Player, InventoryClickEvent>>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public Menu(String title, int size, boolean beautiful) {
        this.inventory = Bukkit.createInventory(null, (int)size, (String)ChatColorTranslator.translate(title));
        this.callbacks = new HashMap<Integer, BiConsumer<Player, InventoryClickEvent>>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public void addItem(int slot, ItemStack itemStack, BiConsumer<Player, InventoryClickEvent> callback) {
        if (slot < 0 || slot >= this.inventory.getSize()) {
            return;
        }
        this.inventory.setItem(slot, itemStack);
        this.callbacks.put(slot, callback);
    }

    public void open(Player player) {
        player.openInventory(this.inventory);
        InventoryManager.register(player, this);
    }

    public void open(Player player, ItemStack filler) {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, filler);
        }
        player.openInventory(this.inventory);
        InventoryManager.register(player, this);
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onInventoryClick(final InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        if (InventoryManager.getMenu(player) == this && event.getInventory().equals((Object)this.inventory)) {
            event.setCancelled(true);
            final int slot = event.getRawSlot();
            if (this.callbacks.containsKey(slot)) {
                new BukkitRunnable(){

                    public void run() {
                        Menu.this.callbacks.get(slot).accept(player, event);
                    }
                }.runTask((Plugin)this.plugin);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (InventoryManager.getMenu(player) == this) {
            InventoryManager.unregister(player);
            if (!InventoryManager.hasMenu(player)) {
                this.unregister();
            }
        }
    }
}

