/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;
import tfagaming.projects.minecraft.homestead.flags.PlayerFlags;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionMembersMenu;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class MemberPlayerFlagsMenu {
    private final HashSet<UUID> cooldowns = new HashSet();
    private static final int BULK_INDEX = 0;

    public MemberPlayerFlagsMenu(Player player, Region region, SerializableMember member) {
        List<ItemStack> items = this.buildItemsList(member);
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(6).replace("{playername}", member.getBukkitOfflinePlayer().getName()), 45, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), items, (_player, event) -> new RegionMembersMenu(player, region), (_player, context) -> {
            if (this.cooldowns.contains(player.getUniqueId())) {
                return;
            }
            if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 1024L)) {
                return;
            }
            int index = context.getIndex();
            if (index == 0) {
                long current;
                boolean enableAll = context.getEvent().isLeftClick();
                boolean disableAll = context.getEvent().isRightClick();
                if (!enableAll && !disableAll) {
                    return;
                }
                List disabledFlags = (List)Homestead.config.get("disabled-flags");
                long newFlags = current = member.getFlags();
                int changed = 0;
                for (String flagString : PlayerFlags.getFlags()) {
                    if (disabledFlags.contains(flagString)) continue;
                    long flag = PlayerFlags.valueOf(flagString);
                    boolean isSet = FlagsCalculator.isFlagSet(newFlags, flag);
                    if (enableAll && !isSet) {
                        newFlags = FlagsCalculator.addFlag(newFlags, flag);
                        ++changed;
                        continue;
                    }
                    if (!disableAll || !isSet) continue;
                    newFlags = FlagsCalculator.removeFlag(newFlags, flag);
                    ++changed;
                }
                if (changed > 0) {
                    region.setMemberFlags(member, newFlags);
                    player.playSound(player.getLocation(), Sound.BLOCK_LEVER_CLICK, 500.0f, 1.0f);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Bulk change applied: " + String.valueOf(ChatColor.WHITE) + changed + String.valueOf(ChatColor.GREEN) + " flag(s) " + (enableAll ? "enabled" : "disabled") + String.valueOf(ChatColor.GRAY) + " (locked flags were skipped).");
                    PaginationMenu instance = context.getInstance();
                    instance.setItems(this.buildItemsList(member));
                    this.cooldowns.add(player.getUniqueId());
                    Homestead.getInstance().runAsyncTaskLater(() -> this.cooldowns.remove(player.getUniqueId()), 1);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "No changes were made (either already in desired state or all relevant flags are locked).");
                }
                return;
            }
            int flagListIndex = index - 1;
            if (flagListIndex < 0 || flagListIndex >= PlayerFlags.getFlags().size()) {
                return;
            }
            String flagString = PlayerFlags.getFlags().get(flagListIndex);
            List disabledFlags = (List)Homestead.config.get("disabled-flags");
            if (disabledFlags.contains(flagString)) {
                PlayerUtils.sendMessage(player, 42);
                return;
            }
            long flag = PlayerFlags.valueOf(flagString);
            if (context.getEvent().isLeftClick()) {
                PaginationMenu instance = context.getInstance();
                long flags = member.getFlags();
                boolean isSet = FlagsCalculator.isFlagSet(flags, flag);
                long newFlags = isSet ? FlagsCalculator.removeFlag(flags, flag) : FlagsCalculator.addFlag(flags, flag);
                region.setMemberFlags(member, newFlags);
                this.cooldowns.add(player.getUniqueId());
                player.playSound(player.getLocation(), Sound.BLOCK_LEVER_CLICK, 500.0f, 1.0f);
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{flag}", flagString);
                replacements.put("{state}", Formatters.getFlag(!isSet));
                replacements.put("{region}", region.getName());
                replacements.put("{player}", member.getBukkitOfflinePlayer().getName());
                PlayerUtils.sendMessage(player, 43, replacements);
                instance.replaceSlot(index, MenuUtils.getFlagButton(flagString, !isSet));
                Homestead.getInstance().runAsyncTaskLater(() -> this.cooldowns.remove(player.getUniqueId()), 1);
            }
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }

    private List<ItemStack> buildItemsList(SerializableMember member) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack bulk = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta meta = bulk.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "Bulk toggle flags");
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(String.valueOf(ChatColor.GRAY) + "Toggle all flags at once");
        lore.add(String.valueOf(ChatColor.DARK_GRAY) + "(locked flags in config are skipped).");
        lore.add("");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Left-click: " + String.valueOf(ChatColor.WHITE) + "Enable all");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right-click: " + String.valueOf(ChatColor.WHITE) + "Disable all");
        meta.setLore(lore);
        bulk.setItemMeta(meta);
        items.add(bulk);
        for (String flagString : PlayerFlags.getFlags()) {
            boolean value = FlagsCalculator.isFlagSet(member.getFlags(), PlayerFlags.valueOf(flagString));
            items.add(MenuUtils.getFlagButton(flagString, value));
        }
        return items;
    }
}

