/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLocation;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.java.NumberUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class CustomSignsLisntener
implements Listener {
    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        Player player = event.getPlayer();
        String[] lines = event.getLines();
        if (lines.length < 1) {
            return;
        }
        String firstLine = lines[0].trim();
        boolean breakBlock = false;
        switch (firstLine.toLowerCase()) {
            case "[welcome]": {
                breakBlock = this.handleWelcomeSign(event, player, lines);
                break;
            }
            case "[rent]": {
                breakBlock = this.handleRentSign(event, player, lines);
                break;
            }
            case "[sell]": {
                breakBlock = this.handleSellSign(event, player, lines);
                break;
            }
            default: {
                return;
            }
        }
        if (breakBlock) {
            event.getBlock().breakNaturally();
        }
    }

    @EventHandler
    public void onPlayerRightClickSign(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        if (!(clickedBlock.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)clickedBlock.getState();
        String[] lines = sign.getSide(Side.FRONT).getLines();
        if (lines.length == 0) {
            return;
        }
        String firstLine = lines[0].trim();
        String strippedFirstLine = ChatColor.stripColor((String)firstLine);
        switch (strippedFirstLine.toLowerCase()) {
            case "[welcome]": {
                event.setCancelled(true);
                PlayerUtils.sendMessage(player, 123);
                break;
            }
            case "[rent]": {
                event.setCancelled(true);
                this.handleRentSignInteraction(player, lines, event.getClickedBlock());
                break;
            }
            case "[sell]": {
                event.setCancelled(true);
                this.handleSellSignInteraction(player, lines, event.getClickedBlock());
                break;
            }
        }
    }

    @EventHandler
    public void onSignBreak(BlockBreakEvent event) {
        Chunk chunk = event.getBlock().getChunk();
        if (ChunksManager.isChunkClaimed(chunk) && event.getBlock() != null && event.getBlock().getType().toString().toLowerCase().contains("sign")) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            BlockState state = event.getBlock().getState();
            Sign sign = (Sign)state;
            String[] lines = sign.getSide(Side.FRONT).getLines();
            ArrayList<String> cleanLines = new ArrayList<String>();
            for (String line : lines) {
                cleanLines.add(ChatColor.stripColor((String)line));
            }
            if (lines.length > 0 && ChatColor.stripColor((String)lines[0]).equalsIgnoreCase("[Welcome]")) {
                region.setWelcomeSign(null);
            }
        }
    }

    private boolean handleWelcomeSign(SignChangeEvent event, Player player, String[] lines) {
        if (!Homestead.config.isWelcomeSignEnabled()) {
            PlayerUtils.sendMessage(player, 105);
            return true;
        }
        if (lines.length < 4) {
            PlayerUtils.sendMessage(player, 120);
            return true;
        }
        Region region = this.validateRegion(player, event.getBlock().getChunk());
        if (region == null) {
            return true;
        }
        if (!lines[2].trim().isEmpty() || !lines[3].trim().isEmpty()) {
            PlayerUtils.sendMessage(player, 121);
            return true;
        }
        event.setLine(0, String.valueOf(ChatColor.GREEN) + "[Welcome]");
        event.setLine(1, String.valueOf(ChatColor.DARK_GREEN) + region.getName());
        event.setLine(2, "");
        event.setLine(3, "");
        region.setWelcomeSign(new SerializableLocation(event.getBlock().getLocation()));
        return false;
    }

    private boolean handleRentSign(SignChangeEvent event, Player player, String[] lines) {
        boolean isEnabled = (Boolean)Homestead.config.get("renting.enabled");
        if (!isEnabled) {
            PlayerUtils.sendMessage(player, 105);
            return true;
        }
        if (lines.length < 4) {
            PlayerUtils.sendMessage(player, 120);
            return true;
        }
        Region region = this.validateRegion(player, event.getBlock().getChunk());
        if (region == null) {
            return true;
        }
        String priceStr = lines[2].trim();
        if (!NumberUtils.isValidDouble(priceStr)) {
            PlayerUtils.sendMessage(player, 122);
            return true;
        }
        double price = Double.parseDouble(priceStr);
        double minRent = (Double)Homestead.config.get("renting.min-rent");
        double maxRent = (Double)Homestead.config.get("renting.max-rent");
        if (price < minRent || price > maxRent) {
            PlayerUtils.sendMessage(player, 122);
            return true;
        }
        String durationStr = lines[3].trim();
        long durationMs = this.parseDurationToMillis(durationStr);
        if (durationMs <= 0L || durationMs > 6048000000L) {
            PlayerUtils.sendMessage(player, 129);
            return true;
        }
        event.setLine(0, String.valueOf(ChatColor.GREEN) + "[Rent]");
        event.setLine(1, String.valueOf(ChatColor.DARK_GREEN) + region.getName());
        event.setLine(2, String.valueOf(ChatColor.RED) + Formatters.formatBalance(price));
        event.setLine(3, String.valueOf(ChatColor.GOLD) + this.formatMillisToReadable(durationMs));
        return false;
    }

    private boolean handleSellSign(SignChangeEvent event, Player player, String[] lines) {
        boolean isEnabled = (Boolean)Homestead.config.get("selling.enabled");
        if (!isEnabled) {
            PlayerUtils.sendMessage(player, 105);
            return true;
        }
        if (lines.length < 4) {
            PlayerUtils.sendMessage(player, 120);
            return true;
        }
        Region region = this.validateRegion(player, event.getBlock().getChunk());
        if (region == null) {
            return true;
        }
        String priceStr = lines[2].trim();
        if (!NumberUtils.isValidDouble(priceStr)) {
            PlayerUtils.sendMessage(player, 122);
            return true;
        }
        double price = Double.parseDouble(priceStr);
        double minSell = (Double)Homestead.config.get("selling.min-sell");
        double maxSell = (Double)Homestead.config.get("selling.max-sell");
        if (price < minSell || price > maxSell) {
            PlayerUtils.sendMessage(player, 122);
            return true;
        }
        if (!lines[3].trim().isEmpty()) {
            PlayerUtils.sendMessage(player, 121);
            return true;
        }
        event.setLine(0, String.valueOf(ChatColor.GREEN) + "[Sell]");
        event.setLine(1, String.valueOf(ChatColor.DARK_GREEN) + region.getName());
        event.setLine(2, String.valueOf(ChatColor.RED) + Formatters.formatBalance(price));
        event.setLine(3, "");
        return false;
    }

    private Region validateRegion(Player player, Chunk chunk) {
        Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
        if (region == null || region != null && !region.getOwnerId().equals(player.getUniqueId())) {
            PlayerUtils.sendMessage(player, 119);
            return null;
        }
        return region;
    }

    private long parseDurationToMillis(String duration) {
        if (duration == null || duration.isEmpty()) {
            return 0L;
        }
        try {
            String numStr = duration.replaceAll("[^0-9]", "");
            if (numStr.isEmpty()) {
                return 0L;
            }
            long num = Long.parseLong(numStr);
            char unit = duration.replaceAll("[0-9]", "").toLowerCase().charAt(0);
            switch (unit) {
                case 's': {
                    return num * 1000L;
                }
                case 'm': {
                    return num * 60L * 1000L;
                }
                case 'h': {
                    return num * 60L * 60L * 1000L;
                }
                case 'd': {
                    return num * 24L * 60L * 60L * 1000L;
                }
                case 'w': {
                    return num * 7L * 24L * 60L * 60L * 1000L;
                }
            }
            return 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private String formatMillisToReadable(long millis) {
        if (millis < 1000L) {
            return millis + "ms";
        }
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) % 60L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) % 60L;
        long hours = TimeUnit.MILLISECONDS.toHours(millis) % 24L;
        long days = TimeUnit.MILLISECONDS.toDays(millis) % 7L;
        long weeks = TimeUnit.MILLISECONDS.toDays(millis) / 7L;
        StringBuilder sb = new StringBuilder();
        if (weeks > 0L) {
            sb.append(weeks).append(weeks == 1L ? " Week " : " Weeks ");
        }
        if (days > 0L) {
            sb.append(days).append(days == 1L ? " Day " : " Days ");
        }
        if (hours > 0L) {
            sb.append(hours).append(hours == 1L ? " Hour " : " Hours ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append(minutes == 1L ? " Minute " : " Minutes ");
        }
        if (seconds > 0L) {
            sb.append(seconds).append(seconds == 1L ? " Second" : " Seconds");
        }
        return sb.toString().trim();
    }

    private void handleRentSignInteraction(Player player, String[] lines, Block sign) {
        try {
            String regionName = ChatColor.stripColor((String)lines[1].trim());
            String priceStr = ChatColor.stripColor((String)lines[2].trim());
            double price = this.parseFormattedPrice(priceStr);
            String durationStr = ChatColor.stripColor((String)lines[3].trim());
            long durationMs = this.parseFormattedDuration(durationStr);
            Region region = RegionsManager.findRegion(regionName);
            if (region == null) {
                PlayerUtils.sendMessage(player, 9);
                return;
            }
            if (region.getOwnerId().equals(player.getUniqueId()) || region.isPlayerBanned((OfflinePlayer)player)) {
                PlayerUtils.sendMessage(player, 30);
                return;
            }
            if (price > PlayerUtils.getBalance((OfflinePlayer)player)) {
                PlayerUtils.sendMessage(player, 125);
                return;
            }
            long rentEnd = System.currentTimeMillis() + durationMs;
            PlayerUtils.removeBalance((OfflinePlayer)player, price);
            PlayerUtils.addBalance(region.getOwner(), price);
            SerializableRent rent = new SerializableRent((OfflinePlayer)player, price, rentEnd);
            region.setRent(rent);
            sign.breakNaturally();
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            replacements.put("{rent-end}", Formatters.formatRemainingTime(rentEnd));
            PlayerUtils.sendMessage(player, 126, replacements);
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Error: This rent sign has invalid formatting!");
        }
    }

    private void handleSellSignInteraction(Player player, String[] lines, Block sign) {
        try {
            String regionName = ChatColor.stripColor((String)lines[1].trim());
            String priceStr = ChatColor.stripColor((String)lines[2].trim());
            double price = this.parseFormattedPrice(priceStr);
            Region region = RegionsManager.findRegion(regionName);
            if (region == null) {
                PlayerUtils.sendMessage(player, 9);
                return;
            }
            if (region.getOwnerId().equals(player.getUniqueId()) || region.isPlayerBanned((OfflinePlayer)player)) {
                PlayerUtils.sendMessage(player, 30);
                return;
            }
            if (price > PlayerUtils.getBalance((OfflinePlayer)player)) {
                PlayerUtils.sendMessage(player, 125);
                return;
            }
            PlayerUtils.removeBalance((OfflinePlayer)player, price);
            PlayerUtils.addBalance(region.getOwner(), price);
            region.setOwner((OfflinePlayer)player);
            sign.breakNaturally();
            if (region.isPlayerMember((OfflinePlayer)player)) {
                region.removeMember((OfflinePlayer)player);
            }
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            replacements.put("{price}", Formatters.formatBalance(price));
            PlayerUtils.sendMessage(player, 124, replacements);
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Error: This sell sign has invalid formatting!");
        }
    }

    private double parseFormattedPrice(String input) throws NumberFormatException {
        String cleanInput = input.replaceAll("[^0-9.,]", "").trim();
        if (cleanInput.matches(".*,\\d{2}$")) {
            cleanInput = cleanInput.replace(".", "").replace(",", ".");
        } else if (cleanInput.matches(".*\\.\\d{2}$")) {
            cleanInput = cleanInput.replace(",", "");
        } else if (cleanInput.chars().filter(c -> c == 44 || c == 46).count() == 1L) {
            cleanInput = cleanInput.replace(",", "").replace(".", "");
        }
        if (input.toLowerCase().contains("k")) {
            return Double.parseDouble(cleanInput) * 1000.0;
        }
        if (input.toLowerCase().contains("m")) {
            return Double.parseDouble(cleanInput) * 1000000.0;
        }
        if (input.toLowerCase().contains("b")) {
            return Double.parseDouble(cleanInput) * 1.0E9;
        }
        return Double.parseDouble(cleanInput);
    }

    private long parseFormattedDuration(String input) throws NumberFormatException {
        if ((input = input.toLowerCase()).contains("second")) {
            double seconds = Double.parseDouble(input.replaceAll("[^0-9.]", ""));
            return (long)(seconds * 1000.0);
        }
        if (input.contains("minute")) {
            double minutes = Double.parseDouble(input.replaceAll("[^0-9.]", ""));
            return (long)(minutes * 60.0 * 1000.0);
        }
        if (input.contains("hour")) {
            double hours = Double.parseDouble(input.replaceAll("[^0-9.]", ""));
            return (long)(hours * 60.0 * 60.0 * 1000.0);
        }
        if (input.contains("day")) {
            double days = Double.parseDouble(input.replaceAll("[^0-9.]", ""));
            return (long)(days * 24.0 * 60.0 * 60.0 * 1000.0);
        }
        if (input.contains("week")) {
            double weeks = Double.parseDouble(input.replaceAll("[^0-9.]", ""));
            return (long)(weeks * 7.0 * 24.0 * 60.0 * 60.0 * 1000.0);
        }
        return this.parseDurationToMillis(input);
    }
}

