/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.logs;

import org.bukkit.Bukkit;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.LogsFile;

public class Logger {
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger("Homestead");
    private static LogsFile logs;

    public Logger() {
        logs = new LogsFile();
        this.sendPluginBanner();
    }

    public void sendPluginBanner() {
        Object lineSplitter = "";
        for (int i = 0; i < 54; ++i) {
            lineSplitter = (String)lineSplitter + "-";
        }
        String banner = " _   _                           _                 _ \r\n| | | | ___  _ __ ___   ___  ___| |_ ___  __ _  __| |\r\n| |_| |/ _ \\| '_ ` _ \\ / _ \\/ __| __/ _ \\/ _` |/ _` |\r\n|  _  | (_) | | | | | |  __/\\__ \\ ||  __/ (_| | (_| |\r\n|_| |_|\\___/|_| |_| |_|\\___||___/\\__\\___|\\__,_|\\__,_|\n\nVersion: " + Homestead.getVersion() + "\nRunning on " + Bukkit.getName() + ": " + Bukkit.getVersion();
        logger.info((String)lineSplitter);
        for (String line : banner.split("\n")) {
            logger.info("\u001b[36m" + line + "\u001b[0m");
        }
        logger.info((String)lineSplitter);
    }

    public static void info(String message) {
        logger.info(message);
        logs.save("[INFO] " + message);
    }

    public static void info(String message, Object ... noSave) {
        logger.info(message);
    }

    public static void info(String ... args) {
        Logger.info(String.join((CharSequence)" ", args));
    }

    public static void notice(String message) {
        logger.info("\u001b[36m" + message + "\u001b[0m");
        logs.save("[NOTICE] " + message);
    }

    public static void notice(String message, Object ... noSave) {
        logger.info("\u001b[36m" + message + "\u001b[0m");
    }

    public static void notice(String ... args) {
        Logger.notice(String.join((CharSequence)" ", args));
    }

    public static void warning(String message) {
        logger.warning("\u001b[33m" + message + "\u001b[0m");
        logs.save("[WARNING] " + message);
    }

    public static void warning(String message, Object ... noSave) {
        logger.warning("\u001b[33m" + message + "\u001b[0m");
    }

    public static void warning(String ... args) {
        Logger.warning(String.join((CharSequence)" ", args));
    }

    public static void error(String message) {
        logger.severe("\u001b[31m" + message + "\u001b[0m");
        logs.save("[ERROR] " + message);
    }

    public static void error(String message, Object ... noSave) {
        logger.severe("\u001b[31m" + message + "\u001b[0m");
    }

    public static void error(String ... args) {
        Logger.error(String.join((CharSequence)" ", args));
    }

    public class Colors {
        public static final String RED = "\u001b[31m";
        public static final String YELLOW = "\u001b[33m";
        public static final String GREEN = "\u001b[32m";
        public static final String BLUE = "\u001b[34m";
        public static final String CYAN = "\u001b[36m";
        public static final String _RESET = "\u001b[0m";

        public Colors(Logger this$0) {
        }
    }
}

