/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.particles;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBlock;

public class SelectedAreaParticlesSpawner {
    private static final Map<UUID, BukkitTask> tasks = new HashMap<UUID, BukkitTask>();
    private final Player player;
    private final SerializableBlock firstBlock;
    private final SerializableBlock secondBlock;

    public SelectedAreaParticlesSpawner(Player player, Block firstBlock, Block secondBlock) {
        this.player = player;
        this.firstBlock = new SerializableBlock(firstBlock);
        this.secondBlock = new SerializableBlock(secondBlock);
        if (tasks.containsKey(player.getUniqueId())) {
            BukkitTask taskFromMap = tasks.get(player.getUniqueId());
            SelectedAreaParticlesSpawner.cancelTask(taskFromMap, player);
        }
        this.startRepeatingEffect(15L);
    }

    public SelectedAreaParticlesSpawner(Player player, SerializableBlock firstBlock, SerializableBlock secondBlock) {
        this.player = player;
        this.firstBlock = firstBlock;
        this.secondBlock = secondBlock;
        if (tasks.containsKey(player.getUniqueId())) {
            BukkitTask taskFromMap = tasks.get(player.getUniqueId());
            SelectedAreaParticlesSpawner.cancelTask(taskFromMap, player);
        }
        this.startRepeatingEffect(15L);
    }

    public void spawnParticles() {
        int minX = Math.min(this.firstBlock.getX(), this.secondBlock.getX());
        int minY = Math.min(this.firstBlock.getY(), this.secondBlock.getY());
        int minZ = Math.min(this.firstBlock.getZ(), this.secondBlock.getZ());
        int maxX = Math.max(this.firstBlock.getX(), this.secondBlock.getX());
        int maxY = Math.max(this.firstBlock.getY(), this.secondBlock.getY());
        int maxZ = Math.max(this.firstBlock.getZ(), this.secondBlock.getZ());
        int step = 1;
        for (int x = minX; x <= maxX; x += step) {
            this.spawnDustParticle(x, minY, minZ);
            this.spawnDustParticle(x, minY, maxZ);
            this.spawnDustParticle(x, maxY, minZ);
            this.spawnDustParticle(x, maxY, maxZ);
        }
        for (int y = minY; y <= maxY; y += step) {
            this.spawnDustParticle(minX, y, minZ);
            this.spawnDustParticle(minX, y, maxZ);
            this.spawnDustParticle(maxX, y, minZ);
            this.spawnDustParticle(maxX, y, maxZ);
        }
        for (int z = minZ; z <= maxZ; z += step) {
            this.spawnDustParticle(minX, minY, z);
            this.spawnDustParticle(maxX, minY, z);
            this.spawnDustParticle(minX, maxY, z);
            this.spawnDustParticle(maxX, maxY, z);
        }
    }

    private void spawnDustParticle(int x, int y, int z) {
        Location location = new Location(this.player.getWorld(), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)0, (int)179, (int)255), 2.0f);
        this.player.spawnParticle(Particle.DUST, location, 5, (Object)dustOptions);
    }

    public void startRepeatingEffect(long intervalTicks) {
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                SelectedAreaParticlesSpawner.this.spawnParticles();
            }
        }.runTaskTimer((Plugin)Homestead.getInstance(), 0L, intervalTicks);
        tasks.put(this.player.getUniqueId(), task);
        Bukkit.getScheduler().runTaskLater((Plugin)Homestead.getInstance(), () -> SelectedAreaParticlesSpawner.cancelTask(task, this.player), 1200L);
    }

    public static void cancelTask(BukkitTask task, Player player) {
        if (task != null) {
            tasks.remove(player.getUniqueId());
            task.cancel();
            task = null;
        }
    }

    public static void cancelTask(Player player) {
        BukkitTask task = tasks.get(player.getUniqueId());
        if (task != null) {
            tasks.remove(player.getUniqueId());
            task.cancel();
            task = null;
        }
    }
}

